CREATE TABLE IF NOT EXISTS `fs_tns_spectra` (
  `primaryId` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'An internal counter',
  `TNSId` varchar(45) NOT NULL,
  `TNSuser` varchar(45) DEFAULT NULL,
  `dateCreated` datetime DEFAULT CURRENT_TIMESTAMP,
  `exptime` double DEFAULT NULL,
  `obsdate` datetime DEFAULT NULL,
  `reportAddedDate` datetime DEFAULT NULL,
  `specType` varchar(100) DEFAULT NULL,
  `survey` varchar(100) DEFAULT NULL,
  `telescope` varchar(100) DEFAULT NULL,
  `transRedshift` double DEFAULT NULL,
  `updated` tinyint(4) DEFAULT '0',
  `dateLastModified` datetime DEFAULT NULL,
  `remarks` VARCHAR(800) NULL DEFAULT NULL,
  `sourceComment` VARCHAR(800) NULL DEFAULT NULL,
  PRIMARY KEY (`primaryId`),
  UNIQUE KEY `u_tnsid_survey_obsdate` (`TNSId`,`survey`,`obsdate`),
  UNIQUE KEY `u_id_user_obsdate` (`TNSId`,`TNSuser`,`obsdate`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=latin1;
            
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2021avg" ,"sschulze" ,"1800" ,"2021-01-25 03:04:02" ,"2021-01-25 09:47:54" ,"SN II" ,"ZTF" ,"NOT_ALFOSC" ,"0.031", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021avg", `TNSuser`="sschulze", `exptime`="1800", `obsdate`="2021-01-25 03:04:02", `reportAddedDate`="2021-01-25 09:47:54", `specType`="SN II", `survey`="ZTF", `telescope`="NOT_ALFOSC", `transRedshift`="0.031" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2021aul" ,"ePESSTOplus_Bot1" ,"900" ,"2021-01-20 04:02:46" ,"2021-01-20 15:14:44" ,"SN II" ,"ePESSTO+" ,"ESO-NTT_EFOSC2-NTT" ,"0.04", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aul", `TNSuser`="ePESSTOplus_Bot1", `exptime`="900", `obsdate`="2021-01-20 04:02:46", `reportAddedDate`="2021-01-20 15:14:44", `specType`="SN II", `survey`="ePESSTO+", `telescope`="ESO-NTT_EFOSC2-NTT", `transRedshift`="0.04" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2021aqq" ,"saurabh" ,null ,"2021-01-18 09:41:46" ,"2021-01-18 23:46:03" ,"SN Ia" ,"SIRAH" ,"Lick-3m_KAST" ,"0.04918", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aqq", `TNSuser`="saurabh", `exptime`=null, `obsdate`="2021-01-18 09:41:46", `reportAddedDate`="2021-01-18 23:46:03", `specType`="SN Ia", `survey`="SIRAH", `telescope`="Lick-3m_KAST", `transRedshift`="0.04918" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2021apd" ,"crangus" ,null ,"2021-01-18 00:00:00" ,"2021-01-19 10:24:34" ,"SN Ia" ,"YSE" ,"NOT_ALFOSC" ,"0.1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021apd", `TNSuser`="crangus", `exptime`=null, `obsdate`="2021-01-18 00:00:00", `reportAddedDate`="2021-01-19 10:24:34", `specType`="SN Ia", `survey`="YSE", `telescope`="NOT_ALFOSC", `transRedshift`="0.1" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2021ajy" ,"ZTF_Bot1" ,"2700" ,"2021-01-15 11:44:14" ,"2021-01-21 03:41:12" ,"SN Ia" ,"ZTF" ,"P60_SEDM" ,"0.067496", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ajy", `TNSuser`="ZTF_Bot1", `exptime`="2700", `obsdate`="2021-01-15 11:44:14", `reportAddedDate`="2021-01-21 03:41:12", `specType`="SN Ia", `survey`="ZTF", `telescope`="P60_SEDM", `transRedshift`="0.067496" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2021yk" ,"jhinkle" ,"3020" ,"2021-01-14 10:20:54" ,"2021-01-14 20:58:47" ,"SN Ia" ,"SCAT" ,"UH88_SNIFS" ,"0.075345", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021yk", `TNSuser`="jhinkle", `exptime`="3020", `obsdate`="2021-01-14 10:20:54", `reportAddedDate`="2021-01-14 20:58:47", `specType`="SN Ia", `survey`="SCAT", `telescope`="UH88_SNIFS", `transRedshift`="0.075345" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2021xv" ,"sschulze" ,"1800" ,"2021-01-25 05:15:16" ,"2021-01-25 09:53:02" ,"SN Ic-BL" ,"ZTF" ,"NOT_ALFOSC" ,"0.05", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021xv", `TNSuser`="sschulze", `exptime`="1800", `obsdate`="2021-01-25 05:15:16", `reportAddedDate`="2021-01-25 09:53:02", `specType`="SN Ic-BL", `survey`="ZTF", `telescope`="NOT_ALFOSC", `transRedshift`="0.05" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2021gl" ,"ZTF_Bot1" ,"2700" ,"2021-01-06 07:33:52" ,"2021-01-06 23:32:01" ,"SN Ia" ,"ZTF" ,"P60_SEDM" ,"0.06", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021gl", `TNSuser`="ZTF_Bot1", `exptime`="2700", `obsdate`="2021-01-06 07:33:52", `reportAddedDate`="2021-01-06 23:32:01", `specType`="SN Ia", `survey`="ZTF", `telescope`="P60_SEDM", `transRedshift`="0.06" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2021fg" ,"ZTF_Bot1" ,"2700" ,"2021-01-14 07:13:53" ,"2021-01-18 04:42:02" ,"SN Ia" ,"ZTF" ,"P60_SEDM" ,"0.083", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021fg", `TNSuser`="ZTF_Bot1", `exptime`="2700", `obsdate`="2021-01-14 07:13:53", `reportAddedDate`="2021-01-18 04:42:02", `specType`="SN Ia", `survey`="ZTF", `telescope`="P60_SEDM", `transRedshift`="0.083" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2021at" ,"georgios_dimitriadis" ,null ,"2021-01-11 00:00:00" ,"2021-01-11 18:56:07" ,"SN Ia-91T-like" ,"UCSC" ,"Lick-3m_KAST" ,"0.111", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021at", `TNSuser`="georgios_dimitriadis", `exptime`=null, `obsdate`="2021-01-11 00:00:00", `reportAddedDate`="2021-01-11 18:56:07", `specType`="SN Ia-91T-like", `survey`="UCSC", `telescope`="Lick-3m_KAST", `transRedshift`="0.111" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2021ab" ,"ePESSTOplus_Bot1" ,"600" ,"2021-01-08 06:18:47" ,"2021-01-08 19:51:35" ,"SN Ia" ,"ePESSTO+" ,"ESO-NTT_EFOSC2-NTT" ,"0.07", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ab", `TNSuser`="ePESSTOplus_Bot1", `exptime`="600", `obsdate`="2021-01-08 06:18:47", `reportAddedDate`="2021-01-08 19:51:35", `specType`="SN Ia", `survey`="ePESSTO+", `telescope`="ESO-NTT_EFOSC2-NTT", `transRedshift`="0.07" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2021G" ,"tuckerma" ,"1800" ,"2021-01-05 12:02:44" ,"2021-01-05 18:00:30" ,"SN Ia" ,"SCAT" ,"UH88_SNIFS" ,"0.0512", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021G", `TNSuser`="tuckerma", `exptime`="1800", `obsdate`="2021-01-05 12:02:44", `reportAddedDate`="2021-01-05 18:00:30", `specType`="SN Ia", `survey`="SCAT", `telescope`="UH88_SNIFS", `transRedshift`="0.0512" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020aeuv" ,"sschulze" ,"1800" ,"2021-01-25 03:40:56" ,"2021-01-25 09:50:52" ,"SN IIn" ,"ZTF" ,"NOT_ALFOSC" ,"0.042843", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aeuv", `TNSuser`="sschulze", `exptime`="1800", `obsdate`="2021-01-25 03:40:56", `reportAddedDate`="2021-01-25 09:50:52", `specType`="SN IIn", `survey`="ZTF", `telescope`="NOT_ALFOSC", `transRedshift`="0.042843" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020aeqp" ,"georgios_dimitriadis" ,null ,"2021-01-11 00:00:00" ,"2021-01-11 18:52:56" ,"SN Ia" ,"UCSC" ,"Lick-3m_KAST" ,"0.061", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aeqp", `TNSuser`="georgios_dimitriadis", `exptime`=null, `obsdate`="2021-01-11 00:00:00", `reportAddedDate`="2021-01-11 18:52:56", `specType`="SN Ia", `survey`="UCSC", `telescope`="Lick-3m_KAST", `transRedshift`="0.061" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020aeqo" ,"ePESSTOplus_Bot1" ,"780" ,"2021-01-02 03:11:41" ,"2021-01-02 19:29:49" ,"SN II" ,"ePESSTO+" ,"ESO-NTT_EFOSC2-NTT" ,"0.031", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aeqo", `TNSuser`="ePESSTOplus_Bot1", `exptime`="780", `obsdate`="2021-01-02 03:11:41", `reportAddedDate`="2021-01-02 19:29:49", `specType`="SN II", `survey`="ePESSTO+", `telescope`="ESO-NTT_EFOSC2-NTT", `transRedshift`="0.031" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020adlp" ,"ZTF_Bot1" ,"2700" ,"2021-01-02 05:46:19" ,"2021-01-06 23:11:37" ,"SN Ia" ,"ZTF" ,"P60_SEDM" ,"0.07848", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adlp", `TNSuser`="ZTF_Bot1", `exptime`="2700", `obsdate`="2021-01-02 05:46:19", `reportAddedDate`="2021-01-06 23:11:37", `specType`="SN Ia", `survey`="ZTF", `telescope`="P60_SEDM", `transRedshift`="0.07848" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020adbk" ,"ZTF_Bot1" ,"2700" ,"2021-01-04 07:38:16" ,"2021-01-06 23:13:54" ,"SN Ia-pec" ,"ZTF" ,"P60_SEDM" ,"0.083", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbk", `TNSuser`="ZTF_Bot1", `exptime`="2700", `obsdate`="2021-01-04 07:38:16", `reportAddedDate`="2021-01-06 23:13:54", `specType`="SN Ia-pec", `survey`="ZTF", `telescope`="P60_SEDM", `transRedshift`="0.083" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020acma" ,"ePESSTOplus_Bot1" ,"600" ,"2020-12-15 06:31:22" ,"2020-12-15 15:59:13" ,"SN Ia" ,"ePESSTO+" ,"ESO-NTT_EFOSC2-NTT" ,"0.014", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acma", `TNSuser`="ePESSTOplus_Bot1", `exptime`="600", `obsdate`="2020-12-15 06:31:22", `reportAddedDate`="2020-12-15 15:59:13", `specType`="SN Ia", `survey`="ePESSTO+", `telescope`="ESO-NTT_EFOSC2-NTT", `transRedshift`="0.014" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020acew" ,"ZTF_Bot1" ,null ,"2021-01-08 00:00:00" ,"2021-01-21 02:59:04" ,"SN Ia" ,"ZTF" ,"P200_DBSP" ,"0.067", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acew", `TNSuser`="ZTF_Bot1", `exptime`=null, `obsdate`="2021-01-08 00:00:00", `reportAddedDate`="2021-01-21 02:59:04", `specType`="SN Ia", `survey`="ZTF", `telescope`="P200_DBSP", `transRedshift`="0.067" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020zko" ,"tuckerma" ,"1800" ,"2020-11-14 14:59:43" ,"2020-11-14 15:57:06" ,"SN Ia" ,"SCAT" ,"UH88_SNIFS" ,"0.051", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zko", `TNSuser`="tuckerma", `exptime`="1800", `obsdate`="2020-11-14 14:59:43", `reportAddedDate`="2020-11-14 15:57:06", `specType`="SN Ia", `survey`="SCAT", `telescope`="UH88_SNIFS", `transRedshift`="0.051" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020ytk" ,"ePESSTOplus_Bot1" ,"1500" ,"2020-11-10 02:20:42" ,"2020-11-10 17:39:08" ,"SN II" ,"ePESSTO+" ,"ESO-NTT_EFOSC2-NTT" ,"0.058", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ytk", `TNSuser`="ePESSTOplus_Bot1", `exptime`="1500", `obsdate`="2020-11-10 02:20:42", `reportAddedDate`="2020-11-10 17:39:08", `specType`="SN II", `survey`="ePESSTO+", `telescope`="ESO-NTT_EFOSC2-NTT", `transRedshift`="0.058" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020xba" ,"ZTF_Bot1" ,"2250" ,"2020-10-18 10:22:36" ,"2020-10-18 21:55:56" ,"SN Ia" ,"ZTF" ,"P60_SEDM" ,"0.04", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020xba", `TNSuser`="ZTF_Bot1", `exptime`="2250", `obsdate`="2020-10-18 10:22:36", `reportAddedDate`="2020-10-18 21:55:56", `specType`="SN Ia", `survey`="ZTF", `telescope`="P60_SEDM", `transRedshift`="0.04" ;
INSERT IGNORE INTO `fs_tns_spectra` (`TNSId`,`TNSuser`,`exptime`,`obsdate`,`reportAddedDate`,`specType`,`survey`,`telescope`,`transRedshift`, dateCreated) VALUES ("2020pub" ,"ZTF_Bot1" ,"2700" ,"2020-12-15 12:01:30" ,"2020-12-20 15:42:05" ,"SN II" ,"ZTF" ,"P60_SEDM" ,"0.011", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020pub", `TNSuser`="ZTF_Bot1", `exptime`="2700", `obsdate`="2020-12-15 12:01:30", `reportAddedDate`="2020-12-20 15:42:05", `specType`="SN II", `survey`="ZTF", `telescope`="P60_SEDM", `transRedshift`="0.011" ;