/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IPredicate;
import com.bigdata.btree.IIndex;
import com.bigdata.journal.IIndexManager;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.accesspath.AccessPath;
import com.bigdata.relation.accesspath.AccessPathFusedView;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.striterator.IKeyOrder;
import cutthecrap.utils.striterators.Striterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class RelationFusedView<E>
implements IRelation<E> {
    private final IRelation<E> relation1;
    private final IRelation<E> relation2;

    public IRelation<E> getRelation1() {
        return this.relation1;
    }

    public IRelation<E> getRelation2() {
        return this.relation2;
    }

    @Override
    public RelationFusedView<E> init() {
        return this;
    }

    public RelationFusedView(IRelation<E> relation1, IRelation<E> relation2) {
        if (relation1 == null) {
            throw new IllegalArgumentException();
        }
        if (relation2 == null) {
            throw new IllegalArgumentException();
        }
        if (relation1 == relation2) {
            throw new IllegalArgumentException("same relation: " + relation1);
        }
        this.relation1 = relation1;
        this.relation2 = relation2;
    }

    @Override
    public Set<String> getIndexNames() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.relation1.getIndexNames());
        set.addAll(this.relation2.getIndexNames());
        return set;
    }

    @Override
    public IKeyOrder<E> getPrimaryKeyOrder() {
        return this.relation1.getPrimaryKeyOrder();
    }

    @Override
    public Iterator<IKeyOrder<E>> getKeyOrders() {
        return new Striterator(this.relation1.getKeyOrders()).append(this.relation2.getKeyOrders());
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.relation1.getExecutorService();
    }

    @Override
    public E newElement(List<BOp> a, IBindingSet bindingSet) {
        return this.relation1.newElement(a, bindingSet);
    }

    @Override
    public Class<E> getElementClass() {
        return this.relation1.getElementClass();
    }

    @Override
    public IIndexManager getIndexManager() {
        return this.relation1.getIndexManager();
    }

    @Override
    public long getTimestamp() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getContainerNamespace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getFQN(IKeyOrder<? extends E> keyOrder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IIndex getIndex(IKeyOrder<? extends E> keyOrder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IKeyOrder<E> getKeyOrder(IPredicate<E> predicate) {
        IKeyOrder<E> keyOrder1 = this.relation1.getKeyOrder(predicate);
        IKeyOrder<E> keyOrder2 = this.relation2.getKeyOrder(predicate);
        if (keyOrder1 == null || keyOrder2 == null) {
            throw new UnsupportedOperationException();
        }
        if (!keyOrder1.equals(keyOrder2)) {
            throw new UnsupportedOperationException();
        }
        return keyOrder1;
    }

    @Override
    public IAccessPath<E> getAccessPath(IPredicate<E> predicate) {
        return new AccessPathFusedView((AccessPath)this.relation1.getAccessPath(predicate), (AccessPath)this.relation2.getAccessPath(predicate));
    }

    @Override
    public IAccessPath<E> getAccessPath(IKeyOrder<E> keyOrderIsIgnored, IPredicate<E> predicate) {
        return this.getAccessPath(predicate);
    }

    @Override
    public IAccessPath<E> getAccessPath(IIndexManager localIndexManagerIsIgnored, IKeyOrder<E> keyOrderisIgnored, IPredicate<E> predicate) {
        return this.getAccessPath(predicate);
    }
}

