/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.service;

import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sail.webapp.client.AST2SPARQLUtil;
import com.bigdata.rdf.sparql.ast.service.IRemoteSparqlQueryBuilder;
import com.bigdata.rdf.sparql.ast.service.RemoteSparql10QueryBuilder;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.model.BNode;
import org.openrdf.model.Value;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;

public class RemoteSparql11QueryBuilder
implements IRemoteSparqlQueryBuilder {
    private static final Logger log = Logger.getLogger(RemoteSparql10QueryBuilder.class);
    protected final String exprImage;
    protected final Map<String, String> prefixDecls;
    protected final AST2SPARQLUtil util;
    protected final Set<IVariable<?>> projectedVars;

    public RemoteSparql11QueryBuilder(ServiceNode serviceNode) {
        if (serviceNode == null) {
            throw new IllegalArgumentException();
        }
        this.exprImage = serviceNode.getExprImage();
        this.prefixDecls = serviceNode.getPrefixDecls();
        this.projectedVars = serviceNode.getProjectedVars();
        if (this.exprImage == null) {
            throw new IllegalArgumentException();
        }
        if (this.projectedVars == null) {
            throw new IllegalArgumentException();
        }
        this.util = new AST2SPARQLUtil(this.prefixDecls){

            public String toExternal(BNode val) {
                return "UNDEF";
            }
        };
    }

    protected LinkedHashSet<String> getDistinctVars(BindingSet[] bindingSets) {
        LinkedHashSet<String> vars = new LinkedHashSet<String>();
        for (BindingSet bindingSet : bindingSets) {
            for (Binding binding : bindingSet) {
                vars.add(binding.getName());
            }
        }
        return vars;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getSparqlQuery(BindingSet[] bindingSets) {
        void var4_10;
        int beginIndex;
        StringBuilder sb = new StringBuilder();
        if (this.prefixDecls != null) {
            for (Map.Entry<String, String> entry : this.prefixDecls.entrySet()) {
                sb.append("\n");
                sb.append("prefix ");
                sb.append(entry.getKey());
                sb.append(":");
                sb.append(" <");
                sb.append(entry.getValue());
                sb.append(">");
                sb.append("\n");
            }
        }
        sb.append("SELECT ");
        if (this.projectedVars.isEmpty()) {
            sb.append("*");
        } else {
            for (IVariable iVariable : this.projectedVars) {
                sb.append(" ?");
                sb.append(iVariable.getName());
            }
        }
        sb.append("\n");
        boolean singleEmptyBindingSet = bindingSets.length == 0 || bindingSets.length == 1 && bindingSets[0].size() == 0;
        Object var4_8 = null;
        if (!singleEmptyBindingSet) {
            Map<BNode, Set<String>> map = RemoteSparql11QueryBuilder.getCorrelatedVariables(bindingSets);
        }
        if ((beginIndex = this.exprImage.indexOf("{") + 1) < 0) {
            throw new RuntimeException();
        }
        int endIndex = this.exprImage.lastIndexOf("}");
        if (endIndex < beginIndex) {
            throw new RuntimeException();
        }
        String tmp = this.exprImage.substring(beginIndex, endIndex);
        sb.append("WHERE {\n");
        if (var4_10 != null) {
            for (Set sameTermVars : var4_10.values()) {
                int nSameTerm = sameTermVars.size();
                if (nSameTerm < 2) continue;
                String[] names = sameTermVars.toArray(new String[nSameTerm]);
                sb.append("FILTER (");
                for (int i = 1; i < names.length; ++i) {
                    if (i > 1) {
                        sb.append(" &&");
                    }
                    sb.append(" sameTerm( ?" + names[0] + ", ?" + names[i] + ")");
                }
                sb.append(" ).\n");
            }
        }
        sb.append(tmp);
        sb.append("\n}\n");
        if (!singleEmptyBindingSet) {
            LinkedHashSet<String> vars = this.getDistinctVars(bindingSets);
            sb.append("VALUES");
            sb.append(" (");
            for (String v : vars) {
                sb.append(" ?");
                sb.append(v);
            }
            sb.append(")");
            sb.append(" {\n");
            for (BindingSet bindingSet : bindingSets) {
                sb.append("(");
                for (String v : vars) {
                    sb.append(" ");
                    Binding b = bindingSet.getBinding(v);
                    if (b == null) {
                        sb.append("UNDEF");
                        continue;
                    }
                    Value val = b.getValue();
                    String ext = this.util.toExternal(val);
                    sb.append(ext);
                }
                sb.append(" )");
                sb.append("\n");
            }
            sb.append("}\n");
        }
        String q = sb.toString();
        if (log.isInfoEnabled()) {
            log.info((Object)("\n" + q));
        }
        return q;
    }

    protected static Map<BNode, Set<String>> getCorrelatedVariables(BindingSet[] bindingSets) {
        LinkedHashMap<BNode, LinkedHashSet<String>> bnodes = null;
        for (BindingSet bindingSet : bindingSets) {
            for (Binding b : bindingSet) {
                BNode bnd;
                LinkedHashSet<String> cvars;
                Value v = b.getValue();
                if (!(v instanceof BNode)) continue;
                if (bnodes == null) {
                    bnodes = new LinkedHashMap<BNode, LinkedHashSet<String>>();
                }
                if ((cvars = (LinkedHashSet<String>)bnodes.get(bnd = (BNode)v)) == null) {
                    cvars = new LinkedHashSet<String>();
                    bnodes.put(bnd, cvars);
                } else if (bindingSets.length > 1) {
                    throw new UnsupportedOperationException();
                }
                if (!cvars.add(b.getName())) {
                    throw new AssertionError();
                }
            }
        }
        return bnodes;
    }
}

