/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.ArbitraryLengthPathNode;
import com.bigdata.rdf.sparql.ast.BindingsClause;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IJoinNode;
import com.bigdata.rdf.sparql.ast.ISolutionSetStats;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.ZeroLengthPathNode;
import com.bigdata.rdf.sparql.ast.eval.IEvaluationContext;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class StaticAnalysisBase {
    protected final QueryRoot queryRoot;
    protected final IEvaluationContext evaluationContext;

    public QueryRoot getQueryRoot() {
        return this.queryRoot;
    }

    protected StaticAnalysisBase(QueryRoot queryRoot, IEvaluationContext evaluationContext) {
        if (queryRoot == null) {
            throw new IllegalArgumentException();
        }
        this.queryRoot = queryRoot;
        this.evaluationContext = evaluationContext;
    }

    public Set<IVariable<?>> getSpannedVariables(BOp op, Set<IVariable<?>> varSet) {
        return this.getSpannedVariables(op, true, varSet);
    }

    public Set<IVariable<?>> getSpannedVariables(BOp op, boolean filters, Set<IVariable<?>> varSet) {
        IJoinNode t;
        List<FilterNode> list;
        if (op == null) {
            return varSet;
        }
        if (op instanceof IVariable) {
            varSet.add((IVariable)op);
        } else if (op instanceof IConstant) {
            IConstant c = (IConstant)op;
            IVariable var = (IVariable)c.getProperty(Constant.Annotations.VAR);
            if (var != null) {
                varSet.add(var);
            }
        } else {
            if (op instanceof ArbitraryLengthPathNode) {
                varSet.addAll(((ArbitraryLengthPathNode)op).getMaybeProducedBindings());
                return varSet;
            }
            if (op instanceof ZeroLengthPathNode) {
                varSet.addAll(((ZeroLengthPathNode)op).getProducedBindings());
                return varSet;
            }
            if (op instanceof ServiceNode) {
                ServiceNode serviceNode = (ServiceNode)op;
                TermNode uriRef = serviceNode.getServiceRef();
                if (uriRef instanceof VarNode) {
                    varSet.add(((VarNode)uriRef).getValueExpression());
                }
                this.getSpannedVariables(serviceNode.getGraphPattern(), filters, varSet);
            } else {
                if (op instanceof BindingsClause) {
                    BindingsClause bc = (BindingsClause)op;
                    varSet.addAll(bc.getDeclaredVariables());
                    return varSet;
                }
                if (op instanceof FilterNode && !filters) {
                    return varSet;
                }
                if (op instanceof SubqueryRoot) {
                    SubqueryRoot subquery = (SubqueryRoot)op;
                    subquery.getProjectedVars(varSet);
                    return varSet;
                }
                if (op instanceof NamedSubqueryInclude) {
                    NamedSubqueryInclude namedInclude = (NamedSubqueryInclude)op;
                    String name = namedInclude.getName();
                    NamedSubqueryRoot subquery = this.getNamedSubqueryRoot(name);
                    if (subquery != null) {
                        subquery.getProjectedVars(varSet);
                    } else {
                        ISolutionSetStats stats = this.getSolutionSetStats(name);
                        varSet.addAll(stats.getUsedVars());
                    }
                    return varSet;
                }
            }
        }
        if (filters && op instanceof IJoinNode && (list = (t = (IJoinNode)op).getAttachedJoinFilters()) != null) {
            for (FilterNode f : list) {
                this.getSpannedVariables(f, filters, varSet);
            }
        }
        int arity = op.arity();
        for (int i = 0; i < arity; ++i) {
            BOp child = op.get(i);
            this.getSpannedVariables(child, filters, varSet);
        }
        return varSet;
    }

    protected NamedSubqueryRoot getRequiredNamedSubqueryRoot(String name) {
        NamedSubqueryRoot nsr = this.getNamedSubqueryRoot(name);
        if (nsr == null) {
            throw new RuntimeException("Named subquery does not exist for namedSet: " + name);
        }
        return nsr;
    }

    public NamedSubqueryRoot getNamedSubqueryRoot(String name) {
        NamedSubqueriesNode namedSubqueries = this.queryRoot.getNamedSubqueries();
        if (namedSubqueries == null) {
            return null;
        }
        for (NamedSubqueryRoot namedSubquery : namedSubqueries) {
            if (!name.equals(namedSubquery.getName())) continue;
            return namedSubquery;
        }
        return null;
    }

    public ISolutionSetStats getSolutionSetStats(String name) {
        return this.evaluationContext.getSolutionSetStats(name);
    }

    protected void addAll(Set<IVariable<?>> bindings, IGroupMemberNode op) {
        Iterator<IVariable<?>> it = BOpUtility.getSpannedVariables(op);
        while (it.hasNext()) {
            bindings.add(it.next());
        }
    }

    public boolean isFullyBound(FilterNode f, Set<IVariable<?>> vars) {
        Set<IVariable<IVariable<?>>> fvars = this.getSpannedVariables(f, true, new LinkedHashSet());
        fvars.removeAll(vars);
        return fvars.isEmpty();
    }

    public static Set<IVariable<?>> getSPOVariables(StatementPatternNode sp) {
        LinkedHashSet set = new LinkedHashSet();
        for (int i = 0; i < 3; ++i) {
            TermNode tmp = sp.get(0);
            if (!tmp.isVariable()) continue;
            set.add((IVariable)tmp.getValueExpression());
        }
        return set;
    }
}

