/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.lbs;

import com.bigdata.counters.CAT;
import com.bigdata.ha.HAGlue;
import com.bigdata.ha.IHAJournal;
import com.bigdata.ha.QuorumService;
import com.bigdata.journal.IIndexManager;
import com.bigdata.quorum.Quorum;
import java.io.IOException;
import java.util.UUID;

public class ServiceScore {
    private final UUID serviceUUID;
    private String hostname;
    private String requestURI;
    public final CAT nrequests = new CAT();

    public UUID getServiceUUID() {
        return this.serviceUUID;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String toString() {
        return this.getClass().getName() + "{serviceUUID=" + this.serviceUUID + ", hostname=" + this.hostname + ", requestURI=" + this.requestURI + ", nrequests=" + this.nrequests.get() + "}";
    }

    ServiceScore(UUID serviceUUID, String hostname, String requestURI) {
        if (serviceUUID == null) {
            throw new IllegalArgumentException();
        }
        if (hostname == null) {
            throw new IllegalArgumentException();
        }
        if (requestURI == null) {
            throw new IllegalArgumentException();
        }
        this.serviceUUID = serviceUUID;
        this.hostname = hostname;
        this.requestURI = requestURI;
    }

    public static ServiceScore newInstance(IIndexManager indexManager, String contextPath, UUID serviceUUID) throws IllegalArgumentException, ClassCastException, IOException, RuntimeException {
        if (indexManager == null) {
            throw new IllegalArgumentException();
        }
        if (contextPath == null) {
            throw new IllegalArgumentException();
        }
        if (serviceUUID == null) {
            throw new IllegalArgumentException();
        }
        IHAJournal journal = (IHAJournal)indexManager;
        Quorum<HAGlue, QuorumService<HAGlue>> quorum = journal.getQuorum();
        if (quorum == null) {
            return null;
        }
        QuorumService<HAGlue> t = quorum.getClient();
        QuorumService<HAGlue> quorumService = t;
        HAGlue haGlue = (HAGlue)quorumService.getService(serviceUUID);
        String hostname = haGlue.getHostname();
        int port = haGlue.getNSSPort();
        String requestURI = "http://" + hostname + ":" + port + contextPath;
        return new ServiceScore(serviceUUID, hostname, requestURI);
    }
}

