/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.literal;

import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValueFactory;
import java.math.BigDecimal;
import java.math.BigInteger;

public class XSDUnsignedByteIV<V extends BigdataLiteral>
extends AbstractLiteralIV<V, Short> {
    private static final long serialVersionUID = 1L;
    private final byte value;
    private static final byte UNSIGNED_ZERO = -128;

    public byte rawValue() {
        return this.value;
    }

    @Override
    public IV<V, Short> clone(boolean clearCache) {
        XSDUnsignedByteIV tmp = new XSDUnsignedByteIV(this.value);
        if (!clearCache) {
            tmp.setValue(this.getValueCache());
        }
        return tmp;
    }

    public XSDUnsignedByteIV(byte value) {
        super(DTE.XSDUnsignedByte);
        this.value = value;
    }

    @Override
    public final Short getInlineValue() {
        return this.promote();
    }

    public final short promote() {
        return XSDUnsignedByteIV.promote(this.value);
    }

    public static short promote(byte v) {
        int i = v - -128;
        return (short)i;
    }

    @Override
    public V asValue(LexiconRelation lex) {
        BigdataLiteral v = (BigdataLiteral)this.getValueCache();
        if (v == null) {
            BigdataValueFactory f = lex.getValueFactory();
            v = f.createLiteral(this.value, true);
            v.setIV(this);
            this.setValue(v);
        }
        return (V)v;
    }

    @Override
    public final long longValue() {
        return this.promote();
    }

    @Override
    public boolean booleanValue() {
        return this.value != -128;
    }

    @Override
    public byte byteValue() {
        return (byte)this.promote();
    }

    @Override
    public double doubleValue() {
        return this.promote();
    }

    @Override
    public float floatValue() {
        return this.promote();
    }

    @Override
    public int intValue() {
        return this.promote();
    }

    @Override
    public short shortValue() {
        return this.promote();
    }

    @Override
    public String stringValue() {
        return Short.toString(this.promote());
    }

    @Override
    public BigDecimal decimalValue() {
        return BigDecimal.valueOf(this.promote());
    }

    @Override
    public BigInteger integerValue() {
        return BigInteger.valueOf(this.promote());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof XSDUnsignedByteIV) {
            return this.value == ((XSDUnsignedByteIV)o).value;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public int byteLength() {
        return 2;
    }

    @Override
    public int _compareTo(IV o) {
        XSDUnsignedByteIV t = (XSDUnsignedByteIV)o;
        return this.value == t.value ? 0 : (this.value < t.value ? -1 : 1);
    }
}

