/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.AbstractChunkedTupleIterator;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.ResultSet;
import com.bigdata.io.ByteBufferInputStream;
import com.bigdata.rawstore.IBlock;
import com.bigdata.rawstore.IRawStore;
import cutthecrap.utils.striterators.IFilter;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class ChunkedLocalRangeIterator<E>
extends AbstractChunkedTupleIterator<E> {
    protected final IIndex ndx;
    private final boolean removeAll;
    private final boolean cursor;

    public ChunkedLocalRangeIterator(IIndex ndx, byte[] fromKey, byte[] toKey, int capacity, int flags, IFilter filter) {
        super(fromKey, toKey, capacity, flags, filter);
        if (ndx == null) {
            throw new IllegalArgumentException();
        }
        this.ndx = ndx;
        this.removeAll = (flags & 0x10) != 0;
        this.cursor = (flags & 0x20) != 0;
    }

    @Override
    protected ResultSet getResultSet(long timestamp, byte[] fromKey, byte[] toKey, int capacity, int flags, IFilter filter) {
        int tmpFlags = this.removeAll && !this.cursor ? flags & 0xFFFFFFEF : flags;
        int rangeCount = (int)Math.min(Integer.MAX_VALUE, this.ndx.rangeCount(fromKey, toKey));
        int limit = rangeCount > capacity ? capacity : rangeCount;
        ITupleIterator itr = this.ndx.rangeIterator(fromKey, toKey, limit, tmpFlags | 1, filter);
        return new ResultSet(this.ndx, limit, tmpFlags, itr);
    }

    @Override
    public ITuple<E> next() {
        Object tuple = super.next();
        if (this.removeAll && !this.cursor) {
            this.remove();
        }
        return tuple;
    }

    @Override
    protected void deleteBehind(int n, Iterator<byte[]> keys) {
        while (keys.hasNext()) {
            this.ndx.remove(keys.next());
        }
    }

    @Override
    protected void deleteLast(byte[] key) {
        this.ndx.remove(key);
    }

    @Override
    protected IBlock readBlock(int sourceIndex, final long addr) {
        if (this.ndx instanceof AbstractBTree) {
            if (sourceIndex != 0) {
                throw new IllegalArgumentException();
            }
            return new IBlock(){

                @Override
                public long getAddress() {
                    return addr;
                }

                @Override
                public InputStream inputStream() {
                    IRawStore store = ((AbstractBTree)ChunkedLocalRangeIterator.this.ndx).getStore();
                    ByteBuffer buf = store.read(addr);
                    return new ByteBufferInputStream(buf);
                }

                @Override
                public int length() {
                    IRawStore store = ((AbstractBTree)ChunkedLocalRangeIterator.this.ndx).getStore();
                    return store.getByteCount(addr);
                }
            };
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected long getTimestamp() {
        return 0L;
    }

    @Override
    public boolean getReadConsistent() {
        return false;
    }
}

