/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.rdf.update;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.ITimestampAnnotations;
import com.bigdata.bop.PipelineOp;
import com.bigdata.journal.Journal;
import com.bigdata.journal.TimestampUtility;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public final class CommitOp
extends PipelineOp {
    private static final long serialVersionUID = 1L;

    public CommitOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        this.getRequiredProperty(Annotations.TIMESTAMP);
        if (this.getProperty(Annotations.PIPELINED, true).booleanValue()) {
            throw new IllegalArgumentException(Annotations.PIPELINED);
        }
    }

    public CommitOp(CommitOp op) {
        super(op);
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new ChunkTask(context, this));
    }

    private static class ChunkTask
    implements Callable<Void> {
        private final long timestamp;
        private final Journal store;

        public ChunkTask(BOpContext<IBindingSet> context, CommitOp op) {
            this.timestamp = (Long)op.getRequiredProperty(Annotations.TIMESTAMP);
            if (TimestampUtility.isReadOnly(this.timestamp)) {
                throw new UnsupportedOperationException();
            }
            this.store = (Journal)context.getIndexManager();
        }

        @Override
        public Void call() throws Exception {
            if (TimestampUtility.isUnisolated(this.timestamp)) {
                long commitTime = this.store.commit();
            } else {
                long commitTime = this.store.commit(this.timestamp);
            }
            return null;
        }
    }

    public static interface Annotations
    extends PipelineOp.Annotations,
    ITimestampAnnotations {
    }
}

