/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bfs;

import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.keys.KeyBuilder;
import java.util.Iterator;

public class BlockIdentifierIterator
implements Iterator<Long> {
    private final String id;
    private final int version;
    private final ITupleIterator src;

    public String getId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public BlockIdentifierIterator(String id, int version, ITupleIterator src) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.version = version;
        this.src = src;
    }

    @Override
    public boolean hasNext() {
        return this.src.hasNext();
    }

    @Override
    public Long next() {
        ITuple tuple = this.src.next();
        byte[] key = tuple.getKey();
        long block = KeyBuilder.decodeLong(key, key.length - 8);
        return block;
    }

    @Override
    public void remove() {
        this.src.remove();
    }
}

