/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.contextaware.config;

import java.util.Set;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.repository.config.DelegatingRepositoryImplConfigBase;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.contextaware.config.ContextAwareSchema;

public class ContextAwareConfig
extends DelegatingRepositoryImplConfigBase {
    private static final URI[] ALL_CONTEXTS = new URI[0];
    private Boolean includeInferred = true;
    private int maxQueryTime = 0;
    private QueryLanguage queryLanguage = QueryLanguage.SPARQL;
    private String baseURI;
    private URI[] readContexts = ALL_CONTEXTS;
    private URI[] addContexts = ALL_CONTEXTS;
    private URI[] removeContexts = ALL_CONTEXTS;
    private URI[] archiveContexts = ALL_CONTEXTS;
    private URI insertContext = null;

    public ContextAwareConfig() {
        super("openrdf:ContextAwareRepository");
    }

    public int getMaxQueryTime() {
        return this.maxQueryTime;
    }

    public void setMaxQueryTime(int maxQueryTime) {
        this.maxQueryTime = maxQueryTime;
    }

    @Deprecated
    public URI[] getAddContexts() {
        return this.addContexts;
    }

    @Deprecated
    public URI[] getArchiveContexts() {
        return this.archiveContexts;
    }

    public URI getInsertContext() {
        return this.insertContext;
    }

    public QueryLanguage getQueryLanguage() {
        return this.queryLanguage;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public URI[] getReadContexts() {
        return this.readContexts;
    }

    public URI[] getRemoveContexts() {
        return this.removeContexts;
    }

    public boolean isIncludeInferred() {
        return this.includeInferred == null || this.includeInferred != false;
    }

    @Deprecated
    public void setAddContexts(URI ... addContexts) {
        this.addContexts = addContexts;
    }

    @Deprecated
    public void setArchiveContexts(URI ... archiveContexts) {
        this.archiveContexts = archiveContexts;
    }

    public void setInsertContext(URI insertContext) {
        this.insertContext = insertContext;
    }

    public void setIncludeInferred(boolean includeInferred) {
        this.includeInferred = includeInferred;
    }

    public void setQueryLanguage(QueryLanguage ql) {
        this.queryLanguage = ql;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public void setReadContexts(URI ... readContexts) {
        this.readContexts = readContexts;
    }

    public void setRemoveContexts(URI ... removeContexts) {
        this.removeContexts = removeContexts;
    }

    public Resource export(Graph graph) {
        Resource repImplNode = super.export(graph);
        ValueFactory vf = graph.getValueFactory();
        if (this.includeInferred != null) {
            Literal bool = vf.createLiteral(this.includeInferred.booleanValue());
            graph.add(repImplNode, ContextAwareSchema.INCLUDE_INFERRED, (Value)bool, new Resource[0]);
        }
        if (this.maxQueryTime > 0) {
            graph.add(repImplNode, ContextAwareSchema.MAX_QUERY_TIME, (Value)vf.createLiteral(this.maxQueryTime), new Resource[0]);
        }
        if (this.queryLanguage != null) {
            graph.add(repImplNode, ContextAwareSchema.QUERY_LANGUAGE, (Value)vf.createLiteral(this.queryLanguage.getName()), new Resource[0]);
        }
        if (this.baseURI != null) {
            graph.add(repImplNode, ContextAwareSchema.BASE_URI, (Value)vf.createURI(this.baseURI), new Resource[0]);
        }
        for (URI uri : this.readContexts) {
            graph.add(repImplNode, ContextAwareSchema.READ_CONTEXT, (Value)uri, new Resource[0]);
        }
        for (URI resource : this.addContexts) {
            graph.add(repImplNode, ContextAwareSchema.ADD_CONTEXT, (Value)resource, new Resource[0]);
        }
        for (URI resource : this.removeContexts) {
            graph.add(repImplNode, ContextAwareSchema.REMOVE_CONTEXT, (Value)resource, new Resource[0]);
        }
        for (URI resource : this.archiveContexts) {
            graph.add(repImplNode, ContextAwareSchema.ARCHIVE_CONTEXT, (Value)resource, new Resource[0]);
        }
        if (this.insertContext != null) {
            graph.add(repImplNode, ContextAwareSchema.INSERT_CONTEXT, (Value)this.insertContext, new Resource[0]);
        }
        return repImplNode;
    }

    public void parse(Graph graph, Resource implNode) throws RepositoryConfigException {
        super.parse(graph, implNode);
        try {
            URI uri;
            Literal lit = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)ContextAwareSchema.INCLUDE_INFERRED);
            if (lit != null) {
                this.setIncludeInferred(lit.booleanValue());
            }
            if ((lit = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)ContextAwareSchema.MAX_QUERY_TIME)) != null) {
                this.setMaxQueryTime(lit.intValue());
            }
            if ((lit = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)ContextAwareSchema.QUERY_LANGUAGE)) != null) {
                this.setQueryLanguage(QueryLanguage.valueOf((String)lit.getLabel()));
            }
            if ((uri = GraphUtil.getOptionalObjectURI((Graph)graph, (Resource)implNode, (URI)ContextAwareSchema.BASE_URI)) != null) {
                this.setBaseURI(uri.stringValue());
            }
            Set objects = GraphUtil.getObjects((Graph)graph, (Resource)implNode, (URI)ContextAwareSchema.READ_CONTEXT, (Resource[])new Resource[0]);
            this.setReadContexts(objects.toArray(new URI[objects.size()]));
            objects = GraphUtil.getObjects((Graph)graph, (Resource)implNode, (URI)ContextAwareSchema.ADD_CONTEXT, (Resource[])new Resource[0]);
            this.setAddContexts(objects.toArray(new URI[objects.size()]));
            objects = GraphUtil.getObjects((Graph)graph, (Resource)implNode, (URI)ContextAwareSchema.REMOVE_CONTEXT, (Resource[])new Resource[0]);
            this.setRemoveContexts(objects.toArray(new URI[objects.size()]));
            objects = GraphUtil.getObjects((Graph)graph, (Resource)implNode, (URI)ContextAwareSchema.ARCHIVE_CONTEXT, (Resource[])new Resource[0]);
            this.setArchiveContexts(objects.toArray(new URI[objects.size()]));
            uri = GraphUtil.getOptionalObjectURI((Graph)graph, (Resource)implNode, (URI)ContextAwareSchema.INSERT_CONTEXT);
            if (uri != null) {
                this.setInsertContext(uri);
            }
        }
        catch (GraphUtilException e) {
            throw new RepositoryConfigException((Throwable)e);
        }
        catch (ArrayStoreException e) {
            throw new RepositoryConfigException((Throwable)e);
        }
    }
}

