/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.io;

import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.io.SafelyCloseable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfflineIterable<T, U extends T>
implements Iterable<U>,
SafelyCloseable {
    public static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Util.getLogger(OfflineIterable.class);
    private final Serializer<? super T, ? super U> serializer;
    private final File file;
    private final DataOutputStream dos;
    private final U store;
    private long size;
    private boolean closed = false;

    public OfflineIterable(Serializer<? super T, ? super U> serializer, U store) throws IOException {
        this.serializer = serializer;
        this.store = store;
        this.file = File.createTempFile(OfflineIterable.class.getSimpleName(), "elmts");
        this.file.deleteOnExit();
        this.dos = new DataOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(this.file)));
    }

    public void add(T x) throws IOException {
        this.serializer.write(x, this.dos);
        ++this.size;
    }

    public void addAll(Iterable<T> it) throws IOException {
        for (T x : it) {
            this.add(x);
        }
    }

    public OfflineIterator<T, U> iterator() {
        try {
            this.dos.flush();
            DataInputStream dis = new DataInputStream((InputStream)new FastBufferedInputStream((InputStream)new FileInputStream(this.file)));
            return new OfflineIterator(dis, this.serializer, this.store, this.size);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            try {
                this.dos.close();
                this.file.delete();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                LOGGER.warn((Object)("This " + this.getClass().getName() + " [" + this.toString() + "] should have been closed."));
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public int size() {
        long length = this.length();
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("The number of elements of this bit list (" + length + ") exceeds Integer.MAX_INT");
        }
        return (int)length;
    }

    public long length() {
        return this.size;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Serializer<A, B extends A> {
        public void write(A var1, DataOutputStream var2) throws IOException;

        public void read(DataInputStream var1, B var2) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OfflineIterator<A, B extends A>
    extends AbstractObjectIterator<B>
    implements SafelyCloseable {
        private final DataInputStream dis;
        private final long size;
        private final Serializer<? super A, ? super B> serializer;
        private final B store;
        private long read;
        private boolean closed = false;

        private OfflineIterator(DataInputStream dis, Serializer<? super A, ? super B> serializer, B store, long size) {
            this.dis = dis;
            this.serializer = serializer;
            this.store = store;
            this.size = size;
        }

        public boolean hasNext() {
            if (this.read >= this.size) {
                this.close();
            }
            return this.read < this.size;
        }

        public B next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                this.serializer.read(this.dis, this.store);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ++this.read;
            return this.store;
        }

        @Override
        public void close() {
            if (!this.closed) {
                try {
                    this.dis.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.closed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                if (!this.closed) {
                    LOGGER.warn((Object)("This " + this.getClass().getName() + " [" + this.toString() + "] should have been closed."));
                    this.close();
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

