/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shacl.Shapes;
import org.apache.jena.shacl.ValidationReport;
import org.apache.jena.shacl.engine.exec.TripleValidator;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.validation.ReportItem;
import org.apache.jena.sparql.path.Path;

public class ValidationContext {
    private final ValidationReport.Builder validationReportBuilder = ValidationReport.create();
    private boolean verbose = false;
    private final Shapes shapes;
    private final Graph dataGraph;
    private boolean strict = false;

    public ValidationContext(ValidationContext vCxt) {
        this.shapes = vCxt.shapes;
        this.dataGraph = vCxt.dataGraph;
        this.verbose = vCxt.verbose;
        this.strict = vCxt.strict;
    }

    public ValidationContext(Shapes shapes, Graph data) {
        this.shapes = shapes;
        this.dataGraph = data;
        this.validationReportBuilder.addPrefixes(data.getPrefixMapping());
        this.validationReportBuilder.addPrefixes(shapes.getGraph().getPrefixMapping());
    }

    public void reportEntry(ReportItem item, Shape shape, Node focusNode, Path path, Constraint constraint) {
        this.reportEntry(item.getMessage(), shape, focusNode, path, item.getValue(), constraint);
    }

    public void reportEntry(String message, Shape shape, Node focusNode, Path path, Node valueNode, Constraint constraint) {
        this.validationReportBuilder.addReportEntry(message, shape, focusNode, path, valueNode, constraint);
    }

    public void reportEntry(ReportItem item, TripleValidator validator, Triple triple) {
        this.validationReportBuilder.addReportEntry(item, validator, triple);
    }

    public ValidationReport generateReport() {
        return this.validationReportBuilder.build();
    }

    public void setVerbose(boolean value) {
        this.verbose = value;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setStrict(boolean value) {
        this.strict = value;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public Shapes getShapes() {
        return this.shapes;
    }

    public Graph getShapesGraph() {
        return this.shapes.getGraph();
    }

    public Graph getDataGraph() {
        return this.dataGraph;
    }
}

