/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.compact;

import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.shacl.Shapes;
import org.apache.jena.shacl.compact.parser.ParseException;
import org.apache.jena.shacl.compact.parser.ShaclCompactParserJJ;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;

public class ShaclcParser {
    public static Shapes parse(String filename) {
        return ShaclcParser.parse(filename, null);
    }

    public static Shapes parse(String filename, String baseURI) {
        InputStream input = IO.openFile((String)filename);
        Graph graph = ShaclcParser.parseSHACLC(input, baseURI);
        return Shapes.parse(graph);
    }

    public static Graph parseSHACLC(InputStream input) {
        return ShaclcParser.parseSHACLC(input, (String)null);
    }

    public static Graph parseSHACLC(InputStream input, String baseURI) {
        ShaclCompactParserJJ parser = new ShaclCompactParserJJ(input, StandardCharsets.UTF_8.name());
        return ShaclcParser.parseIntoGraph$(parser, baseURI);
    }

    public static void parseSHACLC(InputStream input, StreamRDF stream) {
        ShaclcParser.parseSHACLC(input, null, stream);
    }

    public static void parseSHACLC(InputStream input, String baseURI, StreamRDF stream) {
        ShaclCompactParserJJ parser = new ShaclCompactParserJJ(input, StandardCharsets.UTF_8.name());
        ShaclcParser.parse$(parser, stream, baseURI);
    }

    static Graph parseSHACLC(Reader reader, String baseURI) {
        ShaclCompactParserJJ parser = new ShaclCompactParserJJ(reader);
        return ShaclcParser.parseIntoGraph$(parser, baseURI);
    }

    private static Graph parseIntoGraph$(ShaclCompactParserJJ parser, String baseURI) {
        Graph graph = GraphFactory.createDefaultGraph();
        StreamRDF stream = StreamRDFLib.graph((Graph)graph);
        ShaclcParser.parse$(parser, stream, baseURI);
        return graph;
    }

    private static void parse$(ShaclCompactParserJJ parser, StreamRDF stream, String baseURI) {
        Prologue prologue = parser.getPrologue();
        stream.start();
        ShaclcParser.prefix(stream, prologue, "rdf", RDF.getURI());
        ShaclcParser.prefix(stream, prologue, "rdfs", RDFS.getURI());
        ShaclcParser.prefix(stream, prologue, "sh", SHACL.getURI());
        ShaclcParser.prefix(stream, prologue, "xsd", XSD.getURI());
        ShaclcParser.prefix(stream, prologue, "owl", OWL.getURI());
        parser.start(stream);
        try {
            if (baseURI != null) {
                parser.getPrologue().setBaseURI(baseURI);
            }
            parser.Unit();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        parser.finish();
        stream.finish();
    }

    private static void prefix(StreamRDF stream, Prologue prologue, String prefix, String uri) {
        stream.prefix(prefix, uri);
        prologue.getPrefixMapping().setNsPrefix(prefix, uri);
    }
}

