/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.profiles.OWL2DLProfile;
import org.semanticweb.owlapi.profiles.OWLOntologyProfileWalker;
import org.semanticweb.owlapi.profiles.OWLProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import org.semanticweb.owlapi.profiles.Profiles;
import org.semanticweb.owlapi.profiles.violations.UseOfIllegalAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfIllegalDataRange;
import org.semanticweb.owlapi.profiles.violations.UseOfNonEquivalentClassExpression;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSubClassExpression;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSuperClassExpression;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.OWLOntologyWalker;
import org.semanticweb.owlapi.util.OWLOntologyWalkerVisitor;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class OWL2RLProfile
implements OWLProfile {
    protected static final Set<IRI> ALLOWED_DATATYPES = OWLAPIStreamUtils.asUnorderedSet(OWL2Datatype.RL_DATATYPES.stream().map(i -> i.getIRI()));
    private final OWL2RLSubClassExpressionChecker subClassExpressionChecker = new OWL2RLSubClassExpressionChecker();
    private final OWL2RLSuperClassExpressionChecker superClassExpressionChecker = new OWL2RLSuperClassExpressionChecker();
    private final OWL2RLEquivalentClassExpressionChecker equivalentClassExpressionChecker = new OWL2RLEquivalentClassExpressionChecker();

    @Override
    public String getName() {
        return "OWL 2 RL";
    }

    @Override
    public IRI getIRI() {
        return Profiles.OWL2_RL.getIRI();
    }

    @Override
    public OWLProfileReport checkOntology(OWLOntology ontology) {
        OWL2DLProfile profile = new OWL2DLProfile();
        OWLProfileReport report = profile.checkOntology(ontology);
        HashSet<OWLProfileViolation> violations = new HashSet<OWLProfileViolation>();
        violations.addAll(report.getViolations());
        OWLOntologyProfileWalker walker = new OWLOntologyProfileWalker(ontology.importsClosure());
        OWL2RLObjectVisitor visitor = new OWL2RLObjectVisitor(walker);
        walker.walkStructure(visitor);
        violations.addAll(visitor.getProfileViolations());
        return new OWLProfileReport(this, violations);
    }

    protected boolean isOWL2RLSubClassExpression(OWLClassExpression ce) {
        return ce.accept(this.subClassExpressionChecker);
    }

    public boolean isOWL2RLSuperClassExpression(OWLClassExpression ce) {
        return ce.accept(this.superClassExpressionChecker);
    }

    public boolean isOWL2RLEquivalentClassExpression(OWLClassExpression ce) {
        return ce.accept(this.equivalentClassExpressionChecker);
    }

    private class OWL2RLSuperClassExpressionChecker
    implements OWLClassExpressionVisitorEx<Boolean> {
        OWL2RLSuperClassExpressionChecker() {
        }

        @Override
        public Boolean doDefault(Object o) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean visit(OWLClass ce) {
            return !ce.isOWLThing();
        }

        @Override
        public Boolean visit(OWLObjectIntersectionOf ce) {
            return !ce.operands().anyMatch(e -> e.accept(this) == false);
        }

        @Override
        public Boolean visit(OWLObjectComplementOf ce) {
            return OWL2RLProfile.this.isOWL2RLSubClassExpression(ce.getOperand());
        }

        @Override
        public Boolean visit(OWLObjectAllValuesFrom ce) {
            return ((OWLClassExpression)ce.getFiller()).accept(this);
        }

        @Override
        public Boolean visit(OWLObjectHasValue ce) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(OWLObjectMaxCardinality ce) {
            return !(ce.getCardinality() != 0 && ce.getCardinality() != 1 || !((OWLClassExpression)ce.getFiller()).isOWLThing() && !OWL2RLProfile.this.isOWL2RLSubClassExpression((OWLClassExpression)ce.getFiller()));
        }

        @Override
        public Boolean visit(OWLDataAllValuesFrom ce) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(OWLDataHasValue ce) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(OWLDataMaxCardinality ce) {
            return ce.getCardinality() == 0 || ce.getCardinality() == 1;
        }
    }

    private class OWL2RLSubClassExpressionChecker
    implements OWLClassExpressionVisitorEx<Boolean> {
        OWL2RLSubClassExpressionChecker() {
        }

        @Override
        public Boolean doDefault(Object o) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean visit(OWLClass ce) {
            return !ce.isOWLThing();
        }

        @Override
        public Boolean visit(OWLObjectIntersectionOf ce) {
            return !ce.operands().anyMatch(op -> !OWL2RLProfile.this.isOWL2RLSubClassExpression((OWLClassExpression)op));
        }

        @Override
        public Boolean visit(OWLObjectUnionOf ce) {
            return !ce.operands().anyMatch(op -> !OWL2RLProfile.this.isOWL2RLSubClassExpression((OWLClassExpression)op));
        }

        @Override
        public Boolean visit(OWLObjectSomeValuesFrom ce) {
            return ((OWLClassExpression)ce.getFiller()).isOWLThing() || OWL2RLProfile.this.isOWL2RLSubClassExpression((OWLClassExpression)ce.getFiller());
        }

        @Override
        public Boolean visit(OWLObjectHasValue ce) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(OWLObjectOneOf ce) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(OWLDataSomeValuesFrom ce) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(OWLDataHasValue ce) {
            return Boolean.TRUE;
        }
    }

    private class OWL2RLObjectVisitor
    extends OWLOntologyWalkerVisitor {
        private final Set<OWLProfileViolation> violations;

        OWL2RLObjectVisitor(OWLOntologyWalker walker) {
            super(walker);
            this.violations = new HashSet<OWLProfileViolation>();
        }

        public Set<OWLProfileViolation> getProfileViolations() {
            return new HashSet<OWLProfileViolation>(this.violations);
        }

        @Override
        public void visit(OWLClassAssertionAxiom axiom) {
            if (!OWL2RLProfile.this.isOWL2RLSuperClassExpression(axiom.getClassExpression())) {
                this.violations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getClassExpression()));
            }
        }

        @Override
        public void visit(OWLDataPropertyDomainAxiom axiom) {
            if (!OWL2RLProfile.this.isOWL2RLSuperClassExpression((OWLClassExpression)axiom.getDomain())) {
                this.violations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, (OWLClassExpression)axiom.getDomain()));
            }
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            axiom.classExpressions().filter(ce -> !OWL2RLProfile.this.isOWL2RLEquivalentClassExpression((OWLClassExpression)ce)).forEach(ce -> this.violations.add(new UseOfNonSubClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, (OWLClassExpression)ce)));
        }

        @Override
        public void visit(OWLDisjointUnionAxiom axiom) {
            this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            axiom.classExpressions().filter(ce -> !OWL2RLProfile.this.isOWL2RLEquivalentClassExpression((OWLClassExpression)ce)).forEach(ce -> this.violations.add(new UseOfNonEquivalentClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, (OWLClassExpression)ce)));
        }

        @Override
        public void visit(OWLHasKeyAxiom axiom) {
            if (!OWL2RLProfile.this.isOWL2RLSubClassExpression(axiom.getClassExpression())) {
                this.violations.add(new UseOfNonSubClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getClassExpression()));
            }
        }

        @Override
        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            if (!OWL2RLProfile.this.isOWL2RLSuperClassExpression((OWLClassExpression)axiom.getDomain())) {
                this.violations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, (OWLClassExpression)axiom.getDomain()));
            }
        }

        @Override
        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            if (!OWL2RLProfile.this.isOWL2RLSuperClassExpression((OWLClassExpression)axiom.getRange())) {
                this.violations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, (OWLClassExpression)axiom.getRange()));
            }
        }

        @Override
        public void visit(OWLSubClassOfAxiom axiom) {
            if (!OWL2RLProfile.this.isOWL2RLSubClassExpression(axiom.getSubClass())) {
                this.violations.add(new UseOfNonSubClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getSubClass()));
            }
            if (!OWL2RLProfile.this.isOWL2RLSuperClassExpression(axiom.getSuperClass())) {
                this.violations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getSuperClass()));
            }
        }

        @Override
        public void visit(SWRLRule rule) {
            this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), rule));
        }

        @Override
        public void visit(OWLDataOneOf node) {
            this.violations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }

        @Override
        public void visit(OWLDataComplementOf node) {
            this.violations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }

        @Override
        public void visit(OWLDatatype node) {
            if (!ALLOWED_DATATYPES.contains(node.getIRI())) {
                this.violations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            }
        }

        @Override
        public void visit(OWLDatatypeRestriction node) {
            this.violations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }

        @Override
        public void visit(OWLDataUnionOf node) {
            this.violations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }

        @Override
        public void visit(OWLDatatypeDefinitionAxiom axiom) {
            this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }
    }

    private static class OWL2RLEquivalentClassExpressionChecker
    implements OWLClassExpressionVisitorEx<Boolean> {
        OWL2RLEquivalentClassExpressionChecker() {
        }

        @Override
        public Boolean doDefault(Object o) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean visit(OWLClass ce) {
            return !ce.isOWLThing();
        }

        @Override
        public Boolean visit(OWLObjectIntersectionOf ce) {
            return !ce.operands().anyMatch(e -> e.accept(this) == false);
        }

        @Override
        public Boolean visit(OWLObjectHasValue ce) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(OWLDataHasValue ce) {
            return Boolean.TRUE;
        }
    }
}

