/*
 * Decompiled with CFR 0.152.
 */
package org.cts.crs;

import java.util.ArrayList;
import org.cts.Identifier;
import org.cts.crs.CoordinateReferenceSystem;
import org.cts.crs.GeodeticCRS;
import org.cts.cs.Axis;
import org.cts.cs.CoordinateSystem;
import org.cts.datum.GeodeticDatum;
import org.cts.op.ChangeCoordinateDimension;
import org.cts.op.CoordinateOperation;
import org.cts.op.CoordinateOperationSequence;
import org.cts.op.CoordinateSwitch;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.OppositeCoordinate;
import org.cts.op.UnitConversion;
import org.cts.op.projection.Projection;
import org.cts.units.Unit;

public class ProjectedCRS
extends GeodeticCRS {
    public static final CoordinateSystem EN_CS = new CoordinateSystem(new Axis[]{Axis.EASTING, Axis.NORTHING}, new Unit[]{Unit.METER, Unit.METER});
    public static final CoordinateSystem NE_CS = new CoordinateSystem(new Axis[]{Axis.NORTHING, Axis.EASTING}, new Unit[]{Unit.METER, Unit.METER});
    private Projection projection;

    public ProjectedCRS(Identifier identifier, GeodeticDatum datum, CoordinateSystem coordSys, Projection projection) {
        super(identifier, datum, coordSys);
        this.projection = projection;
    }

    public ProjectedCRS(Identifier identifier, GeodeticDatum datum, Projection projection, Unit unit) {
        super(identifier, datum, new CoordinateSystem(new Axis[]{Axis.EASTING, Axis.NORTHING}, new Unit[]{unit, unit}));
        this.projection = projection;
    }

    public ProjectedCRS(Identifier identifier, GeodeticDatum datum, Projection projection) {
        super(identifier, datum, EN_CS);
        this.projection = projection;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public CoordinateReferenceSystem.Type getType() {
        return CoordinateReferenceSystem.Type.PROJECTED;
    }

    public CoordinateOperation toGeographicCoordinateConverter() throws NonInvertibleOperationException {
        ArrayList<CoordinateOperation> ops = new ArrayList<CoordinateOperation>();
        for (int i = 0; i < 2; ++i) {
            if (this.getCoordinateSystem().getAxis(i).getDirection() != Axis.Direction.SOUTH && this.getCoordinateSystem().getAxis(i).getDirection() != Axis.Direction.WEST) continue;
            ops.add(new OppositeCoordinate(i));
        }
        if (this.getCoordinateSystem().getUnit(0) != Unit.METER) {
            ops.add(UnitConversion.createUnitConverter(this.getCoordinateSystem().getUnit(0), Unit.METER));
        }
        if (this.getCoordinateSystem().getAxis(0).getDirection() == Axis.Direction.NORTH || this.getCoordinateSystem().getAxis(0).getDirection() == Axis.Direction.SOUTH) {
            ops.add(CoordinateSwitch.SWITCH_LAT_LON);
        }
        ops.add(this.projection.inverse());
        ops.add(ChangeCoordinateDimension.TO3D);
        return new CoordinateOperationSequence(new Identifier(CoordinateOperationSequence.class), ops);
    }

    public CoordinateOperation fromGeographicCoordinateConverter() {
        ArrayList<CoordinateOperation> ops = new ArrayList<CoordinateOperation>();
        ops.add(ChangeCoordinateDimension.TO2D);
        ops.add(this.projection);
        if (this.getCoordinateSystem().getAxis(0).getDirection() == Axis.Direction.NORTH || this.getCoordinateSystem().getAxis(0).getDirection() == Axis.Direction.SOUTH) {
            ops.add(CoordinateSwitch.SWITCH_LAT_LON);
        }
        if (this.getCoordinateSystem().getUnit(0) != Unit.METER) {
            ops.add(UnitConversion.createUnitConverter(Unit.METER, this.getCoordinateSystem().getUnit(0)));
        }
        for (int i = 0; i < 2; ++i) {
            if (this.getCoordinateSystem().getAxis(i).getDirection() != Axis.Direction.SOUTH && this.getCoordinateSystem().getAxis(i).getDirection() != Axis.Direction.WEST) continue;
            ops.add(new OppositeCoordinate(i));
        }
        return new CoordinateOperationSequence(new Identifier(CoordinateOperationSequence.class), ops);
    }

    public String toWKT() {
        StringBuilder w = new StringBuilder();
        w.append("PROJCS[\"");
        w.append(this.getName());
        w.append("\",GEOGCS[\"");
        w.append(this.getDatum().getShortName());
        w.append("\",");
        w.append(this.getDatum().toWKT());
        w.append(',');
        w.append(this.getDatum().getPrimeMeridian().toWKT());
        w.append("],");
        w.append(this.getProjection().toWKT(this.getCoordinateSystem().getUnit(0)));
        w.append(',');
        w.append(this.getCoordinateSystem().getUnit(0).toWKT());
        for (int i = 0; i < this.getCoordinateSystem().getDimension(); ++i) {
            w.append(',');
            w.append(this.getCoordinateSystem().getAxis(i).toWKT());
        }
        if (!this.getAuthorityName().startsWith("LOCAL")) {
            w.append(',');
            w.append(this.getIdentifier().toWKT());
        }
        w.append(']');
        return w.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof GeodeticCRS) {
            GeodeticCRS crs = (GeodeticCRS)o;
            if (!this.getType().equals((Object)crs.getType())) {
                return false;
            }
            if (this.getIdentifier().equals(crs.getIdentifier())) {
                return true;
            }
            return this.getDatum().equals(crs.getDatum()) && this.getProjection().equals(crs.getProjection()) && this.getCoordinateSystem().equals(crs.getCoordinateSystem());
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + (this.getDatum() != null ? this.getDatum().hashCode() : 0);
        hash = 59 * hash + (this.projection != null ? this.projection.hashCode() : 0);
        return hash;
    }
}

