/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.analytics;

import com.bigdata.rdf.graph.BinderBase;
import com.bigdata.rdf.graph.EdgesEnum;
import com.bigdata.rdf.graph.Factory;
import com.bigdata.rdf.graph.FrontierEnum;
import com.bigdata.rdf.graph.IBinder;
import com.bigdata.rdf.graph.IGASContext;
import com.bigdata.rdf.graph.IGASScheduler;
import com.bigdata.rdf.graph.IGASState;
import com.bigdata.rdf.graph.IPredecessor;
import com.bigdata.rdf.graph.impl.BaseGASProgram;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;

public class BFS
extends BaseGASProgram<VS, ES, Void>
implements IPredecessor<VS, ES, Void> {
    private static final Factory<Value, VS> vertexStateFactory = new Factory<Value, VS>(){

        @Override
        public VS initialValue(Value value) {
            return new VS();
        }
    };

    @Override
    public Factory<Value, VS> getVertexStateFactory() {
        return vertexStateFactory;
    }

    @Override
    public Factory<Statement, ES> getEdgeStateFactory() {
        return null;
    }

    @Override
    public FrontierEnum getInitialFrontierEnum() {
        return FrontierEnum.SingleVertex;
    }

    @Override
    public EdgesEnum getGatherEdges() {
        return EdgesEnum.NoEdges;
    }

    @Override
    public EdgesEnum getScatterEdges() {
        return EdgesEnum.OutEdges;
    }

    @Override
    public void initVertex(IGASContext<VS, ES, Void> ctx, IGASState<VS, ES, Void> state, Value u) {
        state.getState(u).visit(0, null);
    }

    @Override
    public Void gather(IGASState<VS, ES, Void> state, Value u, Statement e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Void sum(IGASState<VS, ES, Void> state, Void left, Void right) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VS apply(IGASState<VS, ES, Void> state, Value u, Void sum) {
        return null;
    }

    @Override
    public boolean isChanged(IGASState<VS, ES, Void> state, Value u) {
        return true;
    }

    @Override
    public void scatter(IGASState<VS, ES, Void> state, IGASScheduler sch, Value u, Statement e) {
        Value v = state.getOtherVertex(u, e);
        VS otherState = state.getState(v);
        if (otherState.visit(state.round() + 1, u)) {
            sch.schedule(v);
        }
    }

    @Override
    public boolean nextRound(IGASContext<VS, ES, Void> ctx) {
        return true;
    }

    @Override
    public List<IBinder<VS, ES, Void>> getBinderList() {
        List<IBinder<VS, ES, Void>> tmp = super.getBinderList();
        tmp.add(new BinderBase<VS, ES, Void>(){

            @Override
            public int getIndex() {
                return 1;
            }

            @Override
            public Value bind(ValueFactory vf, IGASState<VS, ES, Void> state, Value u) {
                return vf.createLiteral(state.getState(u).depth.get());
            }
        });
        tmp.add(new BinderBase<VS, ES, Void>(){

            @Override
            public int getIndex() {
                return 2;
            }

            @Override
            public Value bind(ValueFactory vf, IGASState<VS, ES, Void> state, Value u) {
                return (Value)state.getState(u).predecessor.get();
            }
        });
        return tmp;
    }

    @Override
    public void prunePaths(IGASContext<VS, ES, Void> ctx, Value[] targetVertices) {
        if (ctx == null) {
            throw new IllegalArgumentException();
        }
        if (targetVertices == null) {
            throw new IllegalArgumentException();
        }
        IGASState<VS, ES, Void> gasState = ctx.getGASState();
        HashSet<Value> retainSet = new HashSet<Value>();
        for (Value v : targetVertices) {
            if (!gasState.isVisited(v)) continue;
            Value current = v;
            while (current != null) {
                Value predecessor;
                retainSet.add(current);
                VS currentState = gasState.getState(current);
                current = predecessor = currentState.predecessor();
            }
        }
        gasState.retainAll(retainSet);
    }

    public static interface Bindings
    extends BaseGASProgram.Bindings {
        public static final int DEPTH = 1;
        public static final int PREDECESSOR = 2;
    }

    public static class ES {
    }

    public static class VS {
        private final AtomicInteger depth = new AtomicInteger(-1);
        private final AtomicReference<Value> predecessor = new AtomicReference();

        public int depth() {
            return this.depth.get();
        }

        public Value predecessor() {
            return this.predecessor.get();
        }

        public boolean visit(int depth, Value predecessor) {
            if (this.depth.compareAndSet(-1, depth)) {
                this.predecessor.set(predecessor);
                return true;
            }
            return false;
        }

        public String toString() {
            return "{depth=" + this.depth() + "}";
        }
    }
}

