/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.slurm.job;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import uk.ac.cam.cares.jps.base.slurm.job.Status;
import uk.ac.cam.cares.jps.base.slurm.job.Utils;
import uk.ac.cam.cares.jps.base.util.FileUtil;

public class PostProcessing {
    public static boolean updateJobOutputStatus(File jobFolder) throws IOException {
        File statusFile = Utils.getStatusFile(jobFolder);
        return PostProcessing.updateJobOutputStatus(statusFile, Status.OUTPUT_PROCESSED.getName());
    }

    private static boolean updateJobOutputStatus(File statusFile, String status) throws IOException {
        if (statusFile != null) {
            PostProcessing.modifyOutputStatus(statusFile.getAbsolutePath(), Status.OUTPUT_PROCESSED.getName());
            return true;
        }
        return false;
    }

    public static void modifyOutputStatus(String filePath, String status) throws IOException {
        String line;
        ArrayList<String> fileContent = new ArrayList<String>();
        BufferedReader br = FileUtil.openSourceFile(filePath);
        while ((line = br.readLine()) != null) {
            if (line.trim().startsWith(Status.ATTRIBUTE_JOB_OUTPUT.getName())) {
                line = Status.ATTRIBUTE_JOB_OUTPUT.getName().concat(" ").concat(status);
            }
            fileContent.add(line);
        }
        br.close();
        BufferedWriter bw = FileUtil.openBufferedWriter(filePath);
        for (String lineContent : fileContent) {
            bw.write(lineContent.concat("\n"));
        }
        bw.flush();
        bw.close();
    }
}

