/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Base64;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.jena.arq.querybuilder.ConstructBuilder;
import org.apache.jena.arq.querybuilder.UpdateBuilder;
import org.apache.jena.jdbc.remote.RemoteEndpointDriver;
import org.apache.jena.query.Query;
import org.apache.jena.query.TxnType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionRemote;
import org.apache.jena.rdfconnection.RDFConnectionRemoteBuilder;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.update.UpdateRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.rdf4j.federated.FedXFactory;
import org.eclipse.rdf4j.federated.repository.FedXRepository;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;

public class RemoteStoreClient
implements StoreClientInterface {
    private static final Logger LOGGER = LogManager.getLogger(RemoteStoreClient.class);
    private static final String HTTP_PROTOCOL = "http:";
    private static final String HTTPS_PROTOCOL = "https:";
    private String queryEndpoint;
    private String updateEndpoint;
    private String query;
    private String userName;
    private String password;

    public RemoteStoreClient() {
    }

    public RemoteStoreClient(String queryEndpoint) {
        this.queryEndpoint = queryEndpoint;
    }

    public RemoteStoreClient(String queryEndpoint, String updateEndpoint) {
        this.queryEndpoint = queryEndpoint;
        this.updateEndpoint = updateEndpoint;
    }

    public RemoteStoreClient(String queryEndpoint, String user, String password) {
        this.queryEndpoint = queryEndpoint;
        this.userName = user;
        this.password = password;
    }

    public RemoteStoreClient(String queryEndpoint, String updateEndpoint, String user, String password) {
        this.queryEndpoint = queryEndpoint;
        this.updateEndpoint = updateEndpoint;
        this.userName = user;
        this.password = password;
    }

    public RemoteStoreClient(String queryEndpoint, String updateEndpoint, String query, String user, String password) {
        this.query = query;
        this.queryEndpoint = queryEndpoint;
        this.updateEndpoint = updateEndpoint;
        this.userName = user;
        this.password = password;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public String setQuery(String query) {
        this.query = query;
        return this.query;
    }

    @Override
    public String getQueryEndpoint() {
        return this.queryEndpoint;
    }

    @Override
    public String setQueryEndpoint(String queryEndpoint) {
        this.queryEndpoint = queryEndpoint;
        return this.queryEndpoint;
    }

    @Override
    public String getUpdateEndpoint() {
        return this.updateEndpoint;
    }

    @Override
    public String setUpdateEndpoint(String updateEndpoint) {
        this.updateEndpoint = updateEndpoint;
        return this.updateEndpoint;
    }

    @Override
    public String getUser() {
        return this.userName;
    }

    @Override
    public void setUser(String userName) {
        this.userName = userName;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public int executeUpdate() {
        String connectionUrl = this.getConnectionUrl();
        if (connectionUrl.isEmpty()) {
            throw new JPSRuntimeException("KnowledgeBaseClient: connection URL for the update operation is empty.");
        }
        if (this.isConnectionUpdateUrlValid(connectionUrl)) {
            return this.executeUpdate(this.query);
        }
        throw new JPSRuntimeException("KnowledgeBaseClient: connection URL for the update operation is not valid.");
    }

    @Override
    public int executeUpdate(UpdateRequest update) {
        return this.executeUpdate(update.toString());
    }

    @Override
    public int executeUpdate(String query) {
        Connection conn = null;
        Statement stmt = null;
        try {
            RemoteEndpointDriver.register();
            System.out.println(this.getConnectionUrl());
            conn = DriverManager.getConnection(this.getConnectionUrl());
            stmt = conn.createStatement(1003, 1007);
            return stmt.executeUpdate(query);
        }
        catch (SQLException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String execute() {
        return this.execute(this.query);
    }

    @Override
    public String execute(String query) {
        JSONArray result = this.executeQuery(query);
        if (result == null) {
            throw new JPSRuntimeException("KnowledgeBaseClient: sparql query result is null.");
        }
        return result.toString();
    }

    @Override
    public JSONArray executeQuery() {
        String connectionUrl = this.getConnectionUrl();
        if (connectionUrl.isEmpty()) {
            throw new JPSRuntimeException("KnowledgeBaseClient: the URL to connect to the endpoint is empty");
        }
        if (this.isConnectionQueryUrlValid(connectionUrl)) {
            return this.executeQuery(this.query);
        }
        throw new JPSRuntimeException("KnowledgeBaseClient: the URL to connect to the endpoint is not valid");
    }

    @Override
    public JSONArray executeQuery(String query) {
        JSONArray results = new JSONArray();
        Connection conn = null;
        Statement stmt = null;
        try {
            RemoteEndpointDriver.register();
            System.out.println(this.getConnectionUrl());
            conn = DriverManager.getConnection(this.getConnectionUrl());
            stmt = conn.createStatement(1003, 1007);
            ResultSet rs = stmt.executeQuery(query);
            results = this.convert(rs);
        }
        catch (SQLException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        return results;
    }

    @Override
    public Model executeConstruct(Query sparql) {
        return this.executeConstruct(sparql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model executeConstruct(String sparql) {
        RDFConnection conn = this.connectQuery();
        if (conn != null) {
            conn.begin(TxnType.READ);
            try {
                Model model = conn.queryConstruct(sparql);
                return model;
            }
            finally {
                conn.end();
            }
        }
        throw new JPSRuntimeException("FileBasedKnowledgeBaseClient: client not initialised.");
    }

    private RDFConnection connectQuery() {
        RDFConnectionRemoteBuilder builder = null;
        if (this.queryEndpoint == null) {
            throw new JPSRuntimeException("RemoteStoreClient: update endpoint not specified.");
        }
        builder = RDFConnectionRemote.create().destination(this.queryEndpoint);
        return builder.build();
    }

    public String getConnectionUrl() {
        StringBuilder sb = new StringBuilder();
        boolean queryFlag = false;
        boolean updateFlag = false;
        sb.append("jdbc:jena:");
        sb.append("remote:");
        if (this.queryEndpoint != null) {
            queryFlag = true;
            sb.append(this.generateEndpointProperty("query", this.queryEndpoint));
        }
        if (this.updateEndpoint != null) {
            updateFlag = true;
            if (queryFlag) {
                sb.append("&");
            }
            sb.append(this.generateEndpointProperty("update", this.updateEndpoint));
        }
        if (this.userName != null) {
            if (queryFlag || updateFlag) {
                sb.append("&");
            }
            sb.append(this.generateEndpointProperty("user", this.userName));
        }
        if (this.password != null) {
            if (queryFlag || updateFlag) {
                sb.append("&");
            }
            sb.append(this.generateEndpointProperty("password", this.password));
        }
        return sb.toString();
    }

    private String generateEndpointProperty(String endpointType, String endpointURL) {
        StringBuilder sb = new StringBuilder();
        sb.append(endpointType);
        sb.append("=");
        sb.append(endpointURL);
        return sb.toString();
    }

    private JSONArray convert(ResultSet rs) throws SQLException, JSONException {
        JSONArray json = new JSONArray();
        ResultSetMetaData rsmd = rs.getMetaData();
        while (rs.next()) {
            int numColumns = rsmd.getColumnCount();
            JSONObject obj = new JSONObject();
            for (int i = 1; i < numColumns + 1; ++i) {
                String column_name = rsmd.getColumnName(i);
                if (rsmd.getColumnType(i) == 2003) {
                    obj.put(column_name, (Object)rs.getArray(column_name));
                    continue;
                }
                if (rsmd.getColumnType(i) == -5) {
                    obj.put(column_name, rs.getInt(column_name));
                    continue;
                }
                if (rsmd.getColumnType(i) == 16) {
                    obj.put(column_name, rs.getBoolean(column_name));
                    continue;
                }
                if (rsmd.getColumnType(i) == 2004) {
                    obj.put(column_name, (Object)rs.getBlob(column_name));
                    continue;
                }
                if (rsmd.getColumnType(i) == 8) {
                    obj.put(column_name, rs.getDouble(column_name));
                    continue;
                }
                if (rsmd.getColumnType(i) == 6) {
                    obj.put(column_name, rs.getFloat(column_name));
                    continue;
                }
                if (rsmd.getColumnType(i) == 4) {
                    obj.put(column_name, rs.getInt(column_name));
                    continue;
                }
                if (rsmd.getColumnType(i) == -9) {
                    obj.put(column_name, (Object)rs.getNString(column_name));
                    continue;
                }
                if (rsmd.getColumnType(i) == 12) {
                    obj.put(column_name, (Object)rs.getString(column_name));
                    continue;
                }
                if (rsmd.getColumnType(i) == -6) {
                    obj.put(column_name, rs.getInt(column_name));
                    continue;
                }
                if (rsmd.getColumnType(i) == 5) {
                    obj.put(column_name, rs.getInt(column_name));
                    continue;
                }
                if (rsmd.getColumnType(i) == 91) {
                    obj.put(column_name, (Object)rs.getDate(column_name));
                    continue;
                }
                if (rsmd.getColumnType(i) == 93) {
                    obj.put(column_name, (Object)rs.getTimestamp(column_name));
                    continue;
                }
                obj.put(column_name, rs.getObject(column_name));
            }
            json.put((Object)obj);
        }
        return json;
    }

    public boolean isConnectionQueryUrlValid(String connectionUrl) {
        if (connectionUrl.startsWith(this.getQueryEndpointConnectionPrfixes().concat(HTTP_PROTOCOL)) || connectionUrl.startsWith(this.getQueryEndpointConnectionPrfixes().concat(HTTPS_PROTOCOL))) {
            return this.isConnectionUrlValid(connectionUrl);
        }
        return false;
    }

    public boolean isConnectionUpdateUrlValid(String connectionUrl) {
        if (this.isConnectionQueryUrlValid(connectionUrl) && (connectionUrl.contains(this.getUpdateEndpointConnectionParameter().concat(HTTP_PROTOCOL)) || connectionUrl.contains(this.getUpdateEndpointConnectionParameter().concat(HTTPS_PROTOCOL)))) {
            return true;
        }
        if (connectionUrl.startsWith(this.getUpdateEndpointConnectionPrefixes().concat(HTTP_PROTOCOL)) || connectionUrl.startsWith(this.getUpdateEndpointConnectionPrefixes().concat(HTTPS_PROTOCOL))) {
            return this.isConnectionUrlValid(connectionUrl);
        }
        return false;
    }

    private boolean isConnectionUrlValid(String connectionUrl) {
        String[] tokens = new String[]{""};
        if (connectionUrl.contains(HTTP_PROTOCOL)) {
            tokens = connectionUrl.split(HTTP_PROTOCOL);
        } else if (connectionUrl.contains(HTTPS_PROTOCOL)) {
            tokens = connectionUrl.split(HTTPS_PROTOCOL);
        }
        for (String token : tokens) {
            if (token.isEmpty()) {
                return false;
            }
            if (token.length() >= 3) continue;
            return false;
        }
        return true;
    }

    private String getQueryEndpointConnectionPrfixes() {
        return "jdbc:jena:".concat("remote:").concat("query").concat("=");
    }

    private String getUpdateEndpointConnectionPrefixes() {
        return "jdbc:jena:".concat("remote:").concat("update").concat("=");
    }

    private String getUpdateEndpointConnectionParameter() {
        return "update".concat("=");
    }

    public JSONArray executeFederatedQuery(List<String> endpoints, String query) throws Exception {
        JSONArray json = new JSONArray();
        FedXRepository repository = FedXFactory.createSparqlFederation(endpoints);
        try {
            RepositoryConnection conn = repository.getConnection();
            TupleQuery tq = conn.prepareTupleQuery(query);
            try {
                TupleQueryResult tqRes = tq.evaluate();
                while (tqRes.hasNext()) {
                    JSONObject obj = new JSONObject();
                    BindingSet bSet = (BindingSet)tqRes.next();
                    for (String bindingName : bSet.getBindingNames()) {
                        if (bSet.getValue(bindingName).toString().startsWith("\"") && bSet.getValue(bindingName).toString().endsWith("\"")) {
                            obj.put(bindingName, (Object)bSet.getValue(bindingName).toString().substring(1, bSet.getValue(bindingName).toString().length() - 1));
                            continue;
                        }
                        obj.put(bindingName, (Object)bSet.getValue(bindingName).toString());
                    }
                    json.put((Object)obj);
                }
            }
            catch (TupleQueryResultHandlerException e) {
                e.printStackTrace();
            }
            conn.close();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        repository.shutDown();
        return json;
    }

    @Override
    public String get(String resourceUrl, String accept) {
        Var varS = Var.alloc((String)"s");
        Var varP = Var.alloc((String)"p");
        Var varO = Var.alloc((String)"o");
        ConstructBuilder builder = new ConstructBuilder().addConstruct((Object)varS, (Object)varP, (Object)varO);
        if (resourceUrl == null) {
            builder.addWhere((Object)varS, (Object)varP, (Object)varO);
        } else {
            String graphURI = "<" + resourceUrl + ">";
            builder.addGraph((Object)graphURI, (Object)varS, (Object)varP, (Object)varO);
        }
        Model model = this.executeConstruct(builder.build());
        Lang syntax = accept != null ? RDFLanguages.contentTypeToLang((String)accept) : Lang.RDFXML;
        StringWriter out = new StringWriter();
        model.write((Writer)out, syntax.getName());
        return out.toString();
    }

    @Override
    public void insert(String graphName, String content, String contentType) {
        Model model = ModelFactory.createDefaultModel();
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes());
        if (contentType == null) {
            model.read((InputStream)in, null);
        } else {
            Lang syntax = RDFLanguages.contentTypeToLang((String)contentType);
            model.read((InputStream)in, null, syntax.getName());
        }
        UpdateBuilder builder = new UpdateBuilder();
        if (graphName == null) {
            builder.addInsert(model);
        } else {
            String graphURI = "<" + graphName + ">";
            builder.addInsert((Object)graphURI, model);
        }
        this.executeUpdate(builder.buildRequest());
    }

    public void uploadRDFFile(File file) {
        try {
            FileInputStream is = new FileInputStream(file);
            StringEntity entity = new StringEntity(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8), ContentType.create((String)"application/rdf+xml"));
            HttpPost postRequest = new HttpPost(this.updateEndpoint);
            if (this.userName != null && this.password != null) {
                String auth = this.userName + ":" + this.password;
                String encoded_auth = Base64.getEncoder().encodeToString(auth.getBytes());
                postRequest.setHeader("Authorization", "Basic " + encoded_auth);
            }
            postRequest.setEntity((HttpEntity)entity);
            LOGGER.info("Uploading " + file + " to " + this.updateEndpoint);
            CloseableHttpClient httpclient = HttpClients.createDefault();
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)postRequest);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new Exception("Upload RDF file failed");
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException(e);
        }
    }
}

