/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.converter;

import java.io.File;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import org.apache.commons.validator.routines.UrlValidator;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import uk.ac.cam.cares.jps.base.converter.ITBoxManagement;
import uk.ac.cam.cares.jps.base.converter.SpringConfiguration;
import uk.ac.cam.cares.jps.base.converter.TBoxConfiguration;
import uk.ac.cam.cares.jps.base.converter.TBoxGeneration;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;

public class TBoxManagement
extends TBoxGeneration
implements ITBoxManagement {
    private Logger logger = LoggerFactory.getLogger(TBoxManagement.class);
    public OWLDataFactory dataFactory = OWLManager.getOWLDataFactory();
    public OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    public OWLOntology ontology;
    public IRI ontologyIRI;
    public static TBoxConfiguration tBoxConfig;
    public static ApplicationContext applicationContext;
    public String SLASH = "/";
    public String BACKSLASH = "\\";
    public String FILE_EXT_OWL = ".owl";
    public String FILE_EXT_RDF = ".rdf";
    public static final String HTTP_PROTOCOL = "http://";
    public static final String HTTPS_PROTOCOL = "https://";
    public static final String OWL_VERSIONINFO = "versionInfo";
    public static final String OWL_URL = "http://www.w3.org/2002/07/owl#";

    @Override
    public void createOWLClass(String className, String targetName, String relation) throws JPSRuntimeException {
        this.checkClassName(className);
        OWLClass child = this.createClass(className);
        OWLClass parent = null;
        if (targetName != null && !targetName.isEmpty() && relation != null && !relation.isEmpty()) {
            parent = this.createClass(targetName);
            if (relation.equalsIgnoreCase(tBoxConfig.getIsARelation())) {
                this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)child, (OWLClassExpression)parent)));
            } else if (relation.equalsIgnoreCase(tBoxConfig.getEquivalentToRelation())) {
                this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLEquivalentClassesAxiom((OWLClassExpression)child, (OWLClassExpression)parent)));
            }
        } else {
            if (tBoxConfig.gettBoxIri() == null || tBoxConfig.gettBoxIri().isEmpty()) {
                this.logger.error("TBox IRI is not provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
                throw new JPSRuntimeException("TBox IRI must be provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
            }
            if (this.ontology == null) {
                this.logger.error("TBox IRI is missing in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
                throw new JPSRuntimeException("TBox IRI must be provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
            }
            this.ontology.add((OWLAxiom)this.dataFactory.getOWLDeclarationAxiom((OWLEntity)child));
        }
    }

    @Override
    public void addDefinitionToOWLClass(String className, String definition) throws JPSRuntimeException {
        if (definition != null && !definition.isEmpty()) {
            OWLClass clas = this.createClass(className);
            OWLAnnotationProperty comment = this.dataFactory.getRDFSComment();
            OWLAnnotation definitionLiteral = this.dataFactory.getOWLAnnotation(comment, (OWLAnnotationValue)this.dataFactory.getOWLLiteral(definition));
            this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)clas.getIRI(), definitionLiteral)));
        }
    }

    @Override
    public void addDefinitionToObjectProperty(String property, String definition) throws JPSRuntimeException {
        if (definition != null && !definition.isEmpty()) {
            OWLObjectProperty objectProperty = this.createObjectProperty(property);
            OWLAnnotationProperty comment = this.dataFactory.getRDFSComment();
            OWLAnnotation definitionLiteral = this.dataFactory.getOWLAnnotation(comment, (OWLAnnotationValue)this.dataFactory.getOWLLiteral(definition));
            this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)objectProperty.getIRI(), definitionLiteral)));
        }
    }

    @Override
    public void addDefinitionToDataProperty(String property, String definition) throws JPSRuntimeException {
        if (definition != null && !definition.isEmpty()) {
            OWLDataProperty dataProperty = this.createDataProperty(property);
            OWLAnnotationProperty comment = this.dataFactory.getRDFSComment();
            OWLAnnotation definitionLiteral = this.dataFactory.getOWLAnnotation(comment, (OWLAnnotationValue)this.dataFactory.getOWLLiteral(definition));
            this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)dataProperty.getIRI(), definitionLiteral)));
        }
    }

    @Override
    public void addDefinedByToClass(String className, String url) throws JPSRuntimeException {
        if (url != null && !url.isEmpty()) {
            OWLClass clas = this.createClass(className);
            OWLAnnotationProperty isDefinedBy = this.dataFactory.getRDFSIsDefinedBy();
            OWLAnnotation definedByLiteral = this.dataFactory.getOWLAnnotation(isDefinedBy, (OWLAnnotationValue)this.dataFactory.getOWLLiteral(url));
            this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)clas.getIRI(), definedByLiteral)));
        }
    }

    @Override
    public void addDefinedByToObjectProperty(String property, String url) throws JPSRuntimeException {
        if (url != null && !url.isEmpty()) {
            OWLObjectProperty objectProperty = this.createObjectProperty(property);
            OWLAnnotationProperty isDefinedBy = this.dataFactory.getRDFSIsDefinedBy();
            OWLAnnotation definedByLiteral = this.dataFactory.getOWLAnnotation(isDefinedBy, (OWLAnnotationValue)this.dataFactory.getOWLLiteral(url));
            this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)objectProperty.getIRI(), definedByLiteral)));
        }
    }

    @Override
    public void addDefinedByToDataProperty(String property, String url) throws JPSRuntimeException {
        if (url != null && !url.isEmpty()) {
            OWLDataProperty dataProperty = this.createDataProperty(property);
            OWLAnnotationProperty isDefinedBy = this.dataFactory.getRDFSIsDefinedBy();
            OWLAnnotation definedByLiteral = this.dataFactory.getOWLAnnotation(isDefinedBy, (OWLAnnotationValue)this.dataFactory.getOWLLiteral(url));
            this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)dataProperty.getIRI(), definedByLiteral)));
        }
    }

    @Override
    public void addLogicalFormulaToObjectProperty(String property, String quantifier, String domain, String range) throws JPSRuntimeException {
        if (!(quantifier == null || quantifier.isEmpty() || domain == null || domain.isEmpty() || range == null || range.isEmpty())) {
            OWLObjectProperty objectProperty = this.createObjectProperty(property);
            OWLClass rangeClass = null;
            OWLObjectUnionOf objectUnionOfRanges = null;
            this.processUnionOfRelationToAddTypeOfLogicalFormula(objectProperty, quantifier, rangeClass, objectUnionOfRanges, domain, range);
        }
    }

    private void processUnionOfRelationToAddTypeOfLogicalFormula(OWLObjectProperty objectProperty, String quantifier, OWLClass rangeClass, OWLObjectUnionOf objectUnionOfRanges, String domain, String range) throws JPSRuntimeException {
        if (range.contains("UNION")) {
            objectUnionOfRanges = this.getUnionOfRange(objectProperty, range.split("UNION"));
        } else {
            rangeClass = this.createClass(range);
        }
        for (String singleDomain : domain.split("UNION")) {
            this.decideToAddTypeOfLogicalFormula(objectProperty, rangeClass, objectUnionOfRanges, quantifier, singleDomain, range);
        }
    }

    private void decideToAddTypeOfLogicalFormula(OWLObjectProperty objectProperty, OWLClass rangeClass, OWLObjectUnionOf objectUnionOfRanges, String quantifier, String singleDomain, String range) throws JPSRuntimeException {
        OWLClass domainClass = this.createClass(singleDomain);
        if (quantifier != null && !quantifier.isEmpty() && quantifier.trim().equalsIgnoreCase("only")) {
            this.addUniversalQuantification(objectProperty, domainClass, rangeClass, objectUnionOfRanges, range);
        } else if (quantifier != null && !quantifier.isEmpty() && quantifier.trim().equalsIgnoreCase("exactly 1")) {
            this.addExactlyOneQuantification(objectProperty, domainClass, rangeClass);
        } else if (quantifier != null && !quantifier.isEmpty() && quantifier.trim().equalsIgnoreCase("minimum 1")) {
            this.addMinimumOneQuantification(objectProperty, domainClass, rangeClass);
        } else if (quantifier != null && !quantifier.isEmpty() && quantifier.trim().equalsIgnoreCase("maximum 1")) {
            this.addMaximumOneQuantification(objectProperty, domainClass, rangeClass);
        }
    }

    private void addUniversalQuantification(OWLObjectProperty objectProperty, OWLClass domainClass, OWLClass rangeClass, OWLObjectUnionOf objectUnionOfRanges, String range) {
        OWLObjectAllValuesFrom restriction = range.contains("UNION") ? this.dataFactory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)objectProperty, (OWLClassExpression)objectUnionOfRanges) : this.dataFactory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)objectProperty, (OWLClassExpression)rangeClass);
        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)domainClass, (OWLClassExpression)restriction)));
    }

    private void addExactlyOneQuantification(OWLObjectProperty objectProperty, OWLClass domainClass, OWLClass rangeClass) {
        OWLObjectExactCardinality restriction = this.dataFactory.getOWLObjectExactCardinality(1, (OWLObjectPropertyExpression)objectProperty, (OWLClassExpression)rangeClass);
        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)domainClass, (OWLClassExpression)restriction)));
    }

    private void addMinimumOneQuantification(OWLObjectProperty objectProperty, OWLClass domainClass, OWLClass rangeClass) {
        OWLObjectMinCardinality restriction = this.dataFactory.getOWLObjectMinCardinality(1, (OWLObjectPropertyExpression)objectProperty, (OWLClassExpression)rangeClass);
        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)domainClass, (OWLClassExpression)restriction)));
    }

    private void addMaximumOneQuantification(OWLObjectProperty objectProperty, OWLClass domainClass, OWLClass rangeClass) {
        OWLObjectMaxCardinality restriction = this.dataFactory.getOWLObjectMaxCardinality(1, (OWLObjectPropertyExpression)objectProperty, (OWLClassExpression)rangeClass);
        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)domainClass, (OWLClassExpression)restriction)));
    }

    @Override
    public void createOWLDataProperty(String propertyName, String targetName, String relation, String domain, String range) throws JPSRuntimeException {
        this.checkPropertyName(propertyName);
        OWLDataProperty dataProperty = this.createDataProperty(propertyName);
        this.addDomain(dataProperty, domain);
        this.addRange(dataProperty, range);
        OWLDataProperty parentProperty = null;
        if (targetName != null && !targetName.isEmpty() && relation != null && !relation.isEmpty()) {
            parentProperty = this.createDataProperty(targetName);
            if (relation.equalsIgnoreCase(tBoxConfig.getIsARelation())) {
                this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)dataProperty, (OWLDataPropertyExpression)parentProperty)));
            } else if (relation.equalsIgnoreCase(tBoxConfig.getEquivalentToRelation())) {
                this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLEquivalentDataPropertiesAxiom((OWLDataPropertyExpression)dataProperty, (OWLDataPropertyExpression)parentProperty)));
            }
        }
    }

    @Override
    public void createOWLObjectProperty(String propertyName, String targetName, String relation, String domain, String range, String quantifier) throws JPSRuntimeException {
        this.checkPropertyName(propertyName);
        OWLObjectProperty objectProperty = this.createObjectProperty(propertyName);
        this.addDomain(objectProperty, domain, quantifier);
        this.addRange(objectProperty, range, quantifier);
        OWLObjectProperty parentProperty = null;
        if (targetName != null && !targetName.isEmpty() && relation != null && !relation.isEmpty()) {
            parentProperty = this.createObjectProperty(targetName);
            if (relation.equalsIgnoreCase(tBoxConfig.getIsARelation())) {
                this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)objectProperty, (OWLObjectPropertyExpression)parentProperty)));
            } else if (relation.equalsIgnoreCase(tBoxConfig.getEquivalentToRelation())) {
                this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLEquivalentObjectPropertiesAxiom((OWLObjectPropertyExpression)objectProperty, (OWLObjectPropertyExpression)parentProperty)));
            } else if (relation.equalsIgnoreCase(tBoxConfig.getInverseOfRelation())) {
                this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLInverseObjectPropertiesAxiom((OWLObjectPropertyExpression)objectProperty, (OWLObjectPropertyExpression)parentProperty)));
            }
        }
    }

    private void addDomain(OWLDataProperty dataProperty, String domain) throws JPSRuntimeException {
        if (domain == null || domain.isEmpty()) {
            return;
        }
        if (domain.contains("UNION")) {
            this.addUnionOfDomain(dataProperty, domain.split("UNION"));
        } else if (domain.contains("INTERSECTION")) {
            this.addIntersectionOfDomain(dataProperty, domain.split("INTERSECTION"));
        } else {
            this.addSingleClassDomain(dataProperty, domain);
        }
    }

    private void addDomain(OWLObjectProperty objectProperty, String domain, String quantifier) throws JPSRuntimeException {
        if (domain == null || domain.isEmpty()) {
            return;
        }
        if (domain.contains("UNION")) {
            this.addUnionOfDomain(objectProperty, domain.split("UNION"));
        } else if (domain.contains("INTERSECTION")) {
            this.addIntersectionOfDomain(objectProperty, domain.split("INTERSECTION"));
        } else if (quantifier == null || quantifier.isEmpty()) {
            this.addSingleClassDomain(objectProperty, domain);
        }
    }

    private void addRange(OWLDataProperty dataProperty, String range) throws JPSRuntimeException {
        if (range == null || range.isEmpty()) {
            return;
        }
        if (!range.contains("UNION") && !range.contains("INTERSECTION")) {
            this.addSingleDataTypeRange(dataProperty, range);
        }
    }

    private void addRange(OWLObjectProperty objectProperty, String range, String quantifier) throws JPSRuntimeException {
        if (range == null || range.isEmpty()) {
            return;
        }
        if (range.contains("UNION") && (quantifier == null || quantifier.isEmpty())) {
            this.addUnionOfRange(objectProperty, range.split("UNION"));
        } else if (range.contains("INTERSECTION") && (quantifier == null || quantifier.isEmpty())) {
            this.addIntersectionOfRange(objectProperty, range.split("INTERSECTION"));
        } else if (quantifier == null || quantifier.isEmpty()) {
            this.addSingleClassRange(objectProperty, range);
        }
    }

    private void addSingleClassDomain(OWLDataProperty dataProperty, String domain) throws JPSRuntimeException {
        OWLClass owlClass = this.createClass(domain);
        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)dataProperty, (OWLClassExpression)owlClass)));
    }

    private void addSingleClassDomain(OWLObjectProperty objectProperty, String domain) throws JPSRuntimeException {
        OWLClass owlClass = this.createClass(domain);
        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)objectProperty, (OWLClassExpression)owlClass)));
    }

    private void addSingleDataTypeRange(OWLDataProperty dataProperty, String range) throws JPSRuntimeException {
        if (range.trim().startsWith(HTTP_PROTOCOL) || range.trim().startsWith(HTTPS_PROTOCOL)) {
            this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)dataProperty, (OWLDataRange)this.dataFactory.getOWLDatatype(range))));
        } else {
            this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)dataProperty, this.getRange(range))));
        }
    }

    private void addSingleClassRange(OWLObjectProperty objectProperty, String range) throws JPSRuntimeException {
        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)objectProperty, (OWLClassExpression)this.createClass(range))));
    }

    private void addUnionOfRange(OWLObjectProperty objectProperty, String[] ranges) throws JPSRuntimeException {
        HashSet<OWLClass> owlClassExpressions = new HashSet<OWLClass>();
        for (String range : ranges) {
            owlClassExpressions.add(this.createClass(range));
        }
        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)objectProperty, (OWLClassExpression)this.dataFactory.getOWLObjectUnionOf(owlClassExpressions))));
    }

    private OWLObjectUnionOf getUnionOfRange(OWLObjectProperty objectProperty, String[] ranges) throws JPSRuntimeException {
        HashSet<OWLClass> owlClassExpressions = new HashSet<OWLClass>();
        for (String range : ranges) {
            owlClassExpressions.add(this.createClass(range));
        }
        return this.dataFactory.getOWLObjectUnionOf(owlClassExpressions);
    }

    private void addIntersectionOfRange(OWLObjectProperty objectProperty, String[] ranges) throws JPSRuntimeException {
        HashSet<OWLClass> owlClassExpressions = new HashSet<OWLClass>();
        for (String range : ranges) {
            owlClassExpressions.add(this.createClass(range));
        }
        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)objectProperty, (OWLClassExpression)this.dataFactory.getOWLObjectIntersectionOf(owlClassExpressions))));
    }

    private void addUnionOfDomain(OWLObjectProperty objectProperty, String[] domains) throws JPSRuntimeException {
        HashSet<OWLClass> owlClassExpressions = new HashSet<OWLClass>();
        for (String domain : domains) {
            owlClassExpressions.add(this.createClass(domain));
        }
        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)objectProperty, (OWLClassExpression)this.dataFactory.getOWLObjectUnionOf(owlClassExpressions))));
    }

    private OWLObjectUnionOf getUnionOfDomain(OWLObjectProperty objectProperty, String[] domains) throws JPSRuntimeException {
        HashSet<OWLClass> owlClassExpressions = new HashSet<OWLClass>();
        for (String domain : domains) {
            owlClassExpressions.add(this.createClass(domain));
        }
        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)objectProperty, (OWLClassExpression)this.dataFactory.getOWLObjectUnionOf(owlClassExpressions))));
        return this.dataFactory.getOWLObjectUnionOf(owlClassExpressions);
    }

    private void addIntersectionOfDomain(OWLObjectProperty objectProperty, String[] domains) throws JPSRuntimeException {
        HashSet<OWLClass> owlClassExpressions = new HashSet<OWLClass>();
        for (String domain : domains) {
            owlClassExpressions.add(this.createClass(domain));
        }
        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)objectProperty, (OWLClassExpression)this.dataFactory.getOWLObjectIntersectionOf(owlClassExpressions))));
    }

    private void addUnionOfDomain(OWLDataProperty dataProperty, String[] domains) throws JPSRuntimeException {
        HashSet<OWLClass> owlClassExpressions = new HashSet<OWLClass>();
        for (String domain : domains) {
            owlClassExpressions.add(this.createClass(domain));
        }
        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)dataProperty, (OWLClassExpression)this.dataFactory.getOWLObjectUnionOf(owlClassExpressions))));
    }

    private void addIntersectionOfDomain(OWLDataProperty dataProperty, String[] domains) throws JPSRuntimeException {
        HashSet<OWLClass> owlClassExpressions = new HashSet<OWLClass>();
        for (String domain : domains) {
            owlClassExpressions.add(this.createClass(domain));
        }
        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)dataProperty, (OWLClassExpression)this.dataFactory.getOWLObjectIntersectionOf(owlClassExpressions))));
    }

    private OWL2Datatype getRange(String range) {
        if (range.equalsIgnoreCase("string")) {
            return OWL2Datatype.XSD_STRING;
        }
        if (range.equalsIgnoreCase("integer") || range.equalsIgnoreCase("int")) {
            return OWL2Datatype.XSD_INTEGER;
        }
        if (range.equalsIgnoreCase("float")) {
            return OWL2Datatype.XSD_FLOAT;
        }
        if (range.equalsIgnoreCase("double")) {
            return OWL2Datatype.XSD_DOUBLE;
        }
        if (range.equalsIgnoreCase("datetime")) {
            return OWL2Datatype.XSD_DATE_TIME;
        }
        if (range.equalsIgnoreCase("timestamp")) {
            return OWL2Datatype.XSD_DATE_TIME_STAMP;
        }
        return OWL2Datatype.XSD_STRING;
    }

    private OWLClass createClass(String className) throws JPSRuntimeException {
        String[] classLabels = className.contains(",") ? className.split(",") : new String[]{className};
        return this.createClass(classLabels);
    }

    private OWLClass createClass(String[] classLabels) throws JPSRuntimeException {
        if (tBoxConfig.gettBoxIri() == null || tBoxConfig.gettBoxIri().isEmpty()) {
            this.logger.error("TBox IRI is not provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
            throw new JPSRuntimeException("TBox IRI must be provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
        }
        if (this.ontology == null) {
            this.logger.error("TBox IRI is missing in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
            throw new JPSRuntimeException("TBox IRI must be provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
        }
        OWLClass classInOwl = null;
        int labelSequence = 0;
        for (String classLabel : classLabels) {
            if (++labelSequence >= 2) continue;
            this.checkClassName(classLabel);
            classInOwl = classLabel.trim().startsWith(HTTP_PROTOCOL) || classLabel.trim().startsWith(HTTPS_PROTOCOL) ? this.dataFactory.getOWLClass(classLabel.replace(" ", "")) : this.dataFactory.getOWLClass(tBoxConfig.gettBoxIri().concat("#").concat(classLabel.replace(" ", "")));
        }
        return classInOwl;
    }

    private OWLDataProperty createDataProperty(String propertyLabel) throws JPSRuntimeException {
        if (tBoxConfig.gettBoxIri() == null || tBoxConfig.gettBoxIri().isEmpty()) {
            this.logger.error("TBox IRI is not provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
            throw new JPSRuntimeException("TBox IRI must be provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
        }
        if (this.ontology == null) {
            this.logger.error("TBox IRI is missing in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
            throw new JPSRuntimeException("TBox IRI must be provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
        }
        if (propertyLabel.trim().startsWith(HTTP_PROTOCOL) || propertyLabel.trim().startsWith(HTTPS_PROTOCOL)) {
            return this.dataFactory.getOWLDataProperty(propertyLabel.replace(" ", ""));
        }
        return this.dataFactory.getOWLDataProperty(tBoxConfig.gettBoxIri().concat("#").concat(propertyLabel.replace(" ", "")));
    }

    private OWLObjectProperty createObjectProperty(String propertyLabel) throws JPSRuntimeException {
        if (tBoxConfig.gettBoxIri() == null || tBoxConfig.gettBoxIri().isEmpty()) {
            this.logger.error("TBox IRI is not provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
            throw new JPSRuntimeException("TBox IRI must be provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
        }
        if (this.ontology == null) {
            this.logger.error("TBox IRI is missing in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
            throw new JPSRuntimeException("TBox IRI must be provided in the following CSV template file: " + owlFilePath.replace(".owl", ".csv"));
        }
        if (propertyLabel.trim().startsWith(HTTP_PROTOCOL) || propertyLabel.trim().startsWith(HTTPS_PROTOCOL)) {
            return this.dataFactory.getOWLObjectProperty(propertyLabel.replace(" ", ""));
        }
        return this.dataFactory.getOWLObjectProperty(tBoxConfig.gettBoxIri().concat("#").concat(propertyLabel.replace(" ", "")));
    }

    private void checkClassName(String className) throws JPSRuntimeException {
        if (className == null) {
            this.logger.error("Class name is null.");
            throw new JPSRuntimeException("Class name is null.");
        }
        if (className.isEmpty()) {
            this.logger.error("Class name is empty.");
            throw new JPSRuntimeException("Class name is empty.");
        }
    }

    private void checkPropertyName(String propertyName) throws JPSRuntimeException {
        if (propertyName == null) {
            this.logger.error("Property name is null.");
            throw new JPSRuntimeException("Property name is null.");
        }
        if (propertyName.isEmpty()) {
            this.logger.error("Property name is empty.");
            throw new JPSRuntimeException("Property name is empty.");
        }
    }

    @Override
    public void init() throws JPSRuntimeException, OWLOntologyCreationException {
        applicationContext = new AnnotationConfigApplicationContext(new Class[]{SpringConfiguration.class});
        tBoxConfig = (TBoxConfiguration)applicationContext.getBean(TBoxConfiguration.class);
    }

    @Override
    public void instantiateOntologyModel() throws OWLOntologyCreationException {
        if (this.ontologyIRI == null) {
            if (tBoxConfig.gettBoxIri() == null || tBoxConfig.gettBoxIri().isEmpty()) {
                this.logger.error("TBox IRI must be provided.");
                throw new JPSRuntimeException("TBox IRI must be provided.");
            }
            if (!new UrlValidator().isValid(tBoxConfig.gettBoxIri())) {
                this.logger.error("Provided TBox IRI is not a valid:" + tBoxConfig.gettBoxIri());
                throw new JPSRuntimeException("Provided TBox IRI is not a valid:" + tBoxConfig.gettBoxIri());
            }
            this.ontologyIRI = IRI.create((String)tBoxConfig.gettBoxIri());
        }
        this.ontology = this.manager.createOntology(this.ontologyIRI);
        if (this.ontology == null) {
            this.logger.error("The requested ontology could not be created.");
            throw new JPSRuntimeException("Ontology could not be created.");
        }
    }

    @Override
    public void saveOntology(String owlFilePath) throws OWLOntologyStorageException {
        try {
            if (this.getOntologyFileNameFromIri(tBoxConfig.gettBoxIri()) == null || this.getOntologyFileNameFromIri(tBoxConfig.gettBoxIri()).isEmpty()) {
                throw new OWLOntologyStorageException("Invalid TBox file name provided.");
            }
            File file = new File(owlFilePath);
            this.representOntologyMetadata();
            if (tBoxConfig.gettBoxImport() != null && tBoxConfig.gettBoxImport().length() > HTTP_PROTOCOL.length()) {
                for (String ontologyBeingImported : tBoxConfig.gettBoxImport().split(",")) {
                    if (!ontologyBeingImported.trim().startsWith(HTTP_PROTOCOL) && !ontologyBeingImported.trim().startsWith(HTTPS_PROTOCOL)) continue;
                    OWLImportsDeclaration importDeclarationABox = this.dataFactory.getOWLImportsDeclaration(IRI.create((String)ontologyBeingImported.trim()));
                    this.manager.applyChange((OWLOntologyChange)new AddImport(this.ontology, importDeclarationABox));
                }
            }
            this.manager.saveOntology(this.ontology, this.manager.getOntologyFormat(this.ontology), IRI.create((URI)file.toURI()));
            this.logger.info("The TBox has been saved at the path of " + owlFilePath);
        }
        catch (OWLOntologyStorageException e) {
            this.logger.error("The ontology could not be saved.");
            e.printStackTrace();
            throw new OWLOntologyStorageException("The ontology could not be saved.");
        }
        catch (JPSRuntimeException e) {
            this.logger.error("The ontology-code commit hash could not be retrieved.");
            e.printStackTrace();
            throw new OWLOntologyStorageException("The ontology-code commit hash could not be retrieved.");
        }
    }

    private void addDataProperty(IRI iri, String propertyValue, String individialName) throws JPSRuntimeException {
        OWLDataProperty identifierProperty = this.dataFactory.getOWLDataProperty(iri);
        this.addDataProperty(identifierProperty, propertyValue, individialName);
    }

    private void addDataProperty(OWLDataProperty identifierProperty, String propertyValue, String individialName) throws JPSRuntimeException {
        OWLLiteral literal = this.createOWLLiteral(this.dataFactory, propertyValue);
        OWLNamedIndividual individual = this.dataFactory.getOWLNamedIndividual(this.ontologyIRI.toString().concat("#").concat(individialName));
        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.dataFactory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)identifierProperty, (OWLIndividual)individual, literal)));
    }

    private OWLLiteral createOWLLiteral(OWLDataFactory ontoFactory, String literal) {
        return ontoFactory.getOWLLiteral(literal);
    }

    private void representOntologyMetadata() throws JPSRuntimeException {
        this.representComment();
        this.representDateOfGeneration();
        this.representVersion();
        this.representCommitHash();
    }

    private void representComment() throws JPSRuntimeException {
        String comment = tBoxConfig.gettBoxComment();
        if (comment != null && !comment.isEmpty()) {
            OWLLiteral commentValue = this.dataFactory.getOWLLiteral(comment);
            OWLAnnotationProperty commentProperty = this.dataFactory.getRDFSComment();
            OWLAnnotation commentPropertyAttributeWithValue = this.dataFactory.getOWLAnnotation(commentProperty, (OWLAnnotationValue)commentValue);
            this.manager.applyChange((OWLOntologyChange)new AddOntologyAnnotation(this.ontology, commentPropertyAttributeWithValue));
        }
    }

    private void representCommitHash() throws JPSRuntimeException {
        String commitHash = tBoxConfig.getGitCommitHashValue();
        if (commitHash != null && !commitHash.isEmpty()) {
            OWLLiteral commitHashValue = this.dataFactory.getOWLLiteral(commitHash);
            OWLAnnotationProperty commit = this.dataFactory.getOWLAnnotationProperty(IRI.create((String)tBoxConfig.gettBoxIri().concat("#").concat(tBoxConfig.getCompChemGitCommitHash())));
            OWLAnnotation commitAttributeWithValue = this.dataFactory.getOWLAnnotation(commit, (OWLAnnotationValue)commitHashValue);
            this.manager.applyChange((OWLOntologyChange)new AddOntologyAnnotation(this.ontology, commitAttributeWithValue));
        }
    }

    private void representVersion() throws JPSRuntimeException {
        String version = tBoxConfig.gettBoxVersion();
        if (version != null && !version.isEmpty()) {
            OWLLiteral versionValue = this.dataFactory.getOWLLiteral(version);
            OWLAnnotationProperty versionProperty = this.dataFactory.getOWLAnnotationProperty(OWL_URL.concat(OWL_VERSIONINFO));
            OWLAnnotation versionAttributeWithValue = this.dataFactory.getOWLAnnotation(versionProperty, (OWLAnnotationValue)versionValue);
            this.manager.applyChange((OWLOntologyChange)new AddOntologyAnnotation(this.ontology, versionAttributeWithValue));
        }
    }

    private void representDateOfGeneration() throws JPSRuntimeException {
        String date = tBoxConfig.getAnnotationPropertyDate();
        if (date != null && !date.isEmpty()) {
            OWLLiteral dateValue = this.dataFactory.getOWLLiteral(this.getCurrentDate());
            OWLAnnotationProperty dateProperty = this.dataFactory.getOWLAnnotationProperty(date);
            OWLAnnotation versionAttributeWithValue = this.dataFactory.getOWLAnnotation(dateProperty, (OWLAnnotationValue)dateValue);
            this.manager.applyChange((OWLOntologyChange)new AddOntologyAnnotation(this.ontology, versionAttributeWithValue));
        }
    }

    private String getCurrentDate() {
        String pattern = "dd MMMM yyyy";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern, new Locale("en", "UK"));
        String date = simpleDateFormat.format(new Date());
        return date;
    }

    private String getOntologyFileNameFromIri(String iri) {
        if (!iri.contains(this.FILE_EXT_OWL) && !iri.contains(this.FILE_EXT_RDF)) {
            return null;
        }
        if (iri.contains(this.SLASH)) {
            String[] tokens = iri.split(this.SLASH);
            return tokens[tokens.length - 1];
        }
        if (iri.contains(this.BACKSLASH)) {
            String[] tokens = iri.split(this.BACKSLASH);
            return tokens[tokens.length - 1];
        }
        return null;
    }
}

