# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sdw_api']

package_data = \
{'': ['*']}

install_requires = \
['bs4>=0.0.1,<0.0.2', 'pandas>=1.3.4,<2.0.0', 'requests>=2.26.0,<3.0.0']

setup_kwargs = {
    'name': 'sdw-api',
    'version': '0.1.1',
    'description': "Allows downloading data from the ECB's Statistical Data Warehouse (SDW)",
    'long_description': '\n![GitHub issues](https://img.shields.io/github/issues/MaximilianSchroeder/SDW_API)\n![GitHub forks](https://img.shields.io/github/forks/MaximilianSchroeder/SDW_API)\n![GitHub stars](https://img.shields.io/github/stars/MaximilianSchroeder/SDW_API)\n\n\n# A Basic SDW API\nThis package provides a basic API for the ECB\'s Statistical Data Warehouse (SDW).\nIn its current version, a few features are still missing. Nonetheless, the package already allows for downloading data seamlessly. An option allows saving the downloaded data directly into a `.xlsx` spreadsheet.\n\n## 1.0 Basic Functionality\n### 1.1 Installation\nThe package is available via pip. To install the SDW_API simply run `pip install sdw-api` in your command prompt.\n\n### 1.2 Downloading Data\nThe package consists of one main class called `SDW_API`, which handles the data download and basic data treatment automatically. Once the package is downloaded, it can be imported using the following statement:\n\n```python\nfrom sdw_api import SDW_API\n```\n\nThe SDW_API class takes the following input arguments:\n\n```python\nSDW_API(ticker_list, start=None, end=None, outpath=None, filename=None, target_freq=None,method=None)\n```\nThey can be separated into two groups:\n\n* Required/Positional arguments:\n  * `ticker_list`: A python list containing the data series tickers or labels. These are equivalent to the ones used on the SDW website.\n* Keyword Arguments:\n  * `start`: This argument can be used, if a start date is to be set. The start date has to be in `YYYY-MM-DD` format. If this argument is specified, only data with a time stamp that is more recent than the start date is retrieved. If the argument is `None`, the entire available history will be downloaded.\n  * `end`: This argument can be used, if an end date is to be set. The end date has to be in `YYYY-MM-DD` format. If this argument is specified, only data with a time stamp that is older than the end date is retrieved.\n  * `outpath`: If the resulting date is to be saved as `.xlsx` an output path can be specified. This argument sets the directory where the data is to be saved.\n  * `filename`: This argument allows to specify a unique filename for the output file. If neither `outpath` nor `filename` are set, the output file is not saved.\n  * `target_freq`: This setting allows for defining a desired output frequency of the final DataFrame or spreadsheet. The class automatically detects the data frequency of the individual data series in `ticker_list`. If `ticker_list` contains time series at monthly as well as quarterly frequency, the highest frequency is assumed as a default. In this example, the output DataFrame will thus be at monthly frequency. In this case, setting  `target_freq` to "Q" overwrites the default. The final DataFrame is then at quarterly frequency.\n  * `method`: If  `target_freq` is set to "Q", but the `ticker_list` also contains time series at monthly frequency, this option allows for setting an aggregation method for the time series at higher frequency. At the moment, only the average is implemented, which is also the default option.\n\n## 2.0 Example\n\nLet\'s assume we want to download Euro area (EA) HICP excluding food and energy (\'ICP.M.U2.Y.XEF000.3.INX\'), EA GDP (\'MNA.Q.Y.I8.W2.S1.S1.B.B1GQ._Z._Z._Z.EUR.LR.N\'), the historical close of the EONIA at monthly frequency (\'FM.M.U2.EUR.4F.MM.EONIA.HSTA\'), and EA total employment in hours worked (\'ENA.Q.Y.I8.W2.S1.S1._Z.EMP._Z._T._Z.HW._Z.N\') over from January 2000 (i.e. \'2000-01-01\') until now.\n\nAssuming the package is imported, let\'s first download the data at monthly frequency:\n\n```python\n# set the tickers to be downloaded\nticker_list = [\'ICP.M.U2.Y.XEF000.3.INX\',\n               \'MNA.Q.Y.I8.W2.S1.S1.B.B1GQ._Z._Z._Z.EUR.LR.N\',\n               \'FM.M.U2.EUR.4F.MM.EONIA.HSTA\',\n               \'ENA.Q.Y.I8.W2.S1.S1._Z.EMP._Z._T._Z.HW._Z.N\']\n\n# set a start date\nstart = \'2000-01-01\'            \n\n# initialize the API\nexample = SDW_API(ticker_list, start=start)\n\n# download the data and compose DataFrame\nexample()\n\n# access the output data\nexample.data\n```\n\nThe head of the resulting DataFrame looks something like this:\n\n|                     |   ICP.M.U2.Y.XEF000.3.INX |   MNA.Q.Y.I8.W2.S1.S1.B.B1GQ._Z._Z._Z.EUR.LR.N |   FM.M.U2.EUR.4F.MM.EONIA.HSTA |   ENA.Q.Y.I8.W2.S1.S1._Z.EMP._Z._T._Z.HW._Z.N |\n|:--------------------|--------------------------:|-----------------------------------------------:|-------------------------------:|----------------------------------------------:|\n| 2000-01-31 00:00:00 |                   79.8723 |                                  nan           |                        3.04286 |                                 nan           |\n| 2000-02-29 00:00:00 |                   79.8981 |                                  nan           |                        3.27571 |                                 nan           |\n| 2000-03-31 00:00:00 |                   79.9401 |                                    2.22607e+06 |                        3.51043 |                                   5.83027e+07 |\n| 2000-04-30 00:00:00 |                   79.9912 |                                  nan           |                        3.685   |                                 nan           |\n| 2000-05-31 00:00:00 |                   80.0094 |                                  nan           |                        3.92    |                                 nan           |\n\nTo generate output data at quarterly frequency instead, the following commands can be used:\n\n```python\n# set the tickers to be downloaded\nticker_list = [\'ICP.M.U2.Y.XEF000.3.INX\',\n               \'MNA.Q.Y.I8.W2.S1.S1.B.B1GQ._Z._Z._Z.EUR.LR.N\',\n               \'FM.M.U2.EUR.4F.MM.EONIA.HSTA\',\n               \'ENA.Q.Y.I8.W2.S1.S1._Z.EMP._Z._T._Z.HW._Z.N\']\n\n# set a start date\nstart = \'2000-01-01\'            \ntarget_freq = \'Q\'\n\n# initialize the API\nexample = SDW_API(ticker_list, start=start, target_freq=target_freq)\n\n# download the data and compose DataFrame\nexample()\n\n# access the output data\nexample.data\n```\n\nThe monthly series have now been aggregated to quarterly frequency automatically:\n\n|                     |   ICP.M.U2.Y.XEF000.3.INX |   MNA.Q.Y.I8.W2.S1.S1.B.B1GQ._Z._Z._Z.EUR.LR.N |   FM.M.U2.EUR.4F.MM.EONIA.HSTA |   ENA.Q.Y.I8.W2.S1.S1._Z.EMP._Z._T._Z.HW._Z.N |\n|:--------------------|--------------------------:|-----------------------------------------------:|-------------------------------:|----------------------------------------------:|\n| 2000-03-31 00:00:00 |                   79.9035 |                                    2.22607e+06 |                        3.27634 |                                   5.83027e+07 |\n| 2000-06-30 00:00:00 |                   80.0513 |                                    2.24645e+06 |                        3.96652 |                                   5.85199e+07 |\n| 2000-09-30 00:00:00 |                   80.2987 |                                    2.2588e+06  |                        4.43939 |                                   5.87186e+07 |\n| 2000-12-31 00:00:00 |                   80.5968 |                                    2.27377e+06 |                        4.80622 |                                   5.89292e+07 |\n| 2001-03-31 00:00:00 |                   80.7685 |                                    2.29697e+06 |                        4.84326 |                                   5.90698e+07 |\n\n\n## 3.0 Features coming soon:\n\n* more aggregation methods\n* support for more data frequencies\n',
    'author': 'Max',
    'author_email': 'maximilian.schroder@bi.no',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/MaximilianSchroeder/SDW_API',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
