"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotEventsPutMessageAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const role_1 = require("./private/role");
/**
 * The action to put the message from an MQTT message to the IoT Events input.
 */
class IotEventsPutMessageAction {
    /**
     * @param input The IoT Events input to put messages.
     * @param props Optional properties to not use default
     */
    constructor(input, props = {}) {
        this.input = input;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_IotEventsPutMessageActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IotEventsPutMessageAction);
            }
            throw error;
        }
        this.batchMode = props.batchMode;
        this.messageId = props.messageId;
        this.role = props.role;
        if (this.batchMode && this.messageId) {
            throw new Error('messageId is not allowed when batchMode is true');
        }
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.role ?? (0, role_1.singletonActionRole)(rule);
        this.input.grantWrite(role);
        return {
            configuration: {
                iotEvents: {
                    batchMode: this.batchMode,
                    inputName: this.input.inputName,
                    messageId: this.messageId,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
IotEventsPutMessageAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.IotEventsPutMessageAction", version: "2.72.0-alpha.0" };
exports.IotEventsPutMessageAction = IotEventsPutMessageAction;
//# sourceMappingURL=data:application/json;base64,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