"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirehosePutRecordAction = exports.FirehoseRecordSeparator = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const role_1 = require("./private/role");
/**
 * Record Separator to be used to separate records.
 */
var FirehoseRecordSeparator;
(function (FirehoseRecordSeparator) {
    /**
     * Separate by a new line
     */
    FirehoseRecordSeparator["NEWLINE"] = "\n";
    /**
     * Separate by a tab
     */
    FirehoseRecordSeparator["TAB"] = "\t";
    /**
     * Separate by a windows new line
     */
    FirehoseRecordSeparator["WINDOWS_NEWLINE"] = "\r\n";
    /**
     * Separate by a commma
     */
    FirehoseRecordSeparator["COMMA"] = ",";
})(FirehoseRecordSeparator = exports.FirehoseRecordSeparator || (exports.FirehoseRecordSeparator = {}));
/**
 * The action to put the record from an MQTT message to the Kinesis Data Firehose stream.
 */
class FirehosePutRecordAction {
    /**
     * @param stream The Kinesis Data Firehose stream to which to put records.
     * @param props Optional properties to not use default
     */
    constructor(stream, props = {}) {
        this.stream = stream;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_FirehosePutRecordActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, FirehosePutRecordAction);
            }
            throw error;
        }
        this.batchMode = props.batchMode;
        this.recordSeparator = props.recordSeparator;
        this.role = props.role;
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.role ?? (0, role_1.singletonActionRole)(rule);
        this.stream.grantPutRecords(role);
        return {
            configuration: {
                firehose: {
                    batchMode: this.batchMode,
                    deliveryStreamName: this.stream.deliveryStreamName,
                    roleArn: role.roleArn,
                    separator: this.recordSeparator,
                },
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
FirehosePutRecordAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.FirehosePutRecordAction", version: "2.72.0-alpha.0" };
exports.FirehosePutRecordAction = FirehosePutRecordAction;
//# sourceMappingURL=data:application/json;base64,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