"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoDBv2PutItemAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const role_1 = require("./private/role");
/**
 * The action to put the record from an MQTT message to the DynamoDB table.
 */
class DynamoDBv2PutItemAction {
    /**
     * @param table the DynamoDB table in which to put the items.
     * @param props Optional properties to not use default
     */
    constructor(table, props = {}) {
        this.table = table;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_DynamoDBv2PutItemActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DynamoDBv2PutItemAction);
            }
            throw error;
        }
        this.role = props.role;
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.role ?? (0, role_1.singletonActionRole)(rule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['dynamodb:PutItem'],
            resources: [this.table.tableArn],
        }));
        return {
            configuration: {
                dynamoDBv2: {
                    putItem: {
                        tableName: this.table.tableName,
                    },
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
DynamoDBv2PutItemAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.DynamoDBv2PutItemAction", version: "2.72.0-alpha.0" };
exports.DynamoDBv2PutItemAction = DynamoDBv2PutItemAction;
//# sourceMappingURL=data:application/json;base64,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