# mypy-boto3-codestar-notifications

[![PyPI - mypy-boto3-codestar-notifications](https://img.shields.io/pypi/v/mypy-boto3-codestar-notifications.svg?color=blue)](https://pypi.org/project/mypy-boto3-codestar-notifications)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-codestar-notifications.svg?color=blue)](https://pypi.org/project/mypy-boto3-codestar-notifications)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.CodeStarNotifications 1.16.47](https://boto3.amazonaws.com/v1/documentation/api/1.16.47/reference/services/codestar-notifications.html#CodeStarNotifications) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.3.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-codestar-notifications](#mypy-boto3-codestar-notifications)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `CodeStarNotifications` service.

```bash
python -m pip install boto3-stubs[codestar-notifications]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[codestar-notifications]` in your environment: `python -m pip install 'boto3-stubs[codestar-notifications]'`

Both type checking and auto-complete should work for `CodeStarNotifications` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[codestar-notifications]` in your environment: `python -m pip install 'boto3-stubs[codestar-notifications]'`

Both type checking and auto-complete should work for `CodeStarNotifications` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[codestar-notifications]` in your environment: `python -m pip install 'boto3-stubs[codestar-notifications]'`
- Run `mypy` as usual

Type checking should work for `CodeStarNotifications` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[codestar-notifications]` in your environment: `python -m pip install 'boto3-stubs[codestar-notifications]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `CodeStarNotifications` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`CodeStarNotificationsClient` provides annotations for `boto3.client("codestar-notifications")`.

```python
import boto3

from mypy_boto3_codestar_notifications import CodeStarNotificationsClient

client: CodeStarNotificationsClient = boto3.client("codestar-notifications")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CodeStarNotificationsClient = session.client("codestar-notifications")
```

### Paginators annotations

`mypy_boto3_codestar_notifications.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_codestar_notifications import CodeStarNotificationsClient
from mypy_boto3_codestar_notifications.paginator import (
    ListEventTypesPaginator,
    ListNotificationRulesPaginator,
    ListTargetsPaginator,
)

client: CodeStarNotificationsClient = boto3.client("codestar-notifications")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_event_types_paginator: ListEventTypesPaginator = client.get_paginator("list_event_types")
list_notification_rules_paginator: ListNotificationRulesPaginator = client.get_paginator("list_notification_rules")
list_targets_paginator: ListTargetsPaginator = client.get_paginator("list_targets")
```







### Typed dictionations

`mypy_boto3_codestar_notifications.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_codestar_notifications.type_defs import (
    CreateNotificationRuleResultTypeDef,
    DeleteNotificationRuleResultTypeDef,
    DescribeNotificationRuleResultTypeDef,
    EventTypeSummaryTypeDef,
    ListEventTypesFilterTypeDef,
    ListEventTypesResultTypeDef,
    ListNotificationRulesFilterTypeDef,
    ListNotificationRulesResultTypeDef,
    ListTagsForResourceResultTypeDef,
    ListTargetsFilterTypeDef,
    ListTargetsResultTypeDef,
    NotificationRuleSummaryTypeDef,
    PaginatorConfigTypeDef,
    SubscribeResultTypeDef,
    TagResourceResultTypeDef,
    TargetSummaryTypeDef,
    TargetTypeDef,
    UnsubscribeResultTypeDef,
)

def get_structure() -> EventTypeSummaryTypeDef:
    return {
      ...
    }
```
