/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import org.capnproto.FromPointerBuilder;
import org.capnproto.FromPointerReader;
import org.capnproto.PointerFactory;
import org.capnproto.SegmentBuilder;
import org.capnproto.SegmentReader;
import org.capnproto.SetPointerBuilder;
import org.capnproto.WireHelpers;
import org.capnproto.WirePointer;

public final class AnyPointer {
    public static final Factory factory = new Factory();

    public static final class Builder {
        final SegmentBuilder segment;
        final int pointer;

        public Builder(SegmentBuilder segmentBuilder, int n2) {
            this.segment = segmentBuilder;
            this.pointer = n2;
        }

        public final boolean isNull() {
            return WirePointer.isNull(this.segment.buffer.getLong(this.pointer * 8));
        }

        public final <T> T getAs(FromPointerBuilder<T> fromPointerBuilder) {
            return fromPointerBuilder.fromPointerBuilder(this.segment, this.pointer);
        }

        public final <T> T initAs(FromPointerBuilder<T> fromPointerBuilder) {
            return fromPointerBuilder.initFromPointerBuilder(this.segment, this.pointer, 0);
        }

        public final <T> T initAs(FromPointerBuilder<T> fromPointerBuilder, int n2) {
            return fromPointerBuilder.initFromPointerBuilder(this.segment, this.pointer, n2);
        }

        public final <T, U> void setAs(SetPointerBuilder<T, U> setPointerBuilder, U u2) {
            setPointerBuilder.setPointerBuilder(this.segment, this.pointer, u2);
        }

        public final Reader asReader() {
            return new Reader(this.segment, this.pointer, Integer.MAX_VALUE);
        }

        public final void clear() {
            WireHelpers.zeroObject(this.segment, this.pointer);
            this.segment.buffer.putLong(this.pointer * 8, 0L);
        }
    }

    public static final class Reader {
        final SegmentReader segment;
        final int pointer;
        final int nestingLimit;

        public Reader(SegmentReader segmentReader, int n2, int n3) {
            this.segment = segmentReader;
            this.pointer = n2;
            this.nestingLimit = n3;
        }

        public final boolean isNull() {
            return WirePointer.isNull(this.segment.buffer.getLong(this.pointer * 8));
        }

        public final <T> T getAs(FromPointerReader<T> fromPointerReader) {
            return fromPointerReader.fromPointerReader(this.segment, this.pointer, this.nestingLimit);
        }
    }

    public static final class Factory
    implements PointerFactory<Builder, Reader> {
        @Override
        public final Reader fromPointerReader(SegmentReader segmentReader, int n2, int n3) {
            return new Reader(segmentReader, n2, n3);
        }

        @Override
        public final Builder fromPointerBuilder(SegmentBuilder segmentBuilder, int n2) {
            return new Builder(segmentBuilder, n2);
        }

        @Override
        public final Builder initFromPointerBuilder(SegmentBuilder segmentBuilder, int n2, int n3) {
            Builder builder = new Builder(segmentBuilder, n2);
            builder.clear();
            return builder;
        }
    }
}

