/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gam;

import hex.genmodel.algos.gam.GamUtilsISplines;
import hex.genmodel.algos.gam.NBSplinesTypeII;
import java.io.Serializable;

public class ISplines
implements Serializable {
    private final double[] _knotsWDuplicates;
    private final int _order;
    public int _numIBasis;
    NBSplinesTypeII _bSplines;
    private final ISplineBasis[] _iSplines;

    public ISplines(int order, double[] knots) {
        this._knotsWDuplicates = GamUtilsISplines.fillKnots(knots, order);
        this._order = order;
        this._bSplines = new NBSplinesTypeII(order + 1, knots);
        this._numIBasis = knots.length + order - 2;
        this._iSplines = new ISplineBasis[this._numIBasis];
        for (int index = 0; index < this._numIBasis; ++index) {
            this._iSplines[index] = new ISplineBasis(index, this._order, this._knotsWDuplicates);
        }
    }

    public void gamifyVal(double[] gamifiedResults, double val) {
        if (gamifiedResults == null) {
            gamifiedResults = new double[this._numIBasis];
        }
        for (int basisInd = 0; basisInd < this._numIBasis; ++basisInd) {
            gamifiedResults[basisInd] = val < this._iSplines[basisInd]._knots[0] ? 0.0 : (val >= this._iSplines[basisInd]._knots[this._order] ? 1.0 : this.sumNBSpline(basisInd + 1, val));
        }
    }

    public double sumNBSpline(int startIndex, double val) {
        double gamifiedVal = 0.0;
        int maxBasisInd = this._bSplines._basisFuncs.length;
        for (int basisInd = startIndex; basisInd < maxBasisInd && !(val < this._bSplines._basisFuncs[basisInd]._knots[0]); ++basisInd) {
            if (val >= this._bSplines._basisFuncs[basisInd]._knots[this._bSplines._order]) {
                gamifiedVal += 1.0;
                continue;
            }
            gamifiedVal += NBSplinesTypeII.BSplineBasis.evaluate(val, this._bSplines._basisFuncs[basisInd]);
        }
        return gamifiedVal;
    }

    private static class ISplineBasis
    implements Serializable {
        private double[] _knots;
        private int _NSplineBasisStartIndex;
        private int _order;

        public ISplineBasis(int basisInd, int order, double[] knots) {
            this._NSplineBasisStartIndex = basisInd;
            this._order = order;
            this._knots = GamUtilsISplines.extractKnots(basisInd, order, knots);
        }
    }
}

