# tt-focus

tt-focus: command-line Time Tracker (命令行时间记录器，帮助你集中注意力)

主要用途不是记录工作娱乐等全部生活细节。
而是记录需要集中精神去做的事情的用时情况，以及中间休息情况。

比如吃饭、睡觉、做运动、娱乐等的时间记录 **不适合** 使用本软件。
而写作、以学习为目的的读书、写程序等，就适合使用本软件。

因此，在设计上有点像番茄闹钟。
与番茄闹钟不同的是，每次时长不确定，不会主动闹铃提醒，
而是由用户去进行暂停、继续等操作，每个任务结束后会永久保存记录。

一开始工作/学习就摸鱼，工作/学习中间摸鱼本来只是小休息一下，结果时间飞快溜走。
tt-focus 就是用来解决这个问题的。

但 tt-focus 只是一个工具，它只能帮助你管理自己，但不可能直接控制你，
因此需要你本身有强烈的自我管理意识，才能用好这个工具。

需要手动执行 start, stop 等命令，但不是自动也有好处，电脑关机也不影响。

也不用担心程序在执行过程中意外崩溃

## 添加任务类型

- `tt add <name>` 添加一种任务类型

例如: `tt add coding` 或 `tt add coding -alias 编程`

任务名称只能由 [0-9a-zA-Z_-] 组成，可以有别名，别名不限制字符。

## 修改任务名称或别名

- `tt set -t/--task <task> -name <name>`  修改名称
- `tt set -t/--task <task> -alias <alias>` 修改别名

例：

```shell
$ tt set -t programming -alias 编程
Task: programming () -> programming (编程)
$ tt set -t programming -name coding
Task: programming (编程) -> coding (编程)
```

## 列出任务或事件信息

- `tt list` 最近发生的事件列表
- `tt list -v/--verbose` 最近发生的事件列表(但更详细)
- `tt list -t/--tasks` 任务名称列表
- `tt list -e/--event` 指定事件的详细信息
- `tt list -day 2022-05-01`  指定一天的事件列表
- `tt list -month 2022-05`  指定一个月的全部事件列表
- `tt list -year 2022`  列出指定年份的每月事件数量统计

```sh
$ tt list

* coding (编程)
* reading (阅读)
```

上次发生日期 [上次时长] 任务名称（别名） 


- `tt set -name <old_name> --new-name <new_name>` 改名
- `tt set -name <name> -alias <alias>` 设置别名
- `tt set -id <id> -notes <notes>` 给一个具体的任务设置备注

- `tt set -lang <language>` 设置语言，其中 language 是 cn 或 en
- `tt set -db/--db-folder <folder>` 设置数据库文件夹


备注主要用来记录工作量，或工作进度，比如阅读/写了多少字、完成了多少个功能。

- `tt start <task_name>` 开始计时
- `tt start` 没有任务名称，默认使用上一次的任务。

例如: `tt start coding` 任务 coding 开始计时

一个任务开始后，必须结束后才能开始另一个任务。

- `tt status` 查看当前情况

该命令的结果可能显示：

```sh
$ tt status

当前无正在计时的任务。
```

也可能是：

```sh
$ tt status

Task | coding (编程)
Event| (id:r9mkjv) 2022-05-01 **pausing**
 
total  12:05:00 -> 13:35:00 [01:00:00]
--------------------------------------
split  12:05:00 -> 13:05:00 [01:00:00]
pause  [01:00:00]

wating for resume/stop
```

也可能是：

```sh
$ tt status

Task | coding (编程)
Event| (id:r9mkjv) 2022-05-01 **running**

total  12:05:00 -> 14:05:00 [01:30:00]
--------------------------------------
split  12:05:00 -> 13:05:00 [01:00:00]
pause  [00:30:00]
split  13:35:00 .. 14:05:00 [01:30:00]

wating for pause/split/stop
```

- `tt split` 或 `tt -s` 分段 (任务未结束，标记一个时间点)

该功能源自秒表，通过标记时间节点，有利于了解任务的进展过程。

- `tt pause` 或 `tt -p` 暂停（任务未结束，中间休息）

通常了解中间休息时间也是很有意义的。

- `tt resume` 或 `tt -r` 结束暂停状态，开始下一个分段的计时。

- `tt log` 最近完成的任务
- `tt log -day/-month/-year 2022-05-01` 某天/某月/某年完成的任务总结

- `tt --set-split-min 10` 单位：分钟。默认 5 分钟。小于该值时自动忽略。
- `tt --set-pause-min 10` 单位：分钟。默认 5 分钟。小于该值时自动忽略。
- `tt --set-pause-max 30` 单位：分钟。默认 60 分钟。大于该值时自动忽略。

### 关于自动忽略

具体的规则看起来复杂，但在实际使用中，会是符合直觉的 "自动忽略"。举个例子，采用默认值时，
如果产生了一个 "工作3分钟" 的小节，就会自动删除该小节，相当于没有记录过 3 分钟的工作。
(具体多少分钟，可自定义)

注意，这样处理，是因为本软件的主要用途 **不是记录时间，而是帮助你集中注意力**，
太短的工作时间对于集中注意力来说是毫无意义的。记录时间是手段，集中注意力才是目的。

- 如果上一个小节的工作时间小于 split-min, 此时执行 `tt split` 命令无效。
  即，上一个小节继续计时，不会中断，也不会产生新的小节。
- 如果上一个小节的工作时间小于 split-min, 此时执行 `tt pause`, 则上一个小节被视为无效。
  即，上一个小节被直接删除，然后一个新的 pause 小节开始计时。
- 如果上一个小节的休息时间大于 pause-max, 此时执行 `tt resume`, 则上一个小节被视为无效。
  即，上一个小节被直接删除，并且该事件的状态变为 stopped, 同时启动一个新的事件。
- 如果上一个小节的休息时间小于 pause-min, 此时执行 `tt resume`, 则上一个小节被视为无效。
  即，上一个小节被直接删除，然后一个新的 split 小节开始计时。
- 执行 `tt stop` 时，自动忽略的逻辑与以上情况类似。
- 执行 `tt stop` 时，如果最后一个小节是休息，则删除该最后的休息小节。 
- 因此，可随时使用 pause 命令，后续不管执行 resume 还是 stop, 都不会有多余的休息小节。

## 修改指定事件的最后一个小节的工作时长

- `tt set -e/--event ID --last-work N`  N 分钟

该命令最常用的场景是，正在执行的事件忘了停止，后来发现时已经过去很多个小时了。例如：

Task | reading (阅读)
Event| (id:rbzhec) 2022-05-17 **stopped**

total  00:20:36 -> 08:59:02 [10:35:04]
-------------------------------------
Split  00:20:36 -> 10:55:40 [10:35:04]

在上面的例子了，我在深夜开始了一个阅读事件，但忘了停止，第二天早上 9 点才发现，
执行 `tt stop` 后看到以上信息，阅读时长超过 10 个小时，这是不准确的。

对于这种情况，就可以使用 `tt set -e rbzhec --last-work N` 命令来修改，
其中 N 是一个数字，单位是分钟。

```shell
$ tt set --last-work 65

Task | reading (阅读)
Event| (id:rbzhec) 2022-05-17 **stopped**

total  00:20:36 -> 01:25:36 [1:05:00]
-------------------------------------
Split  00:20:36 -> 01:25:36 [1:05:00]
```

可以，工作时长已改为一小时零五分钟。其中，省略了 '-e rbzhec' 则默认修改刚刚结束的事件。

## 合并事件 (merge events)

同一天，并且是相同的任务类型，并且相邻的事件可以合并。
注意，合并事件会导致 productivity 变低，并且一旦合并就不能分割。

可以预览合并结果 `tt merge -p/--preview rc8j1f rc8dd4`

## 添加或修改事件备注

- `tt set -e <event_id> -notes <notes>`  # 修改指定事件的备注
- `tt set -notes <notes>`  # 如果省略事件 id, 则默认指定 'tt list' 列表中的第一个事件
- `tt set -notes " "`  # 把备注修改为一个或多个空格，相当于删除备注

## 删除任务或事件

## 时间长度

```
>>> print(timedelta(seconds=50000))
13:53:20
```

## 帮助文档

自带详细帮助文档

