# tt-focus

tt-focus: Command-line **t**ime **t**racker to help **focus**  
专门为了帮助集中注意力而设计的命令行时间记录器

tt-focus 有两大特点：

1. 是一个纯命令行程序
2. 主要用途不是记录时间使用情况，而是帮助集中注意力

比如吃饭、睡觉、做运动、娱乐等的时间记录 **不适合** 使用本软件。  
而写作、学习、编程等，就 **适合** 使用本软件。

## 安装

本软件使用了 Python 3.10 的新特性，如果你的系统中未安装 Python 3.10, Windows 用户可直接到 [Python官网](https://www.python.org/downloads/) 下载最新版安装即可。 Linux, MacOS 推荐使用 [pyenv](https://github.com/pyenv/pyenv) 或 [miniconda](https://docs.conda.io/en/latest/miniconda.html) 来安装最新版本的 Python。

在有了 Python 3.10 之后，安装本软件非常简单，只要 `pip install tt-focus` 即可。

### 设置语言

- 程序界面默认是英语，但可设置为中文: `tt set -lang cn`
- 也可随时设置为英语: `tt set -lang en`

## 使用方法

### 添加任务类型

在第一次使用之前，必须至少添加一种任务类型。例如：

- `tt add coding`  (添加任务类型 coding)
- `tt add reading -alias 读书`  (添加任务类型 reading 及其别名)
- `tt list -t`  (查看已添加的任务类型)

任务类型的名称及其别名可以随时修改，方法详见 [readme.md](https://github.com/ahui2016/tt-focus)

### 开始工作 (启动一个事件)

```sh
$ tt start coding

事件 id:rcdrdg, 任务: coding (编程), 开始于 17:22:28
```

### 暂停 (休息/摸鱼)

当你需要稍稍休息一下，可使用该命令 `tt pause` 或 `tt -p`

### 恢复 (回到工作)

从休息中回到工作时，可使用该命令 `tt resume` 或 `tt -r`

### 查看状态

可随时使用命令 `tt status` 或 `tt -s` 查看当前事件的用时情况，例如：

```sh
$ tt -s

Task | coding (编程)
Event| (id:rcbpba) 2022-05-23 **running**

total  14:42:46 -> 16:50:45 [0:41:34]
-------------------------------------
Split  14:42:46 -> 15:24:20 [0:41:34]
Pause  [0:44:37]
Split  16:08:57 .. 16:50:45 [0:41:48]
```

### 结束

- 工作结束，或者需要长时间休息时，使用命令 `tt stop` 结束一次计时。
- 结束后，会显示 "生产效率/集中力"(productivity), 意思是从该事件的开始到结束这段时间内，工作时间所占的比例。

### 事件列表

- `tt list` 查看最近发生的事件。
- `tt list -v` 查看最近事件，并且显示更详细的信息。
- `tt list <event id>` 查看指定事件的详细信息。

## 结语

就我自己的情况，实际使用后最大的感受是，有效地意识到自己在干什么（在工作、还是在摸鱼？），这点对集中精神、提高生产力很有帮助。

本软件功能简单，因此源代码也简单，其中看起来行数较多，但大部分是中英双语提示内容，真正的功能代码不多，而且结构清晰，懂 Python 的人可轻松修改或添加自己想要的功能。

## 源码仓库

<https://github.com/ahui2016/tt-focus>
