import * as cloudfront from '@aws-cdk/aws-cloudfront';
import * as cdk from '@aws-cdk/core';
/**
 * (experimental) Properties for an Origin backed by an S3 website-configured bucket, load balancer, or custom HTTP server.
 *
 * @experimental
 */
export interface HttpOriginProps extends cloudfront.OriginProps {
    /**
     * (experimental) Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin.
     *
     * @default OriginProtocolPolicy.HTTPS_ONLY
     * @experimental
     */
    readonly protocolPolicy?: cloudfront.OriginProtocolPolicy;
    /**
     * (experimental) The HTTP port that CloudFront uses to connect to the origin.
     *
     * @default 80
     * @experimental
     */
    readonly httpPort?: number;
    /**
     * (experimental) The HTTPS port that CloudFront uses to connect to the origin.
     *
     * @default 443
     * @experimental
     */
    readonly httpsPort?: number;
    /**
     * (experimental) Specifies how long, in seconds, CloudFront waits for a response from the origin, also known as the origin response timeout.
     *
     * The valid range is from 1 to 60 seconds, inclusive.
     *
     * @default Duration.seconds(30)
     * @experimental
     */
    readonly readTimeout?: cdk.Duration;
    /**
     * (experimental) Specifies how long, in seconds, CloudFront persists its connection to the origin.
     *
     * The valid range is from 1 to 60 seconds, inclusive.
     *
     * @default Duration.seconds(5)
     * @experimental
     */
    readonly keepaliveTimeout?: cdk.Duration;
}
/**
 * (experimental) An Origin for an HTTP server or S3 bucket configured for website hosting.
 *
 * @experimental
 */
export declare class HttpOrigin extends cloudfront.OriginBase {
    private readonly props;
    /**
     * @experimental
     */
    constructor(domainName: string, props?: HttpOriginProps);
    /**
     * @experimental
     */
    protected renderCustomOriginConfig(): cloudfront.CfnDistribution.CustomOriginConfigProperty | undefined;
}
