from random import randint, choice
from linecache import getline


def random_ints(length, minimum=0, maximum=100):
    return list([randint(minimum, maximum) for _ in range(length)])


def random_line(file_name, separator = None, number_of_lines = 0):
    if not number_of_lines:
        number_of_lines = sum(1 for i in open(file_name, 'rb'))

    random_line_number = randint(0, number_of_lines)

    line = getline(file_name, random_line_number).strip()

    return line.split(separator) if separator else line


def random_city():
    city = choice(CITIES)[0]
    return city


def random_city_w_country():
    city, country = choice(CITIES)[0]
    return city, country


def random_country():
    country = choice(COUNTRIES)[0]
    return country


def random_country_abbr():
    abbr = choice(COUNTRIES)[1]
    return abbr


def random_country_w_abbr():
    country, abbr = choice(COUNTRIES)
    return country, abbr


def random_emoji():
    emoji = choice(EMOJIS)[0]
    return emoji


def random_emoji_w_desc():
    emoji, desc = choice(EMOJIS)
    return emoji, desc



CITIES = [("Tokyo","Japan"),("Jakarta","Indonesia"),("Delhi","India"),("Mumbai","India"),("Manila","Philippines"),("Shanghai","China"),("Sao Paulo","Brazil"),("Seoul","South Korea"),("Mexico City","Mexico"),("Guangzhou","China"),("Beijing","China"),("Cairo","Egypt"),("New York","United States"),("Kolkata","India"),("Moscow","Russia"),("Bangkok","Thailand"),("Buenos Aires","Argentina"),("Shenzhen","China"),("Dhaka","Bangladesh"),("Lagos","Nigeria"),("Istanbul","Turkey"),("Osaka","Japan"),("Karachi","Pakistan"),("Bangalore","India"),("Tehran","Iran"),("Kinshasa","Congo"),("Ho Chi Minh City","Vietnam"),("Los Angeles","United States"),("Rio de Janeiro","Brazil"),("Nanyang","China"),("Chennai","India"),("Chengdu","China"),("Lahore","Pakistan"),("Paris","France"),("London","United Kingdom"),("Linyi","China"),("Tianjin","China"),("Shijiazhuang","China"),("Baoding","China"),("Zhoukou","China"),("Lima","Peru"),("Hyderabad","India"),("Bogota","Colombia"),("Weifang","China"),("Nagoya","Japan"),("Wuhan","China"),("Heze","China"),("Ganzhou","China"),("Tongshan","China"),("Chicago","United States"),("Handan","China"),("Luanda","Angola"),("Fuyang","China"),("Kuala Lumpur","Malaysia"),("Jining","China"),("Dongguan","China"),("Hanoi","Vietnam"),("Pune","India"),("Chongqing","China"),("Changchun","China"),("Zhumadian","China"),("Ningbo","China"),("Onitsha","Nigeria"),("Nanjing","China"),("Hefei","China"),("Ahmadabad","India"),("Hong Kong","Hong Kong"),("Khartoum","Sudan"),("Nantong","China"),("Yancheng","China"),("Foshan","China"),("Nanning","China"),("Hengyang","China"),("Xi'an","China"),("Shenyang","China"),("Tangshan","China"),("Shaoyang","China"),("Changsha","China"),("Santiago","Chile"),("Zhengzhou","China"),("Zhanjiang","China"),("Riyadh","Saudi Arabia"),("Cangzhou","China"),("Dar es Salaam","Tanzania"),("Maoming","China"),("Huanggang","China"),("Xinyang","China"),("Shangrao","China"),("Luoyang","China"),("Bijie","China"),("Yantai","China"),("Quanzhou","China"),("Hangzhou","China"),("Miami","United States"),("Kunming","China"),("Nanchong","China"),("Zunyi","China"),("Lu'an","China"),("Yichun","China"),("Taizhou","China"),("Liaocheng","China"),("Qujing","China"),("Xiangyang","China"),("Surat","India"),("Baghdad","Iraq"),("Qingdao","China"),("Singapore","Singapore"),("Dallas","United States"),("Changde","China"),("Dazhou","China"),("Suzhou","China"),("Philadelphia","United States"),("Jieyang","China"),("Nairobi","Kenya"),("Nangandao","China"),("Ankara","Turkey"),("Tai'an","China"),("Yulin","China"),("Dezhou","China"),("Houston","United States"),("Atlanta","United States"),("Rangoon","Burma"),("Toronto","Canada"),("Suihua","China"),("Washington","United States"),("Qiqihar","China"),("Jinhua","China"),("Saint Petersburg","Russia"),("Shantou","China"),("Sydney","Australia"),("Weinan","China"),("Suqian","China"),("Guadalajara","Mexico"),("Suzhou","China"),("Fuzhou","China"),("Zhaotong","China"),("Pudong","China"),("Yongzhou","China"),("Belo Horizonte","Brazil"),("Zhangzhou","China"),("Bozhou","China"),("Melbourne","Australia"),("Nanchang","China"),("Xianyang","China"),("Taizhou","China"),("Surabaya","Indonesia"),("Abidjan","Côte D’Ivoire"),("Ji'an","China"),("Mianyang","China"),("Shaoxing","China"),("Alexandria","Egypt"),("Yuncheng","China"),("Pingdingshan","China"),("Huai'an","China"),("Xinpu","China"),("Guilin","China"),("Huaihua","China"),("Jiujiang","China"),("Anqing","China"),("Boston","United States"),("Huanglongsi","China"),("Xiaoganzhan","China"),("Changzhou","China"),("Barcelona","Spain"),("Chenzhou","China"),("Wuxi","China"),("Zibo","China"),("Jiaxing","China"),("Dalian","China"),("Harbin","China"),("Yangzhou","China"),("Yibin","China"),("Jiangmen","China"),("Johannesburg","South Africa"),("Meizhou","China"),("Chifeng","China"),("Casablanca","Morocco"),("Guiyang","China"),("Langfang","China"),("Zhangjiakou","China"),("Izmir","Turkey"),("Linfen","China"),("Wenzhou","China"),("Monterrey","Mexico"),("Luzhou","China"),("Jiangguanchi","China"),("Neijiang","China"),("Phoenix","United States"),("Yanjiang","China"),("Yiyang","China"),("Zhaoqing","China"),("Hengshui","China"),("Guigang","China"),("Xiaoxita","China"),("Xiamen","China"),("Chuzhou","China"),("Fuzhou","China"),("Amman","Jordan"),("Jeddah","Saudi Arabia"),("Sialkot City","Pakistan"),("Huizhou","China"),("Qingyuan","China"),("Zhuzhou","China"),("Wuhu","China"),("Hechi","China"),("Seattle","United States"),("Loudi","China"),("Binzhou","China"),("Liuzhou","China"),("Yokohama","Japan"),("Baojishi","China"),("Guang'an","China"),("Hanzhong","China"),("Kabul","Afghanistan"),("Zaozhuang","China"),("Berlin","Germany"),("Anshan","China"),("Deyang","China"),("Lanzhou","China"),("Chengde","China"),("San Francisco","United States"),("Puyang","China"),("Suining","China"),("Jiaozuo","China"),("Bengbu","China"),("Montreal","Canada"),("Detroit","United States"),("Baicheng","China"),("Busan","South Korea"),("Algiers","Algeria"),("Qincheng","China"),("Taiyuan","China"),("Lucknow","India"),("Chaoyang","China"),("Hechi","China"),("Leshan","China"),("Yulinshi","China"),("Siping","China"),("Madrid","Spain"),("Jinan","China"),("Shiyan","China"),("Changzhi","China"),("San Diego","United States"),("Faisalabad","Pakistan"),("Santa Cruz","Bolivia"),("Bazhou","China"),("Zhongshan","China"),("Zhenjiang","China"),("Urumqi","China"),("Tongliao","China"),("Heyuan","China"),("Tongren","China"),("Qinzhou","China"),("Jaipur","India"),("Xinzhou","China"),("Addis Ababa","Ethiopia"),("Giza","Egypt"),("Meishan","China"),("Brasilia","Brazil"),("Mashhad","Iran"),("Jinzhou","China"),("Tieling","China"),("Shaoguan","China"),("Shanwei","China"),("Minneapolis","United States"),("Kyiv","Ukraine"),("Sanaa","Yemen"),("Quezon City","Philippines"),("Dingxi","China"),("Salvador","Brazil"),("Incheon","South Korea"),("Bursa","Turkey"),("Ningde","China"),("Tampa","United States"),("Daqing","China"),("Birmingham","United Kingdom"),("Putian","China"),("Huzhou","China"),("Wuzhou","China"),("Denver","United States"),("Rome","Italy"),("La Paz","Bolivia"),("Pyongyang","North Korea"),("Kano","Nigeria"),("Taichung","Taiwan"),("Omdurman","Sudan"),("Zigong","China"),("Qinhuangdao","China"),("Mudanjiang","China"),("Huludao","China"),("Kaohsiung","Taiwan"),("Xiangtan","China"),("Guayaquil","Ecuador"),("Rizhao","China"),("Manchester","United Kingdom"),("Cawnpore","India"),("Baotou","China"),("Taipei","Taiwan"),("Nanping","China"),("Longyan","China"),("Ibadan","Nigeria"),("Hohhot","China"),("Chaozhou","China"),("Antananarivo","Madagascar"),("Longba","China"),("Weihai","China"),("Chattogram","Bangladesh"),("Santo Domingo","Dominican Republic"),("Xuanzhou","China"),("Sanming","China"),("Brooklyn","United States"),("Medellin","Colombia"),("Brisbane","Australia"),("Baoshan","China"),("Dubai","United Arab Emirates"),("Luohe","China"),("Qinbaling","China"),("Mirzapur","India"),("Guangyuan","China"),("Cali","Colombia"),("Daegu","South Korea"),("Fortaleza","Brazil"),("Guatemala City","Guatemala"),("Yaounde","Cameroon"),("Douala","Cameroon"),("Jilin","China"),("Lianshan","China"),("Lincang","China"),("Antalya","Turkey"),("Tashkent","Uzbekistan"),("Huangshi","China"),("Bandung","Indonesia"),("Nagpur","India"),("Dandong","China"),("Huainan","China"),("Shangzhou","China"),("Bekasi","Indonesia"),("Ghaziabad","India"),("Tijuana","Mexico"),("Jiamusi","China"),("Yangjiang","China"),("Accra","Ghana"),("Yuxi","China"),("Fushun","China"),("Anshun","China"),("Vancouver","Canada"),("Tangerang","Indonesia"),("Konya","Turkey"),("Queens","United States"),("Yingkou","China"),("Adana","Turkey"),("Medan","Indonesia"),("Sanmenxia","China"),("Indore","India"),("Ma'anshan","China"),("Pingliang","China"),("Quzhou","China"),("Baku","Azerbaijan"),("Gaoping","China"),("Huaibei","China"),("Xining","China"),("Yan'an","China"),("Havana","Cuba"),("Phnom Penh","Cambodia"),("Fukuoka","Japan"),("Mogadishu","Somalia"),("Jincheng","China"),("Lishui","China"),("Qingyang","China"),("Riverside","United States"),("Baltimore","United States"),("Haiphong","Vietnam"),("Las Vegas","United States"),("Laibin","China"),("Rawalpindi","Pakistan"),("Kumasi","Ghana"),("Portland","United States"),("Vadodara","India"),("Perth","Australia"),("Puning","China"),("San Antonio","United States"),("Haikou","China"),("Vishakhapatnam","India"),("Gaziantep","Turkey"),("Minsk","Belarus"),("St. Louis","United States"),("Bamako","Mali"),("Quito","Ecuador"),("Pingxiang","China"),("Chongzuo","China"),("Sanliurfa","Turkey"),("Kananga","Congo"),("Peshawar","Pakistan"),("Sapporo","Japan"),("Jixi","China"),("Caracas","Venezuela"),("Fuxin","China"),("Leeds","United Kingdom"),("Sacramento","United States"),("Blantyre","Malawi"),("Tainan","Taiwan"),("Bucharest","Romania"),("Wuwei","China"),("Bhopal","India"),("Curitiba","Brazil"),("Xiping","China"),("Asuncion","Paraguay"),("Saidu Sharif","Pakistan"),("Vienna","Austria"),("Aleppo","Syria"),("Hamburg","Germany"),("Meru","Kenya"),("Brazzaville","Congo"),("Orlando","United States"),("Mersin","Turkey"),("Almaty","Kazakhstan"),("Barranquilla","Colombia"),("Kyoto","Japan"),("Manaus","Brazil"),("Liaoyang","China"),("Baiyin","China"),("San Jose","United States"),("Warsaw","Poland"),("Shengli","China"),("Lubumbashi","Congo"),("Damascus","Syria"),("Shuyangzha","China"),("Shangqiu","China"),("Esfahan","Iran"),("Budapest","Hungary"),("Heihe","China"),("Lusaka","Zambia"),("Diyarbakir","Turkey"),("Chinchvad","India"),("Shuozhou","China"),("Vitoria","Brazil"),("Cleveland","United States"),("Pittsburgh","United States"),("Mecca","Saudi Arabia"),("Patna","India"),("Mosul","Iraq"),("Austin","United States"),("Sanzhou","China"),("Conakry","Guinea"),("Kampala","Uganda"),("Ecatepec","Mexico"),("Cincinnati","United States"),("Makassar","Indonesia"),("Yushan","China"),("Ludhiana","India"),("Newcastle","United Kingdom"),("Depok","Indonesia"),("Zhongli","Taiwan"),("Kansas City","United States"),("Rabat","Morocco"),("Ouagadougou","Burkina Faso"),("Davao","Philippines"),("Manhattan","United States"),("Semarang","Indonesia"),("Yinchuan","China"),("Multan","Pakistan"),("Caloocan City","Philippines"),("Harare","Zimbabwe"),("Novosibirsk","Russia"),("Chengtangcun","China"),("Agra","India"),("Karaj","Iran"),("Indianapolis","United States"),("Jingdezhen","China"),("Puebla","Mexico"),("Kalyan","India"),("Madurai","India"),("Gujranwala","Pakistan"),("Benxi","China"),("Jamshedpur","India"),("Zhuhai","China"),("Recife","Brazil"),("Columbus","United States"),("Tabriz","Iran"),("Santiago","Dominican Republic"),("Maracaibo","Venezuela"),("Beihai","China"),("Shuangyashan","China"),("Kobe","Japan"),("Charlotte","United States"),("Yucheng","China"),("Changshu","China"),("Ximeicun","China"),("Jianguang","China"),("Gwangju","South Korea"),("Xushan","China"),("Guiping","China"),("Nasik","India"),("Porto Alegre","Brazil"),("Zhangjiajie","China"),("Valencia","Venezuela"),("Virginia Beach","United States"),("Daejeon","South Korea"),("Munich","Germany"),("Yekaterinburg","Russia"),("Auckland","New Zealand"),("Yunfu","China"),("Huangshan","China"),("Huazhou","China"),("Shiraz","Iran"),("Leon de los Aldama","Mexico"),("Pizhou","China"),("Palembang","Indonesia"),("Kharkiv","Ukraine"),("Kawanakajima","Japan"),("Lianjiang","China"),("Chizhou","China"),("Leizhou","China"),("Guyuan","China"),("Rui'an","China"),("Birstall","United Kingdom"),("Muscat","Oman"),("Hebi","China"),("Jingling","China"),("Bronx","United States"),("The Hague","Netherlands"),("Owerri","Nigeria"),("Sharjah","United Arab Emirates"),("Faridabad","India"),("Ulaanbaatar","Mongolia"),("Goiania","Brazil"),("Belem","Brazil"),("Kayseri","Turkey"),("Yueqing","China"),("Belgrade","Serbia"),("Pingdu","China"),("Aurangabad","India"),("Yutan","China"),("Wenling","China"),("Islamabad","Pakistan"),("Milwaukee","United States"),("Milan","Italy"),("Sofia","Bulgaria"),("Adelaide","Australia"),("Samsun","Turkey"),("Rajkot","India"),("Khulna","Bangladesh"),("Cordoba","Argentina"),("Guarulhos","Brazil"),("Juarez","Mexico"),("Prague","Czechia"),("Montevideo","Uruguay"),("Mbuji-Mayi","Congo"),("Fuqing","China"),("Xintai","China"),("Doha","Qatar"),("Saitama","Japan"),("Hiroshima","Japan"),("Meerut","India"),("Yushu","China"),("Rongcheng","China"),("Yangquan","China"),("Haicheng","China"),("Gaozhou","China"),("Yingtan","China"),("Huaiyin","China"),("Wuzhong","China"),("Jabalpur","India"),("Thane","India"),("Zhangye","China"),("Rucheng","China"),("Nizhniy Novgorod","Russia"),("Comayaguela","Honduras"),("Yangshe","China"),("Shaoyang","China"),("Dhanbad","India"),("Yichun","China"),("Laiwu","China"),("Kazan","Russia"),("Dayan","China"),("Suwon","South Korea"),("Jiangyin","China"),("Yongcheng","China"),("Calgary","Canada"),("Can Tho","Vietnam"),("Abuja","Nigeria"),("Yiwu","China"),("Mandalay","Burma"),("Beidao","China"),("Al Basrah","Iraq"),("Shuangshui","China"),("Sevilla","Spain"),("Vila Velha","Brazil"),("Allahabad","India"),("Varanasi","India"),("Tunis","Tunisia"),("Chelyabinsk","Russia"),("Mombasa","Kenya"),("Providence","United States"),("Qom","Iran"),("Maiduguri","Nigeria"),("Maputo","Mozambique"),("Rosario","Argentina"),("Benin City","Nigeria"),("Xinyu","China"),("Ahvaz","Iran"),("Dublin","Ireland"),("Jacksonville","United States"),("Medina","Saudi Arabia"),("Srinagar","India"),("Omsk","Russia"),("Huazhou","China"),("Cilacap","Indonesia"),("Xiantao","China"),("Bandar Lampung","Indonesia"),("Samara","Russia"),("Guankou","China"),("Ulsan","South Korea"),("Dingzhou","China"),("Campinas","Brazil"),("Lianyuan","China"),("Rongcheng","China"),("Kaiyuan","China"),("Nay Pyi Taw","Burma"),("Dakar","Senegal"),("Zhuji","China"),("Zapopan","Mexico"),("Leiyang","China"),("Dadukou","China"),("Quetta","Pakistan"),("Amritsar","India"),("Callao","Peru"),("Aligarh","India"),("Yingchuan","China"),("Tegucigalpa","Honduras"),("Ciudad Nezahualcoyotl","Mexico"),("Tripoli","Libya"),("Rostov","Russia"),("Nezahualcoyotl","Mexico"),("Bhiwandi","India"),("Zhoushan","China"),("Tbilisi","Georgia"),("Ufa","Russia"),("Fes","Morocco"),("Bien Hoa","Vietnam"),("Mexicali","Mexico"),("Gwalior","India"),("Ankang","China"),("Ikare","Nigeria"),("Hegang","China"),("Salt Lake City","United States"),("Bhilai","India"),("Yuyao","China"),("N'Djamena","Chad"),("Hanchuan","China"),("Gongzhuling","China"),("Copenhagen","Denmark"),("Irbid","Jordan"),("Haora","India"),("Cologne","Germany"),("Krasnoyarsk","Russia"),("Yicheng","China"),("Mizhou","China"),("Nashville","United States"),("Yerevan","Armenia"),("Ranchi","India"),("Nur-Sultan","Kazakhstan"),("Nouakchott","Mauritania"),("Vereeniging","South Africa"),("Richmond","United States"),("Sao Luis","Brazil"),("San Pedro Sula","Honduras"),("Taixing","China"),("Memphis","United States"),("Goyang","South Korea"),("Bezwada","India"),("Edmonton","Canada"),("Xishan","China"),("Barquisimeto","Venezuela"),("Sendai","Japan"),("Voronezh","Russia"),("Perm","Russia"),("Changwon","South Korea"),("Zhongwei","China"),("Shouguang","China"),("Bogor","Indonesia"),("Raleigh","United States"),("Cartagena","Colombia"),("Chandigarh","India"),("Bishkek","Kyrgyzstan"),("Amsterdam","Netherlands"),("Matola","Mozambique"),("Ogbomoso","Nigeria"),("Ashgabat","Turkmenistan"),("E'zhou","China"),("Maceio","Brazil"),("Niamey","Niger"),("Managua","Nicaragua"),("Patam","Indonesia"),("Tekirdag","Turkey"),("Linhai","China"),("Shubra al Khaymah","Egypt"),("Monrovia","Liberia"),("Wafangdian","China"),("Zhongxiang","China"),("Shymkent","Kazakhstan"),("New Orleans","United States"),("Volgograd","Russia"),("Port-au-Prince","Haiti"),("Mysore","India"),("Odesa","Ukraine"),("Kathmandu","Nepal"),("Raipur","India"),("Nice","France"),("Arequipa","Peru"),("Port Harcourt","Nigeria"),("Rotterdam","Netherlands"),("Louisville","United States"),("Zaoyang","China"),("Shuizhai","China"),("Kota","India"),("Abu Dhabi","United Arab Emirates"),("Stockholm","Sweden"),("Ottawa","Canada"),("Asmara","Eritrea"),("Freetown","Sierra Leone"),("Jerusalem","Israel"),("Panama City","Panama"),("Lome","Togo"),("Libreville","Gabon"),("Zagreb","Croatia"),("Dushanbe","Tajikistan"),("Lilongwe","Malawi"),("Cotonou","Benin"),("Vientiane","Laos"),("Colombo","Sri Lanka"),("Kigali","Rwanda"),("Pretoria","South Africa"),("Bangui","Central African Republic"),("Winnipeg","Canada"),("Quebec City","Canada"),("Riga","Latvia"),("Oslo","Norway"),("Chisinau","Moldova"),("Athens","Greece"),("Bujumbura","Burundi"),("Helsinki","Finland"),("Skopje","Macedonia"),("Kuwait City","Kuwait"),("Kingston","Jamaica"),("Vilnius","Lithuania"),("San Salvador","El Salvador"),("Djibouti","Djibouti"),("Lisbon","Portugal"),("Kitchener","Canada"),("Tallinn","Estonia"),("Cape Town","South Africa"),("Bratislava","Slovakia"),("Tirana","Albania"),("Canberra","Australia"),("Wellington","New Zealand"),("Beirut","Lebanon"),("Dodoma","Tanzania"),("Halifax","Canada"),("Bissau","Guinea-Bissau"),("Juba","South Sudan"),("Port Moresby","Papua New Guinea"),("Yamoussoukro","Côte D’Ivoire"),("Victoria","Canada"),("Maseru","Lesotho"),("Nicosia","Cyprus"),("Windhoek","Namibia"),("Porto-Novo","Benin"),("Sucre","Bolivia"),("San Jose","Costa Rica"),("Ljubljana","Slovenia"),("Sarajevo","Bosnia And Herzegovina"),("Nassau","The Bahamas"),("Bloemfontein","South Africa"),("Gaborone","Botswana"),("Paramaribo","Suriname"),("Dili","Timor-Leste"),("Pristina","Kosovo"),("Georgetown","Guyana"),("Malabo","Equatorial Guinea"),("Brussels","Belgium"),("Male","Maldives"),("Podgorica","Montenegro"),("Manama","Bahrain"),("Port Louis","Mauritius"),("New Delhi","India"),("Bern","Switzerland"),("Reykjavik","Iceland"),("Praia","Cabo Verde"),("Luxembourg","Luxembourg"),("Sri Jayewardenepura Kotte","Sri Lanka"),("Bridgetown","Barbados"),("Moroni","Comoros"),("Thimphu","Bhutan"),("Mbabane","Swaziland"),("Honiara","Solomon Islands"),("Suva","Fiji"),("Castries","Saint Lucia"),("Sao Tome","Sao Tome And Principe"),("Port-Vila","Vanuatu"),("Bandar Seri Begawan","Brunei"),("Monaco","Monaco"),("Gitega","Burundi"),("Port of Spain","Trinidad And Tobago"),("Apia","Samoa"),("Vaduz","Liechtenstein"),("Banjul","The Gambia"),("Tarawa","Kiribati"),("Victoria","Seychelles"),("Majuro","Marshall Islands"),("Kingstown","Saint Vincent And The Grenadines"),("Nuku`alofa","Tonga"),("Saint John's","Antigua And Barbuda"),("Andorra la Vella","Andorra"),("Belmopan","Belize"),("Roseau","Dominica"),("Basseterre","Saint Kitts And Nevis"),("Pago Pago","American Samoa"),("Valletta","Malta"),("Palikir","Federated States Of Micronesia"),("Funafuti","Tuvalu"),("Lobamba","Swaziland"),("Saint George's","Grenada"),("San Marino","San Marino"),("Al Quds","West Bank"),("Hagta","Guam"),("Ngerulmud","Palau"),("Bareilly","India"),("Quang Ha","Vietnam"),("Kitaku","Japan"),("Jodhpur","India"),("Xingcheng","China"),("Dongtai","China"),("Joinvile","Brazil"),("Yingcheng","China"),("Dnipro","Ukraine"),("Glasgow","United Kingdom"),("Chiba","Japan"),("Danyang","China"),("Natal","Brazil"),("Naples","Italy"),("Zhaodong","China"),("Xibeijie","China"),("Kirkuk","Iraq"),("Huilong","China"),("Tongjin","South Korea"),("Oklahoma City","United States"),("Toulouse","France"),("Denizli","Turkey"),("Dispur","India"),("Coimbatore","India"),("Luocheng","China"),("Guwahati","India"),("Shima","China"),("Songnam","South Korea"),("Solapur","India"),("Tangier","Morocco"),("Anqiu","China"),("Feicheng","China"),("Taishan","China"),("Meishan","China"),("Kisangani","Congo"),("Khartoum North","Sudan"),("Aguascalientes","Mexico"),("Marrakech","Morocco"),("Nada","China"),("Donetsk","Ukraine"),("Taihecun","China"),("Wuchuan","China"),("Trujillo","Peru"),("Cebu City","Philippines"),("Taihe","China"),("Olinda","Brazil"),("Bridgeport","United States"),("Trichinopoly","India"),("Xin'an","China"),("Padang","Indonesia"),("Qingzhou","China"),("Buffalo","United States"),("Xinyi","China"),("Lichuan","China"),("Daye","China"),("Fort Worth","United States"),("Zhuanghe","China"),("Hartford","United States"),("Ad Dammam","Saudi Arabia"),("Bucheon","South Korea"),("Lhasa","China"),("Homs","Syria"),("Jiaozhou","China"),("Merida","Mexico"),("Dengtalu","China"),("Zaria","Nigeria"),("Hubli","India"),("Abeokuta","Nigeria"),("Tucson","United States"),("Krasnodar","Russia"),("Natal","Brazil"),("Novo Hamburgo","Brazil"),("Chihuahua","Mexico"),("Klang","Malaysia"),("Turin","Italy"),("Jos","Nigeria"),("Laiyang","China"),("Jalandhar","India"),("Campo Grande","Brazil"),("Sale","Morocco"),("Barinas","Venezuela"),("Marseille","France"),("Kaifeng Chengguanzhen","China"),("Eskisehir","Turkey"),("Gaomi","China"),("Ipoh","Malaysia"),("Hai'an","China"),("Liverpool","United Kingdom"),("Zamboanga City","Philippines"),("Oran","Algeria"),("Southampton","United Kingdom"),("Weichanglu","China"),("Pekanbaru","Indonesia"),("Portsmouth","United Kingdom"),("Leping","China"),("Erbil","Iraq"),("Kermanshah","Iran"),("Hailun","China"),("Yangchun","China"),("Macheng","China"),("Ilorin","Nigeria"),("Teresina","Brazil"),("Omaha","United States"),("Yuci","China"),("Saratov","Russia"),("Iguacu","Brazil"),("El Paso","United States"),("Denpasar","Indonesia"),("Dehui","China"),("Naucalpan de Juarez","Mexico"),("Bhubaneshwar","India"),("Tongchuan","China"),("Cheongju","South Korea"),("Warri","Nigeria"),("Pointe-Noire","Congo"),("Rongjiawan","China"),("San Luis Potosi","Mexico"),("Butterworth","Malaysia"),("Bhayandar","India"),("Renqiu","China"),("Toluca","Mexico"),("Honolulu","United States"),("Queretaro","Mexico"),("Xindi","China"),("Wu'an","China"),("Sao Bernardo do Campo","Brazil"),("Hermosillo","Mexico"),("Wutong","China"),("Taguig City","Philippines"),("Saltillo","Mexico"),("Gaoyou","China"),("Hejian","China"),("Yiyang","China"),("Puxi","China"),("Zijinglu","China"),("Xiashi","China"),("Trabzon","Turkey"),("Joao Pessoa","Brazil"),("Dongyang","China"),("McAllen","United States"),("Valencia","Spain"),("Qingping","China"),("Niigata","Japan"),("Hamamatsu","Japan"),("Morelia","Mexico"),("Pasig City","Philippines"),("Moradabad","India"),("Culiacan","Mexico"),("Xiangxiang","China"),("Malang","Indonesia"),("Xingyi","China"),("Chaohucun","China"),("Fuyang","China"),("Antipolo","Philippines"),("Nottingham","United Kingdom"),("Cencheng","China"),("Krakow","Poland"),("Hempstead","United States"),("Erzurum","Turkey"),("Al `Ayn","United Arab Emirates"),("Songzi","China"),("Laixi","China"),("Zhongba","China"),("Qingnian","China"),("Albuquerque","United States"),("Kaduna","Nigeria"),("Tlalnepantla","Mexico"),("Xinhualu","China"),("Guangshui","China"),("Frankfurt","Germany"),("Samarinda","Indonesia"),("Changhua","Taiwan"),("Pietermaritzburg","South Africa"),("Hungnam","North Korea"),("Kolhapur","India"),("Ciudad Guayana","Venezuela"),("Cucuta","Colombia"),("Licheng","China"),("Thiruvananthapuram","India"),("Tyumen","Russia"),("San Cristobal","Venezuela"),("Zaporizhzhia","Ukraine"),("Cancun","Mexico"),("Kumamoto","Japan"),("Chengguan","China"),("Nehe","China"),("Sokoto","Nigeria"),("Birmingham","United States"),("Zunhua","China"),("Orumiyeh","Iran"),("Oyo","Nigeria"),("Wugang","China"),("Shuangqiao","China"),("Rennes","France"),("Sizhan","China"),("Langzhong","China"),("Bristol","United Kingdom"),("Qian'an","China"),("Lviv","Ukraine"),("Zouping","China"),("Bremen","Germany"),("Reynosa","Mexico"),("An Najaf","Iraq"),("Sagamihara","Japan"),("Guli","China"),("Sarasota","United States"),("Okayama","Japan"),("Mississauga","Canada"),("Lingbao Chengguanzhen","China"),("Anlu","China"),("Wusong","China"),("Dayton","United States"),("Enugu","Nigeria"),("George Town","Malaysia"),("Jaboatao","Brazil"),("Santo Andre","Brazil"),("Xichang","China"),("Soledad","Colombia"),("Chengxiang","China"),("Tolyatti","Russia"),("Saharanpur","India"),("Warangal","India"),("Osasco","Brazil"),("Dashiqiao","China"),("Latakia","Syria"),("Rochester","United States"),("Fresno","United States"),("Banjarmasin","Indonesia"),("Salem","India"),("Changsha","China"),("Grenoble","France"),("Shishi","China"),("Guadalupe","Mexico"),("Aracaju","Brazil"),("Bauchi","Nigeria"),("Hamilton","Canada"),("Lodz","Poland"),("Miluo Chengguanzhen","China"),("Gaizhou","China"),("Shizuoka","Japan"),("Malegaon","India"),("Karbala'","Iraq"),("Leling","China"),("Sao Jose dos Campos","Brazil"),("Jianshe","China"),("Acapulco de Juarez","Mexico"),("Sheffield","United Kingdom"),("Jingcheng","China"),("City of Paranaque","Philippines"),("Kochi","India"),("Allentown","United States"),("Bahawalpur","Pakistan"),("Tasikmalaya","Indonesia"),("Macau","Macau"),("Torreon","Mexico"),("Xinmin","China"),("Shanhu","China"),("Zhongshu","China"),("Xigaze","China"),("Gold Coast","Australia"),("Palermo","Italy"),("Cagayan de Oro","Philippines"),("Gorakhpur","India"),("Pinghu","China"),("Guankou","China"),("Tulsa","United States"),("Yatou","China"),("Songyang","China"),("Cape Coral","United States"),("Qionghu","China"),("Ribeirao Preto","Brazil"),("Dasmarinas","Philippines")]

COUNTRIES = [('Afghanistan','Afghanistan'),('Aland Islands','Aland Islands'),('Albania','Albania'),('Algeria','Algeria'),('American Samoa','American Samoa'),('Andorra','Andorra'),('Angola','Angola'),('Anguilla','Anguilla'),('Antarctica','Antarctica'),('Antigua And Barbuda','Antigua And Barbuda'),('Argentina','Argentina'),('Armenia','Armenia'),('Aruba','Aruba'),('Australia','Australia'),('Austria','Austria'),('Azerbaijan','Azerbaijan'),('Bahamas','Bahamas'),('Bahrain','Bahrain'),('Bangladesh','Bangladesh'),('Barbados','Barbados'),('Belarus','Belarus'),('Belgium','Belgium'),('Belize','Belize'),('Benin','Benin'),('Bermuda','Bermuda'),('Bhutan','Bhutan'),('Bolivia','Bolivia'),('Bosnia And Herzegovina','Bosnia And Herzegovina'),('Botswana','Botswana'),('Bouvet Island','Bouvet Island'),('Brazil','Brazil'),('British Indian Ocean Territory','British Indian Ocean Territory'),('Brunei Darussalam','Brunei Darussalam'),('Bulgaria','Bulgaria'),('Burkina Faso','Burkina Faso'),('Burundi','Burundi'),('Cambodia','Cambodia'),('Cameroon','Cameroon'),('Canada','Canada'),('Cape Verde','Cape Verde'),('Cayman Islands','Cayman Islands'),('Central African Republic','Central African Republic'),('Chad','Chad'),('Chile','Chile'),('China','China'),('Christmas Island','Christmas Island'),('Cocos (Keeling) Islands','Cocos (Keeling) Islands'),('Colombia','Colombia'),('Comoros','Comoros'),('Republic of Congo','Republic of Congo'),('Democratic Republic of Congo','Democratic Republic of Congo'),('Cook Islands','Cook Islands'),('Costa Rica','Costa Rica'),('Côte d’Ivoire','Côte d’Ivoire'),('Croatia','Croatia'),('Cuba','Cuba'),('Cyprus','Cyprus'),('Czech Republic','Czech Republic'),('Denmark','Denmark'),('Djibouti','Djibouti'),('Dominica','Dominica'),('Dominican Republic','Dominican Republic'),('Ecuador','Ecuador'),('Egypt','Egypt'),('El Salvador','El Salvador'),('Equatorial Guinea','Equatorial Guinea'),('Eritrea','Eritrea'),('Estonia','Estonia'),('Ethiopia','Ethiopia'),('Falkland Islands (Malvinas)','Falkland Islands (Malvinas)'),('Faroe Islands','Faroe Islands'),('Fiji','Fiji'),('Finland','Finland'),('France','France'),('French Guiana','French Guiana'),('French Polynesia','French Polynesia'),('French Southern Territories','French Southern Territories'),('Gabon','Gabon'),('Gambia','Gambia'),('Georgia','Georgia'),('Germany','Germany'),('Ghana','Ghana'),('Gibraltar','Gibraltar'),('Greece','Greece'),('Greenland','Greenland'),('Grenada','Grenada'),('Guadeloupe','Guadeloupe'),('Guam','Guam'),('Guatemala','Guatemala'),('Guernsey','Guernsey'),('Guinea','Guinea'),('Guinea-Bissau','Guinea-Bissau'),('Guyana','Guyana'),('Haiti','Haiti'),('Heard Island & Mcdonald Islands','Heard Island & Mcdonald Islands'),('Holy See (Vatican City State)','Holy See (Vatican City State)'),('Honduras','Honduras'),('Hong Kong','Hong Kong'),('Hungary','Hungary'),('Iceland','Iceland'),('India','India'),('Indonesia','Indonesia'),('Iran','Iran'),('Iraq','Iraq'),('Ireland','Ireland'),('Isle Of Man','Isle Of Man'),('Israel','Israel'),('Italy','Italy'),('Jamaica','Jamaica'),('Japan','Japan'),('Jersey','Jersey'),('Jordan','Jordan'),('Kazakhstan','Kazakhstan'),('Kenya','Kenya'),('Kiribati','Kiribati'),('Republic of Korea','Republic of Korea'),('Kuwait','Kuwait'),('Kyrgyzstan','Kyrgyzstan'),('Lao PDR','Lao PDR'),('Latvia','Latvia'),('Lebanon','Lebanon'),('Lesotho','Lesotho'),('Liberia','Liberia'),('Libya','Libya'),('Liechtenstein','Liechtenstein'),('Lithuania','Lithuania'),('Luxembourg','Luxembourg'),('Macao','Macao'),('Macedonia','Macedonia'),('Madagascar','Madagascar'),('Malawi','Malawi'),('Malaysia','Malaysia'),('Maldives','Maldives'),('Mali','Mali'),('Malta','Malta'),('Marshall Islands','Marshall Islands'),('Martinique','Martinique'),('Mauritania','Mauritania'),('Mauritius','Mauritius'),('Mayotte','Mayotte'),('Mexico','Mexico'),('Micronesi','Micronesi'),('Moldova','Moldova'),('Monaco','Monaco'),('Mongolia','Mongolia'),('Montenegro','Montenegro'),('Montserrat','Montserrat'),('Morocco','Morocco'),('Mozambique','Mozambique'),('Myanmar','Myanmar'),('Namibia','Namibia'),('Nauru','Nauru'),('Nepal','Nepal'),('Netherlands','Netherlands'),('Netherlands Antilles','Netherlands Antilles'),('New Caledonia','New Caledonia'),('New Zealand','New Zealand'),('Nicaragua','Nicaragua'),('Niger','Niger'),('Nigeria','Nigeria'),('Niue','Niue'),('Norfolk Island','Norfolk Island'),('Northern Mariana Islands','Northern Mariana Islands'),('Norway','Norway'),('Oman','Oman'),('Pakistan','Pakistan'),('Palau','Palau'),('Palestine','Palestine'),('Panama','Panama'),('Papua New Guinea','Papua New Guinea'),('Paraguay','Paraguay'),('Peru','Peru'),('Philippines','Philippines'),('Pitcairn','Pitcairn'),('Poland','Poland'),('Portugal','Portugal'),('Puerto Rico','Puerto Rico'),('Qatar','Qatar'),('Reunion','Reunion'),('Romania','Romania'),('Russian Federation','Russian Federation'),('Rwanda','Rwanda'),('Saint Barthelemy','Saint Barthelemy'),('Saint Helena','Saint Helena'),('Saint Kitts And Nevis','Saint Kitts And Nevis'),('Saint Lucia','Saint Lucia'),('Saint Martin','Saint Martin'),('Saint Pierre And Miquelon','Saint Pierre And Miquelon'),('Saint Vincent and Grenadines','Saint Vincent and Grenadines'),('Samoa','Samoa'),('San Marino','San Marino'),('Sao Tomé and Principe','Sao Tomé and Principe'),('Saudi Arabia','Saudi Arabia'),('Senegal','Senegal'),('Serbia','Serbia'),('Seychelles','Seychelles'),('Sierra Leone','Sierra Leone'),('Singapore','Singapore'),('Slovakia','Slovakia'),('Slovenia','Slovenia'),('Solomon Islands','Solomon Islands'),('Somalia','Somalia'),('South Africa','South Africa'),('South Georgia And Sandwich Isl.','South Georgia And Sandwich Isl.'),('Spain','Spain'),('Sri Lanka','Sri Lanka'),('Sudan','Sudan'),('Suriname','Suriname'),('Svalbard And Jan Mayen','Svalbard And Jan Mayen'),('Swaziland','Swaziland'),('Sweden','Sweden'),('Switzerland','Switzerland'),('Syria','Syria'),('Taiwan','Taiwan'),('Tajikistan','Tajikistan'),('Tanzania','Tanzania'),('Thailand','Thailand'),('Timor-Leste','Timor-Leste'),('Togo','Togo'),('Tokelau','Tokelau'),('Tonga','Tonga'),('Trinidad And Tobago','Trinidad And Tobago'),('Tunisia','Tunisia'),('Turkey','Turkey'),('Turkmenistan','Turkmenistan'),('Turks And Caicos Islands','Turks And Caicos Islands'),('Tuvalu','Tuvalu'),('Uganda','Uganda'),('Ukraine','Ukraine'),('United Arab Emirates','United Arab Emirates'),('United Kingdom','United Kingdom'),('United States','United States'),('United States Outlying Islands','United States Outlying Islands'),('Uruguay','Uruguay'),('Uzbekistan','Uzbekistan'),('Vanuatu','Vanuatu'),('Venezuela','Venezuela'),('Viet Nam','Viet Nam'),('Virgin Island','Virgin Island'),('Virgin Island','Virgin Island'),('Wallis And Futuna','Wallis And Futuna'),('Western Sahara','Western Sahara'),('Yemen','Yemen'),('Zambia','Zambia'),('Zimbabwe','Zimbabwe')]

EMOJIS = [('😄', 'smile'),('😆', 'laughing'),('😊', 'blush'),('😃', 'smiley'),('☺', 'relaxed'),('😏', 'smirk'),('😍', 'heart eyes'),('😘', 'kissing heart'),('😚', 'kissing closed eyes'),('😳', 'flushed'),('😥', 'relieved'),('😌', 'satisfied'),('😁', 'grin'),('😉', 'wink'),('😜', 'stuck out tongue winking eye'),('😝', 'stuck out tongue closed eyes'),('😀', 'grinning'),('😗', 'kissing'),('😙', 'kissing smiling eyes'),('😛', 'stuck out tongue'),('😴', 'sleeping'),('😟', 'worried'),('😦', 'frowning'),('😧', 'anguished'),('😮', 'open mouth'),('😬', 'grimacing'),('😕', 'confused'),('😯', 'hushed'),('😑', 'expressionless'),('😒', 'unamused'),('😅', 'sweat smile'),('😓', 'sweat'),('😩', 'weary'),('😔', 'pensive'),('😞', 'disappointed'),('😖', 'confounded'),('😨', 'fearful'),('😰', 'cold sweat'),('😣', 'persevere'),('😢', 'cry'),('😭', 'sob'),('😂', 'joy'),('😲', 'astonished'),('😱', 'scream'),('😫', 'tired face'),('😠', 'angry'),('😡', 'rage'),('😤', 'triumph'),('😪', 'sleepy'),('😋', 'yum'),('😷', 'mask'),('😎', 'sunglasses'),('😵', 'dizzy face'),('👿', 'imp'),('😈', 'smiling imp'),('😐', 'neutral face'),('😶', 'no mouth'),('😇', 'innocent'),('👽', 'alien'),('💛', 'yellow heart'),('💙', 'blue heart'),('💜', 'purple heart'),('❤', 'heart'),('💚', 'green heart'),('💔', 'broken heart'),('💓', 'heartbeat'),('💗', 'heartpulse'),('💕', 'two hearts'),('💞', 'revolving hearts'),('💘', 'cupid'),('💖', 'sparkling heart'),('✨', 'sparkles'),('⭐', 'star'),('🌟', 'star2'),('💫', 'dizzy'),('💥', 'boom'),('💢', 'anger'),('❗', 'exclamation'),('❓', 'question'),('❕', 'grey exclamation'),('❔', 'grey question'),('💤', 'zzz'),('💨', 'dash'),('💦', 'sweat drops'),('🎶', 'notes'),('🎵', 'musical note'),('🔥', 'fire'),('💩', 'poop'),('👍', 'thumbsup'),('👎', 'thumbsdown'),('👌', 'ok hand'),('👊', 'punch'),('✊', 'fist'),('✌', 'v'),('👋', 'wave'),('✋', 'hand'),('👐', 'open hands'),('☝', 'point up'),('👇', 'point down'),('👈', 'point left'),('👉', 'point right'),('🙌', 'raised hands'),('🙏', 'pray'),('👆', 'point up 2'),('👏', 'clap'),('💪', 'muscle'),('🚶', 'walking'),('🏃', 'runner'),('👫', 'couple'),('👪', 'family'),('👬', 'two men holding hands'),('👭', 'two women holding hands'),('💃', 'dancer'),('👯', 'dancers'),('🙆', 'ok woman'),('🙅', 'no good'),('💁', 'information desk person'),('🙋', 'raised hand'),('👰', 'bride with veil'),('🙎', 'person with pouting face'),('🙍', 'person frowning'),('🙇', 'bow'),('💏', 'couplekiss'),('💑', 'couple with heart'),('💆', 'massage'),('💇', 'haircut'),('💅', 'nail care'),('👦', 'boy'),('👧', 'girl'),('👩', 'woman'),('👨', 'man'),('👶', 'baby'),('👵', 'older woman'),('👴', 'older man'),('👱', 'person with blond hair'),('👲', 'man with gua pi mao'),('👳', 'man with turban'),('👷', 'construction worker'),('👮', 'cop'),('👼', 'angel'),('👸', 'princess'),('😺', 'smiley cat'),('😸', 'smile cat'),('😻', 'heart eyes cat'),('😽', 'kissing cat'),('😼', 'smirk cat'),('🙀', 'scream cat'),('😿', 'crying cat face'),('😹', 'joy cat'),('😾', 'pouting cat'),('👹', 'japanese ogre'),('👺', 'japanese goblin'),('🙈', 'see no evil'),('🙉', 'hear no evil'),('🙊', 'speak no evil'),('💂', 'guardsman'),('💀', 'skull'),('👣', 'feet'),('👄', 'lips'),('💋', 'kiss'),('💧', 'droplet'),('👂', 'ear'),('👀', 'eyes'),('👃', 'nose'),('👅', 'tongue'),('💌', 'love letter'),('👤', 'bust in silhouette'),('👥', 'busts in silhouette'),('💬', 'speech balloon'),('💭', 'thought balloon'),('☀', 'sunny'),('☔', 'umbrella'),('☁', 'cloud'),('❄', 'snowflake'),('⛄', 'snowman'),('⚡', 'zap'),('🌀', 'cyclone'),('🌁', 'foggy'),('🌊', 'ocean'),('🐱', 'cat'),('🐶', 'dog'),('🐭', 'mouse'),('🐹', 'hamster'),('🐰', 'rabbit'),('🐺', 'wolf'),('🐸', 'frog'),('🐯', 'tiger'),('🐨', 'koala'),('🐻', 'bear'),('🐷', 'pig'),('🐽', 'pig nose'),('🐮', 'cow'),('🐗', 'boar'),('🐵', 'monkey face'),('🐒', 'monkey'),('🐴', 'horse'),('🐎', 'racehorse'),('🐫', 'camel'),('🐑', 'sheep'),('🐘', 'elephant'),('🐼', 'panda face'),('🐍', 'snake'),('🐦', 'bird'),('🐤', 'baby chick'),('🐥', 'hatched chick'),('🐣', 'hatching chick'),('🐔', 'chicken'),('🐧', 'penguin'),('🐢', 'turtle'),('🐛', 'bug'),('🐝', 'honeybee'),('🐜', 'ant'),('🐞', 'beetle'),('🐌', 'snail'),('🐙', 'octopus'),('🐠', 'tropical fish'),('🐟', 'fish'),('🐳', 'whale'),('🐋', 'whale2'),('🐬', 'dolphin'),('🐄', 'cow2'),('🐏', 'ram'),('🐀', 'rat'),('🐃', 'water buffalo'),('🐅', 'tiger2'),('🐇', 'rabbit2'),('🐉', 'dragon'),('🐐', 'goat'),('🐓', 'rooster'),('🐕', 'dog2'),('🐖', 'pig2'),('🐁', 'mouse2'),('🐂', 'ox'),('🐲', 'dragon face'),('🐡', 'blowfish'),('🐊', 'crocodile'),('🐪', 'dromedary camel'),('🐆', 'leopard'),('🐈', 'cat2'),('🐩', 'poodle'),('🐾', 'paw prints'),('💐', 'bouquet'),('🌸', 'cherry blossom'),('🌷', 'tulip'),('🍀', 'four leaf clover'),('🌹', 'rose'),('🌻', 'sunflower'),('🌺', 'hibiscus'),('🍁', 'maple leaf'),('🍃', 'leaves'),('🍂', 'fallen leaf'),('🌿', 'herb'),('🍄', 'mushroom'),('🌵', 'cactus'),('🌴', 'palm tree'),('🌲', 'evergreen tree'),('🌳', 'deciduous tree'),('🌰', 'chestnut'),('🌱', 'seedling'),('🌼', 'blossom'),('🌾', 'ear of rice'),('🐚', 'shell'),('🌐', 'globe with meridians'),('🌞', 'sun with face'),('🌝', 'full moon with face'),('🌚', 'new moon with face'),('🌑', 'new moon'),('🌒', 'waxing crescent moon'),('🌓', 'first quarter moon'),('🌔', 'waxing gibbous moon'),('🌕', 'full moon'),('🌖', 'waning gibbous moon'),('🌗', 'last quarter moon'),('🌘', 'waning crescent moon'),('🌜', 'last quarter moon with face'),('🌛', 'first quarter moon with face'),('🌙', 'moon'),('🌍', 'earth africa'),('🌎', 'earth americas'),('🌏', 'earth asia'),('🌋', 'volcano'),('🌌', 'milky way'),('⛅', 'partly sunny'),('🎍', 'bamboo'),('💝', 'gift heart'),('🎎', 'dolls'),('🎒', 'school satchel'),('🎓', 'mortar board'),('🎏', 'flags'),('🎆', 'fireworks'),('🎇', 'sparkler'),('🎐', 'wind chime'),('🎑', 'rice scene'),('🎃', 'jack o lantern'),('👻', 'ghost'),('🎅', 'santa'),('🎱', '8ball'),('⏰', 'alarm clock'),('🍎', 'apple'),('🎨', 'art'),('🍼', 'baby bottle'),('🎈', 'balloon'),('🍌', 'banana'),('📊', 'bar chart'),('⚾', 'baseball'),('🏀', 'basketball'),('🛀', 'bath'),('🛁', 'bathtub'),('🔋', 'battery'),('🍺', 'beer'),('🍻', 'beers'),('🔔', 'bell'),('🍱', 'bento'),('🚴', 'bicyclist'),('👙', 'bikini'),('🎂', 'birthday'),('🃏', 'black joker'),('✒', 'black nib'),('📘', 'blue book'),('💣', 'bomb'),('🔖', 'bookmark'),('📑', 'bookmark tabs'),('📚', 'books'),('👢', 'boot'),('🎳', 'bowling'),('🍞', 'bread'),('💼', 'briefcase'),('💡', 'bulb'),('🍰', 'cake'),('📆', 'calendar'),('📲', 'calling'),('📷', 'camera'),('🍬', 'candy'),('📇', 'card index'),('💿', 'cd'),('📉', 'chart with downwards trend'),('📈', 'chart with upwards trend'),('🍒', 'cherries'),('🍫', 'chocolate bar'),('🎄', 'christmas tree'),('🎬', 'clapper'),('📋', 'clipboard'),('📕', 'closed book'),('🔐', 'closed lock with key'),('🌂', 'closed umbrella'),('♣', 'clubs'),('🍸', 'cocktail'),('☕', 'coffee'),('💻', 'computer'),('🎊', 'confetti ball'),('🍪', 'cookie'),('🌽', 'corn'),('💳', 'credit card'),('👑', 'crown'),('🔮', 'crystal ball'),('🍛', 'curry'),('🍮', 'custard'),('🍡', 'dango'),('🎯', 'dart'),('📅', 'date'),('♦', 'diamonds'),('💵', 'dollar'),('🚪', 'door'),('🍩', 'doughnut'),('👗', 'dress'),('📀', 'dvd'),('📧', 'e mail'),('🍳', 'egg'),('🍆', 'eggplant'),('🔌', 'electric plug'),('✉', 'email'),('💶', 'euro'),('👓', 'eyeglasses'),('📠', 'fax'),('📁', 'file folder'),('🍥', 'fish cake'),('🎣', 'fishing pole and fish'),('🔦', 'flashlight'),('💾', 'floppy disk'),('🎴', 'flower playing cards'),('🏈', 'football'),('🍴', 'fork and knife'),('🍤', 'fried shrimp'),('🍟', 'fries'),('🎲', 'game die'),('💎', 'gem'),('🎁', 'gift'),('⛳', 'golf'),('🍇', 'grapes'),('🍏', 'green apple'),('📗', 'green book'),('🎸', 'guitar'),('🔫', 'gun'),('🍔', 'hamburger'),('🔨', 'hammer'),('👜', 'handbag'),('🎧', 'headphones'),('♥', 'hearts'),('🔆', 'high brightness'),('👠', 'high heel'),('🔪', 'hocho'),('🍯', 'honey pot'),('🏇', 'horse racing'),('⌛', 'hourglass'),('⏳', 'hourglass flowing sand'),('🍨', 'ice cream'),('🍦', 'icecream'),('📥', 'inbox tray'),('📨', 'incoming envelope'),('📱', 'iphone'),('👖', 'jeans'),('🔑', 'key'),('👘', 'kimono'),('📒', 'ledger'),('🍋', 'lemon'),('💄', 'lipstick'),('🔒', 'lock'),('🔏', 'lock with ink pen'),('🍭', 'lollipop'),('➿', 'loop'),('📢', 'loudspeaker'),('🔅', 'low brightness'),('🔍', 'mag'),('🔎', 'mag right'),('🀄', 'mahjong'),('📫', 'mailbox'),('📪', 'mailbox closed'),('📬', 'mailbox with mail'),('📭', 'mailbox with no mail'),('👞', 'mans shoe'),('🍖', 'meat on bone'),('📣', 'mega'),('🍈', 'melon'),('📝', 'memo'),('🎤', 'microphone'),('🔬', 'microscope'),('💽', 'minidisc'),('💸', 'money with wings'),('💰', 'moneybag'),('🚵', 'mountain bicyclist'),('🎥', 'movie camera'),('🎹', 'musical keyboard'),('🎼', 'musical score'),('🔇', 'mute'),('📛', 'name badge'),('👔', 'necktie'),('📰', 'newspaper'),('🔕', 'no bell'),('📓', 'notebook'),('📔', 'notebook with decorative cover'),('🔩', 'nut and bolt'),('🍢', 'oden'),('📂', 'open file folder'),('📙', 'orange book'),('📤', 'outbox tray'),('📄', 'page facing up'),('📃', 'page with curl'),('📟', 'pager'),('📎', 'paperclip'),('🍑', 'peach'),('🍐', 'pear'),('✏', 'pencil2'),('☎', 'phone'),('💊', 'pill'),('🍍', 'pineapple'),('🍕', 'pizza'),('📯', 'postal horn'),('📮', 'postbox'),('👝', 'pouch'),('🍗', 'poultry leg'),('💷', 'pound'),('👛', 'purse'),('📌', 'pushpin'),('📻', 'radio'),('🍜', 'ramen'),('🎀', 'ribbon'),('🍚', 'rice'),('🍙', 'rice ball'),('🍘', 'rice cracker'),('💍', 'ring'),('🏉', 'rugby football'),('🎽', 'running shirt with sash'),('🍶', 'sake'),('👡', 'sandal'),('📡', 'satellite'),('🎷', 'saxophone'),('✂', 'scissors'),('📜', 'scroll'),('💺', 'seat'),('🍧', 'shaved ice'),('👕', 'shirt'),('🚿', 'shower'),('🎿', 'ski'),('🚬', 'smoking'),('🏂', 'snowboarder'),('⚽', 'soccer'),('🔉', 'sound'),('👾', 'space invader'),('♠', 'spades'),('🍝', 'spaghetti'),('🔊', 'speaker'),('🍲', 'stew'),('📏', 'straight ruler'),('🍓', 'strawberry'),('🏄', 'surfer'),('🍣', 'sushi'),('🍠', 'sweet potato'),('🏊', 'swimmer'),('💉', 'syringe'),('🎉', 'tada'),('🎋', 'tanabata tree'),('🍊', 'tangerine'),('🍵', 'tea'),('📞', 'telephone receiver'),('🔭', 'telescope'),('🎾', 'tennis'),('🚽', 'toilet'),('🍅', 'tomato'),('🎩', 'tophat'),('📐', 'triangular ruler'),('🏆', 'trophy'),('🍹', 'tropical drink'),('🎺', 'trumpet'),('📺', 'tv'),('🔓', 'unlock'),('📼', 'vhs'),('📹', 'video camera'),('🎮', 'video game'),('🎻', 'violin'),('⌚', 'watch'),('🍉', 'watermelon'),('🍷', 'wine glass'),('👚', 'womans clothes'),('👒', 'womans hat'),('🔧', 'wrench'),('💴', 'yen'),('🚡', 'aerial tramway'),('✈', 'airplane'),('🚑', 'ambulance'),('⚓', 'anchor'),('🚛', 'articulated lorry'),('🏧', 'atm'),('🏦', 'bank'),('💈', 'barber'),('🔰', 'beginner'),('🚲', 'bike'),('🚙', 'blue car'),('⛵', 'boat'),('🌉', 'bridge at night'),('🚅', 'bullettrain front'),('🚄', 'bullettrain side'),('🚌', 'bus'),('🚏', 'busstop'),('🚗', 'car'),('🎠', 'carousel horse'),('🏁', 'checkered flag'),('⛪', 'church'),('🎪', 'circus tent'),('🌇', 'city sunrise'),('🌆', 'city sunset'),('🚧', 'construction'),('🏪', 'convenience store'),('🎌', 'crossed flags'),('🏬', 'department store'),('🏰', 'european castle'),('🏤', 'european post office'),('🏭', 'factory'),('🎡', 'ferris wheel'),('🚒', 'fire engine'),('⛲', 'fountain'),('⛽', 'fuelpump'),('🚁', 'helicopter'),('🏥', 'hospital'),('🏨', 'hotel'),('♨', 'hotsprings'),('🏠', 'house'),('🏡', 'house with garden'),('🗾', 'japan'),('🏯', 'japanese castle'),('🚈', 'light rail'),('🏩', 'love hotel'),('🚐', 'minibus'),('🚝', 'monorail'),('🗻', 'mount fuji'),('🚠', 'mountain cableway'),('🚞', 'mountain railway'),('🗿', 'moyai'),('🏢', 'office'),('🚘', 'oncoming automobile'),('🚍', 'oncoming bus'),('🚔', 'oncoming police car'),('🚖', 'oncoming taxi'),('🎭', 'performing arts'),('🚓', 'police car'),('🏣', 'post office'),('🚃', 'railway car'),('🌈', 'rainbow'),('🚀', 'rocket'),('🎢', 'roller coaster'),('🚨', 'rotating light'),('📍', 'round pushpin'),('🚣', 'rowboat'),('🏫', 'school'),('🚢', 'ship'),('🎰', 'slot machine'),('🚤', 'speedboat'),('🌃', 'stars'),('🚉', 'station'),('🗽', 'statue of liberty'),('🚂', 'steam locomotive'),('🌅', 'sunrise'),('🌄', 'sunrise over mountains'),('🚟', 'suspension railway'),('🚕', 'taxi'),('⛺', 'tent'),('🎫', 'ticket'),('🗼', 'tokyo tower'),('🚜', 'tractor'),('🚥', 'traffic light'),('🚆', 'train2'),('🚊', 'tram'),('🚩', 'triangular flag on post'),('🚎', 'trolleybus'),('🚚', 'truck'),('🚦', 'vertical traffic light'),('⚠', 'warning'),('💒', 'wedding'),('💯', '100'),('🔢', '1234'),('🅰', 'a'),('🆎', 'ab'),('🔤', 'abc'),('🔡', 'abcd'),('🉑', 'accept'),('♒', 'aquarius'),('♈', 'aries'),('◀', 'arrow backward'),('⏬', 'arrow double down'),('⏫', 'arrow double up'),('⬇', 'arrow down'),('🔽', 'arrow down small'),('▶', 'arrow forward'),('⤵', 'arrow heading down'),('⤴', 'arrow heading up'),('⬅', 'arrow left'),('↙', 'arrow lower left'),('↘', 'arrow lower right'),('➡', 'arrow right'),('↪', 'arrow right hook'),('⬆', 'arrow up'),('↕', 'arrow up down'),('🔼', 'arrow up small'),('↖', 'arrow upper left'),('↗', 'arrow upper right'),('🔃', 'arrows clockwise'),('🔄', 'arrows counterclockwise'),('🅱', 'b'),('🚼', 'baby symbol'),('🛄', 'baggage claim'),('☑', 'ballot box with check'),('‼', 'bangbang'),('⚫', 'black circle'),('🔲', 'black square button'),('♋', 'cancer'),('🔠', 'capital abcd'),('♑', 'capricorn'),('💹', 'chart'),('🚸', 'children crossing'),('🎦', 'cinema'),('🆑', 'cl'),('🕐', 'clock1'),('🕙', 'clock10'),('🕥', 'clock1030'),('🕚', 'clock11'),('🕦', 'clock1130'),('🕛', 'clock12'),('🕧', 'clock1230'),('🕜', 'clock130'),('🕑', 'clock2'),('🕝', 'clock230'),('🕒', 'clock3'),('🕞', 'clock330'),('🕓', 'clock4'),('🕟', 'clock430'),('🕔', 'clock5'),('🕠', 'clock530'),('🕕', 'clock6'),('🕡', 'clock630'),('🕖', 'clock7'),('🕢', 'clock730'),('🕗', 'clock8'),('🕣', 'clock830'),('🕘', 'clock9'),('🕤', 'clock930'),('㊗', 'congratulations'),('🆒', 'cool'),('©', 'copyright'),('➰', 'curly loop'),('💱', 'currency exchange'),('🛃', 'customs'),('💠', 'diamond shape with a dot inside'),('🚯', 'do not litter'),('✴', 'eight pointed black star'),('✳', 'eight spoked asterisk'),('🔚', 'end'),('⏩', 'fast forward'),('🆓', 'free'),('♊', 'gemini'),('💟', 'heart decoration'),('✔', 'heavy check mark'),('➗', 'heavy division sign'),('💲', 'heavy dollar sign'),('➖', 'heavy minus sign'),('✖', 'heavy multiplication x'),('➕', 'heavy plus sign'),('🆔', 'id'),('🉐', 'ideograph advantage'),('ℹ', 'information source'),('⁉', 'interrobang'),('🔟', 'keycap ten'),('🈁', 'koko'),('🔵', 'large blue circle'),('🔷', 'large blue diamond'),('🔶', 'large orange diamond'),('🛅', 'left luggage'),('↔', 'left right arrow'),('↩', 'leftwards arrow with hook'),('♌', 'leo'),('♎', 'libra'),('🔗', 'link'),('Ⓜ', 'm'),('🚹', 'mens'),('🚇', 'metro'),('📴', 'mobile phone off'),('❎', 'negative squared cross mark'),('🆕', 'new'),('🆖', 'ng'),('🚳', 'no bicycles'),('⛔', 'no entry'),('🚫', 'no entry sign'),('📵', 'no mobile phones'),('🚷', 'no pedestrians'),('🚭', 'no smoking'),('🚱', 'non potable water'),('⭕', 'o'),('🅾', 'o2'),('🆗', 'ok'),('🔛', 'on'),('⛎', 'ophiuchus'),('🅿', 'parking'),('〽', 'part alternation mark'),('🛂', 'passport control'),('♓', 'pisces'),('🚰', 'potable water'),('🚮', 'put litter in its place'),('🔘', 'radio button'),('♻', 'recycle'),('🔴', 'red circle'),('®', 'registered'),('🔁', 'repeat'),('🔂', 'repeat one'),('🚻', 'restroom'),('⏪', 'rewind'),('🈂', 'sa'),('♐', 'sagittarius'),('♏', 'scorpius'),('㊙', 'secret'),('📶', 'signal strength'),('🔯', 'six pointed star'),('🔹', 'small blue diamond'),('🔸', 'small orange diamond'),('🔺', 'small red triangle'),('🔻', 'small red triangle down'),('🔜', 'soon'),('🆘', 'sos'),('🔣', 'symbols'),('♉', 'taurus'),('™', 'tm'),('🔝', 'top'),('🔱', 'trident'),('🔀', 'twisted rightwards arrows'),('🈹', 'u5272'),('🈴', 'u5408'),('🈺', 'u55b6'),('🈯', 'u6307'),('🈷', 'u6708'),('🈶', 'u6709'),('🈵', 'u6e80'),('🈚', 'u7121'),('🈸', 'u7533'),('🈲', 'u7981'),('🈳', 'u7a7a'),('🔞', 'underage'),('🆙', 'up'),('📳', 'vibration mode'),('♍', 'virgo'),('🆚', 'vs'),('〰', 'wavy dash'),('🚾', 'wc'),('♿', 'wheelchair'),('✅', 'white check mark'),('⚪', 'white circle'),('💮', 'white flower'),('🔳', 'white square button'),('🚺', 'womens'),('❌', 'x')]
