"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DistributedVirtualSwitch = exports.DistributedVirtualSwitchVlanRangeList = exports.DistributedVirtualSwitchVlanRangeOutputReference = exports.distributedVirtualSwitchVlanRangeToTerraform = exports.DistributedVirtualSwitchPvlanMappingList = exports.DistributedVirtualSwitchPvlanMappingOutputReference = exports.distributedVirtualSwitchPvlanMappingToTerraform = exports.DistributedVirtualSwitchHostList = exports.DistributedVirtualSwitchHostOutputReference = exports.distributedVirtualSwitchHostToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function distributedVirtualSwitchHostToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        devices: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.devices),
        host_system_id: cdktf.stringToTerraform(struct.hostSystemId),
    };
}
exports.distributedVirtualSwitchHostToTerraform = distributedVirtualSwitchHostToTerraform;
class DistributedVirtualSwitchHostOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._devices !== undefined) {
            hasAnyValues = true;
            internalValueResult.devices = this._devices;
        }
        if (this._hostSystemId !== undefined) {
            hasAnyValues = true;
            internalValueResult.hostSystemId = this._hostSystemId;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._devices = undefined;
            this._hostSystemId = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._devices = value.devices;
            this._hostSystemId = value.hostSystemId;
        }
    }
    get devices() {
        return this.getListAttribute('devices');
    }
    set devices(value) {
        this._devices = value;
    }
    resetDevices() {
        this._devices = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get devicesInput() {
        return this._devices;
    }
    get hostSystemId() {
        return this.getStringAttribute('host_system_id');
    }
    set hostSystemId(value) {
        this._hostSystemId = value;
    }
    // Temporarily expose input value. Use with caution.
    get hostSystemIdInput() {
        return this._hostSystemId;
    }
}
exports.DistributedVirtualSwitchHostOutputReference = DistributedVirtualSwitchHostOutputReference;
_a = JSII_RTTI_SYMBOL_1;
DistributedVirtualSwitchHostOutputReference[_a] = { fqn: "@cdktf/provider-vsphere.distributedVirtualSwitch.DistributedVirtualSwitchHostOutputReference", version: "0.0.4" };
class DistributedVirtualSwitchHostList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new DistributedVirtualSwitchHostOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.DistributedVirtualSwitchHostList = DistributedVirtualSwitchHostList;
_b = JSII_RTTI_SYMBOL_1;
DistributedVirtualSwitchHostList[_b] = { fqn: "@cdktf/provider-vsphere.distributedVirtualSwitch.DistributedVirtualSwitchHostList", version: "0.0.4" };
function distributedVirtualSwitchPvlanMappingToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        primary_vlan_id: cdktf.numberToTerraform(struct.primaryVlanId),
        pvlan_type: cdktf.stringToTerraform(struct.pvlanType),
        secondary_vlan_id: cdktf.numberToTerraform(struct.secondaryVlanId),
    };
}
exports.distributedVirtualSwitchPvlanMappingToTerraform = distributedVirtualSwitchPvlanMappingToTerraform;
class DistributedVirtualSwitchPvlanMappingOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._primaryVlanId !== undefined) {
            hasAnyValues = true;
            internalValueResult.primaryVlanId = this._primaryVlanId;
        }
        if (this._pvlanType !== undefined) {
            hasAnyValues = true;
            internalValueResult.pvlanType = this._pvlanType;
        }
        if (this._secondaryVlanId !== undefined) {
            hasAnyValues = true;
            internalValueResult.secondaryVlanId = this._secondaryVlanId;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._primaryVlanId = undefined;
            this._pvlanType = undefined;
            this._secondaryVlanId = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._primaryVlanId = value.primaryVlanId;
            this._pvlanType = value.pvlanType;
            this._secondaryVlanId = value.secondaryVlanId;
        }
    }
    get primaryVlanId() {
        return this.getNumberAttribute('primary_vlan_id');
    }
    set primaryVlanId(value) {
        this._primaryVlanId = value;
    }
    // Temporarily expose input value. Use with caution.
    get primaryVlanIdInput() {
        return this._primaryVlanId;
    }
    get pvlanType() {
        return this.getStringAttribute('pvlan_type');
    }
    set pvlanType(value) {
        this._pvlanType = value;
    }
    // Temporarily expose input value. Use with caution.
    get pvlanTypeInput() {
        return this._pvlanType;
    }
    get secondaryVlanId() {
        return this.getNumberAttribute('secondary_vlan_id');
    }
    set secondaryVlanId(value) {
        this._secondaryVlanId = value;
    }
    // Temporarily expose input value. Use with caution.
    get secondaryVlanIdInput() {
        return this._secondaryVlanId;
    }
}
exports.DistributedVirtualSwitchPvlanMappingOutputReference = DistributedVirtualSwitchPvlanMappingOutputReference;
_c = JSII_RTTI_SYMBOL_1;
DistributedVirtualSwitchPvlanMappingOutputReference[_c] = { fqn: "@cdktf/provider-vsphere.distributedVirtualSwitch.DistributedVirtualSwitchPvlanMappingOutputReference", version: "0.0.4" };
class DistributedVirtualSwitchPvlanMappingList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new DistributedVirtualSwitchPvlanMappingOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.DistributedVirtualSwitchPvlanMappingList = DistributedVirtualSwitchPvlanMappingList;
_d = JSII_RTTI_SYMBOL_1;
DistributedVirtualSwitchPvlanMappingList[_d] = { fqn: "@cdktf/provider-vsphere.distributedVirtualSwitch.DistributedVirtualSwitchPvlanMappingList", version: "0.0.4" };
function distributedVirtualSwitchVlanRangeToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        max_vlan: cdktf.numberToTerraform(struct.maxVlan),
        min_vlan: cdktf.numberToTerraform(struct.minVlan),
    };
}
exports.distributedVirtualSwitchVlanRangeToTerraform = distributedVirtualSwitchVlanRangeToTerraform;
class DistributedVirtualSwitchVlanRangeOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._maxVlan !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxVlan = this._maxVlan;
        }
        if (this._minVlan !== undefined) {
            hasAnyValues = true;
            internalValueResult.minVlan = this._minVlan;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._maxVlan = undefined;
            this._minVlan = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._maxVlan = value.maxVlan;
            this._minVlan = value.minVlan;
        }
    }
    get maxVlan() {
        return this.getNumberAttribute('max_vlan');
    }
    set maxVlan(value) {
        this._maxVlan = value;
    }
    // Temporarily expose input value. Use with caution.
    get maxVlanInput() {
        return this._maxVlan;
    }
    get minVlan() {
        return this.getNumberAttribute('min_vlan');
    }
    set minVlan(value) {
        this._minVlan = value;
    }
    // Temporarily expose input value. Use with caution.
    get minVlanInput() {
        return this._minVlan;
    }
}
exports.DistributedVirtualSwitchVlanRangeOutputReference = DistributedVirtualSwitchVlanRangeOutputReference;
_e = JSII_RTTI_SYMBOL_1;
DistributedVirtualSwitchVlanRangeOutputReference[_e] = { fqn: "@cdktf/provider-vsphere.distributedVirtualSwitch.DistributedVirtualSwitchVlanRangeOutputReference", version: "0.0.4" };
class DistributedVirtualSwitchVlanRangeList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new DistributedVirtualSwitchVlanRangeOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.DistributedVirtualSwitchVlanRangeList = DistributedVirtualSwitchVlanRangeList;
_f = JSII_RTTI_SYMBOL_1;
DistributedVirtualSwitchVlanRangeList[_f] = { fqn: "@cdktf/provider-vsphere.distributedVirtualSwitch.DistributedVirtualSwitchVlanRangeList", version: "0.0.4" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_virtual_switch vsphere_distributed_virtual_switch}
*/
class DistributedVirtualSwitch extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_virtual_switch vsphere_distributed_virtual_switch} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DistributedVirtualSwitchConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vsphere_distributed_virtual_switch',
            terraformGeneratorMetadata: {
                providerName: 'vsphere',
                providerVersion: '2.2.0',
                providerVersionConstraint: '~> 2.2'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // host - computed: false, optional: true, required: false
        this._host = new DistributedVirtualSwitchHostList(this, "host", true);
        // pvlan_mapping - computed: false, optional: true, required: false
        this._pvlanMapping = new DistributedVirtualSwitchPvlanMappingList(this, "pvlan_mapping", true);
        // vlan_range - computed: false, optional: true, required: false
        this._vlanRange = new DistributedVirtualSwitchVlanRangeList(this, "vlan_range", true);
        this._activeUplinks = config.activeUplinks;
        this._allowForgedTransmits = config.allowForgedTransmits;
        this._allowMacChanges = config.allowMacChanges;
        this._allowPromiscuous = config.allowPromiscuous;
        this._backupnfcMaximumMbit = config.backupnfcMaximumMbit;
        this._backupnfcReservationMbit = config.backupnfcReservationMbit;
        this._backupnfcShareCount = config.backupnfcShareCount;
        this._backupnfcShareLevel = config.backupnfcShareLevel;
        this._blockAllPorts = config.blockAllPorts;
        this._checkBeacon = config.checkBeacon;
        this._contactDetail = config.contactDetail;
        this._contactName = config.contactName;
        this._customAttributes = config.customAttributes;
        this._datacenterId = config.datacenterId;
        this._description = config.description;
        this._directpathGen2Allowed = config.directpathGen2Allowed;
        this._egressShapingAverageBandwidth = config.egressShapingAverageBandwidth;
        this._egressShapingBurstSize = config.egressShapingBurstSize;
        this._egressShapingEnabled = config.egressShapingEnabled;
        this._egressShapingPeakBandwidth = config.egressShapingPeakBandwidth;
        this._failback = config.failback;
        this._faulttoleranceMaximumMbit = config.faulttoleranceMaximumMbit;
        this._faulttoleranceReservationMbit = config.faulttoleranceReservationMbit;
        this._faulttoleranceShareCount = config.faulttoleranceShareCount;
        this._faulttoleranceShareLevel = config.faulttoleranceShareLevel;
        this._folder = config.folder;
        this._hbrMaximumMbit = config.hbrMaximumMbit;
        this._hbrReservationMbit = config.hbrReservationMbit;
        this._hbrShareCount = config.hbrShareCount;
        this._hbrShareLevel = config.hbrShareLevel;
        this._id = config.id;
        this._ignoreOtherPvlanMappings = config.ignoreOtherPvlanMappings;
        this._ingressShapingAverageBandwidth = config.ingressShapingAverageBandwidth;
        this._ingressShapingBurstSize = config.ingressShapingBurstSize;
        this._ingressShapingEnabled = config.ingressShapingEnabled;
        this._ingressShapingPeakBandwidth = config.ingressShapingPeakBandwidth;
        this._ipv4Address = config.ipv4Address;
        this._iscsiMaximumMbit = config.iscsiMaximumMbit;
        this._iscsiReservationMbit = config.iscsiReservationMbit;
        this._iscsiShareCount = config.iscsiShareCount;
        this._iscsiShareLevel = config.iscsiShareLevel;
        this._lacpApiVersion = config.lacpApiVersion;
        this._lacpEnabled = config.lacpEnabled;
        this._lacpMode = config.lacpMode;
        this._linkDiscoveryOperation = config.linkDiscoveryOperation;
        this._linkDiscoveryProtocol = config.linkDiscoveryProtocol;
        this._managementMaximumMbit = config.managementMaximumMbit;
        this._managementReservationMbit = config.managementReservationMbit;
        this._managementShareCount = config.managementShareCount;
        this._managementShareLevel = config.managementShareLevel;
        this._maxMtu = config.maxMtu;
        this._multicastFilteringMode = config.multicastFilteringMode;
        this._name = config.name;
        this._netflowActiveFlowTimeout = config.netflowActiveFlowTimeout;
        this._netflowCollectorIpAddress = config.netflowCollectorIpAddress;
        this._netflowCollectorPort = config.netflowCollectorPort;
        this._netflowEnabled = config.netflowEnabled;
        this._netflowIdleFlowTimeout = config.netflowIdleFlowTimeout;
        this._netflowInternalFlowsOnly = config.netflowInternalFlowsOnly;
        this._netflowObservationDomainId = config.netflowObservationDomainId;
        this._netflowSamplingRate = config.netflowSamplingRate;
        this._networkResourceControlEnabled = config.networkResourceControlEnabled;
        this._networkResourceControlVersion = config.networkResourceControlVersion;
        this._nfsMaximumMbit = config.nfsMaximumMbit;
        this._nfsReservationMbit = config.nfsReservationMbit;
        this._nfsShareCount = config.nfsShareCount;
        this._nfsShareLevel = config.nfsShareLevel;
        this._notifySwitches = config.notifySwitches;
        this._portPrivateSecondaryVlanId = config.portPrivateSecondaryVlanId;
        this._standbyUplinks = config.standbyUplinks;
        this._tags = config.tags;
        this._teamingPolicy = config.teamingPolicy;
        this._txUplink = config.txUplink;
        this._uplinks = config.uplinks;
        this._vdpMaximumMbit = config.vdpMaximumMbit;
        this._vdpReservationMbit = config.vdpReservationMbit;
        this._vdpShareCount = config.vdpShareCount;
        this._vdpShareLevel = config.vdpShareLevel;
        this._version = config.version;
        this._virtualmachineMaximumMbit = config.virtualmachineMaximumMbit;
        this._virtualmachineReservationMbit = config.virtualmachineReservationMbit;
        this._virtualmachineShareCount = config.virtualmachineShareCount;
        this._virtualmachineShareLevel = config.virtualmachineShareLevel;
        this._vlanId = config.vlanId;
        this._vmotionMaximumMbit = config.vmotionMaximumMbit;
        this._vmotionReservationMbit = config.vmotionReservationMbit;
        this._vmotionShareCount = config.vmotionShareCount;
        this._vmotionShareLevel = config.vmotionShareLevel;
        this._vsanMaximumMbit = config.vsanMaximumMbit;
        this._vsanReservationMbit = config.vsanReservationMbit;
        this._vsanShareCount = config.vsanShareCount;
        this._vsanShareLevel = config.vsanShareLevel;
        this._host.internalValue = config.host;
        this._pvlanMapping.internalValue = config.pvlanMapping;
        this._vlanRange.internalValue = config.vlanRange;
    }
    get activeUplinks() {
        return this.getListAttribute('active_uplinks');
    }
    set activeUplinks(value) {
        this._activeUplinks = value;
    }
    resetActiveUplinks() {
        this._activeUplinks = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get activeUplinksInput() {
        return this._activeUplinks;
    }
    get allowForgedTransmits() {
        return this.getBooleanAttribute('allow_forged_transmits');
    }
    set allowForgedTransmits(value) {
        this._allowForgedTransmits = value;
    }
    resetAllowForgedTransmits() {
        this._allowForgedTransmits = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowForgedTransmitsInput() {
        return this._allowForgedTransmits;
    }
    get allowMacChanges() {
        return this.getBooleanAttribute('allow_mac_changes');
    }
    set allowMacChanges(value) {
        this._allowMacChanges = value;
    }
    resetAllowMacChanges() {
        this._allowMacChanges = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowMacChangesInput() {
        return this._allowMacChanges;
    }
    get allowPromiscuous() {
        return this.getBooleanAttribute('allow_promiscuous');
    }
    set allowPromiscuous(value) {
        this._allowPromiscuous = value;
    }
    resetAllowPromiscuous() {
        this._allowPromiscuous = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowPromiscuousInput() {
        return this._allowPromiscuous;
    }
    get backupnfcMaximumMbit() {
        return this.getNumberAttribute('backupnfc_maximum_mbit');
    }
    set backupnfcMaximumMbit(value) {
        this._backupnfcMaximumMbit = value;
    }
    resetBackupnfcMaximumMbit() {
        this._backupnfcMaximumMbit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backupnfcMaximumMbitInput() {
        return this._backupnfcMaximumMbit;
    }
    get backupnfcReservationMbit() {
        return this.getNumberAttribute('backupnfc_reservation_mbit');
    }
    set backupnfcReservationMbit(value) {
        this._backupnfcReservationMbit = value;
    }
    resetBackupnfcReservationMbit() {
        this._backupnfcReservationMbit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backupnfcReservationMbitInput() {
        return this._backupnfcReservationMbit;
    }
    get backupnfcShareCount() {
        return this.getNumberAttribute('backupnfc_share_count');
    }
    set backupnfcShareCount(value) {
        this._backupnfcShareCount = value;
    }
    resetBackupnfcShareCount() {
        this._backupnfcShareCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backupnfcShareCountInput() {
        return this._backupnfcShareCount;
    }
    get backupnfcShareLevel() {
        return this.getStringAttribute('backupnfc_share_level');
    }
    set backupnfcShareLevel(value) {
        this._backupnfcShareLevel = value;
    }
    resetBackupnfcShareLevel() {
        this._backupnfcShareLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backupnfcShareLevelInput() {
        return this._backupnfcShareLevel;
    }
    get blockAllPorts() {
        return this.getBooleanAttribute('block_all_ports');
    }
    set blockAllPorts(value) {
        this._blockAllPorts = value;
    }
    resetBlockAllPorts() {
        this._blockAllPorts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get blockAllPortsInput() {
        return this._blockAllPorts;
    }
    get checkBeacon() {
        return this.getBooleanAttribute('check_beacon');
    }
    set checkBeacon(value) {
        this._checkBeacon = value;
    }
    resetCheckBeacon() {
        this._checkBeacon = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get checkBeaconInput() {
        return this._checkBeacon;
    }
    // config_version - computed: true, optional: false, required: false
    get configVersion() {
        return this.getStringAttribute('config_version');
    }
    get contactDetail() {
        return this.getStringAttribute('contact_detail');
    }
    set contactDetail(value) {
        this._contactDetail = value;
    }
    resetContactDetail() {
        this._contactDetail = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get contactDetailInput() {
        return this._contactDetail;
    }
    get contactName() {
        return this.getStringAttribute('contact_name');
    }
    set contactName(value) {
        this._contactName = value;
    }
    resetContactName() {
        this._contactName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get contactNameInput() {
        return this._contactName;
    }
    get customAttributes() {
        return this.getStringMapAttribute('custom_attributes');
    }
    set customAttributes(value) {
        this._customAttributes = value;
    }
    resetCustomAttributes() {
        this._customAttributes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customAttributesInput() {
        return this._customAttributes;
    }
    get datacenterId() {
        return this.getStringAttribute('datacenter_id');
    }
    set datacenterId(value) {
        this._datacenterId = value;
    }
    // Temporarily expose input value. Use with caution.
    get datacenterIdInput() {
        return this._datacenterId;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get directpathGen2Allowed() {
        return this.getBooleanAttribute('directpath_gen2_allowed');
    }
    set directpathGen2Allowed(value) {
        this._directpathGen2Allowed = value;
    }
    resetDirectpathGen2Allowed() {
        this._directpathGen2Allowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get directpathGen2AllowedInput() {
        return this._directpathGen2Allowed;
    }
    get egressShapingAverageBandwidth() {
        return this.getNumberAttribute('egress_shaping_average_bandwidth');
    }
    set egressShapingAverageBandwidth(value) {
        this._egressShapingAverageBandwidth = value;
    }
    resetEgressShapingAverageBandwidth() {
        this._egressShapingAverageBandwidth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get egressShapingAverageBandwidthInput() {
        return this._egressShapingAverageBandwidth;
    }
    get egressShapingBurstSize() {
        return this.getNumberAttribute('egress_shaping_burst_size');
    }
    set egressShapingBurstSize(value) {
        this._egressShapingBurstSize = value;
    }
    resetEgressShapingBurstSize() {
        this._egressShapingBurstSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get egressShapingBurstSizeInput() {
        return this._egressShapingBurstSize;
    }
    get egressShapingEnabled() {
        return this.getBooleanAttribute('egress_shaping_enabled');
    }
    set egressShapingEnabled(value) {
        this._egressShapingEnabled = value;
    }
    resetEgressShapingEnabled() {
        this._egressShapingEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get egressShapingEnabledInput() {
        return this._egressShapingEnabled;
    }
    get egressShapingPeakBandwidth() {
        return this.getNumberAttribute('egress_shaping_peak_bandwidth');
    }
    set egressShapingPeakBandwidth(value) {
        this._egressShapingPeakBandwidth = value;
    }
    resetEgressShapingPeakBandwidth() {
        this._egressShapingPeakBandwidth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get egressShapingPeakBandwidthInput() {
        return this._egressShapingPeakBandwidth;
    }
    get failback() {
        return this.getBooleanAttribute('failback');
    }
    set failback(value) {
        this._failback = value;
    }
    resetFailback() {
        this._failback = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get failbackInput() {
        return this._failback;
    }
    get faulttoleranceMaximumMbit() {
        return this.getNumberAttribute('faulttolerance_maximum_mbit');
    }
    set faulttoleranceMaximumMbit(value) {
        this._faulttoleranceMaximumMbit = value;
    }
    resetFaulttoleranceMaximumMbit() {
        this._faulttoleranceMaximumMbit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get faulttoleranceMaximumMbitInput() {
        return this._faulttoleranceMaximumMbit;
    }
    get faulttoleranceReservationMbit() {
        return this.getNumberAttribute('faulttolerance_reservation_mbit');
    }
    set faulttoleranceReservationMbit(value) {
        this._faulttoleranceReservationMbit = value;
    }
    resetFaulttoleranceReservationMbit() {
        this._faulttoleranceReservationMbit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get faulttoleranceReservationMbitInput() {
        return this._faulttoleranceReservationMbit;
    }
    get faulttoleranceShareCount() {
        return this.getNumberAttribute('faulttolerance_share_count');
    }
    set faulttoleranceShareCount(value) {
        this._faulttoleranceShareCount = value;
    }
    resetFaulttoleranceShareCount() {
        this._faulttoleranceShareCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get faulttoleranceShareCountInput() {
        return this._faulttoleranceShareCount;
    }
    get faulttoleranceShareLevel() {
        return this.getStringAttribute('faulttolerance_share_level');
    }
    set faulttoleranceShareLevel(value) {
        this._faulttoleranceShareLevel = value;
    }
    resetFaulttoleranceShareLevel() {
        this._faulttoleranceShareLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get faulttoleranceShareLevelInput() {
        return this._faulttoleranceShareLevel;
    }
    get folder() {
        return this.getStringAttribute('folder');
    }
    set folder(value) {
        this._folder = value;
    }
    resetFolder() {
        this._folder = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get folderInput() {
        return this._folder;
    }
    get hbrMaximumMbit() {
        return this.getNumberAttribute('hbr_maximum_mbit');
    }
    set hbrMaximumMbit(value) {
        this._hbrMaximumMbit = value;
    }
    resetHbrMaximumMbit() {
        this._hbrMaximumMbit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hbrMaximumMbitInput() {
        return this._hbrMaximumMbit;
    }
    get hbrReservationMbit() {
        return this.getNumberAttribute('hbr_reservation_mbit');
    }
    set hbrReservationMbit(value) {
        this._hbrReservationMbit = value;
    }
    resetHbrReservationMbit() {
        this._hbrReservationMbit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hbrReservationMbitInput() {
        return this._hbrReservationMbit;
    }
    get hbrShareCount() {
        return this.getNumberAttribute('hbr_share_count');
    }
    set hbrShareCount(value) {
        this._hbrShareCount = value;
    }
    resetHbrShareCount() {
        this._hbrShareCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hbrShareCountInput() {
        return this._hbrShareCount;
    }
    get hbrShareLevel() {
        return this.getStringAttribute('hbr_share_level');
    }
    set hbrShareLevel(value) {
        this._hbrShareLevel = value;
    }
    resetHbrShareLevel() {
        this._hbrShareLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hbrShareLevelInput() {
        return this._hbrShareLevel;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get ignoreOtherPvlanMappings() {
        return this.getBooleanAttribute('ignore_other_pvlan_mappings');
    }
    set ignoreOtherPvlanMappings(value) {
        this._ignoreOtherPvlanMappings = value;
    }
    resetIgnoreOtherPvlanMappings() {
        this._ignoreOtherPvlanMappings = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ignoreOtherPvlanMappingsInput() {
        return this._ignoreOtherPvlanMappings;
    }
    get ingressShapingAverageBandwidth() {
        return this.getNumberAttribute('ingress_shaping_average_bandwidth');
    }
    set ingressShapingAverageBandwidth(value) {
        this._ingressShapingAverageBandwidth = value;
    }
    resetIngressShapingAverageBandwidth() {
        this._ingressShapingAverageBandwidth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ingressShapingAverageBandwidthInput() {
        return this._ingressShapingAverageBandwidth;
    }
    get ingressShapingBurstSize() {
        return this.getNumberAttribute('ingress_shaping_burst_size');
    }
    set ingressShapingBurstSize(value) {
        this._ingressShapingBurstSize = value;
    }
    resetIngressShapingBurstSize() {
        this._ingressShapingBurstSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ingressShapingBurstSizeInput() {
        return this._ingressShapingBurstSize;
    }
    get ingressShapingEnabled() {
        return this.getBooleanAttribute('ingress_shaping_enabled');
    }
    set ingressShapingEnabled(value) {
        this._ingressShapingEnabled = value;
    }
    resetIngressShapingEnabled() {
        this._ingressShapingEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ingressShapingEnabledInput() {
        return this._ingressShapingEnabled;
    }
    get ingressShapingPeakBandwidth() {
        return this.getNumberAttribute('ingress_shaping_peak_bandwidth');
    }
    set ingressShapingPeakBandwidth(value) {
        this._ingressShapingPeakBandwidth = value;
    }
    resetIngressShapingPeakBandwidth() {
        this._ingressShapingPeakBandwidth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ingressShapingPeakBandwidthInput() {
        return this._ingressShapingPeakBandwidth;
    }
    get ipv4Address() {
        return this.getStringAttribute('ipv4_address');
    }
    set ipv4Address(value) {
        this._ipv4Address = value;
    }
    resetIpv4Address() {
        this._ipv4Address = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ipv4AddressInput() {
        return this._ipv4Address;
    }
    get iscsiMaximumMbit() {
        return this.getNumberAttribute('iscsi_maximum_mbit');
    }
    set iscsiMaximumMbit(value) {
        this._iscsiMaximumMbit = value;
    }
    resetIscsiMaximumMbit() {
        this._iscsiMaximumMbit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iscsiMaximumMbitInput() {
        return this._iscsiMaximumMbit;
    }
    get iscsiReservationMbit() {
        return this.getNumberAttribute('iscsi_reservation_mbit');
    }
    set iscsiReservationMbit(value) {
        this._iscsiReservationMbit = value;
    }
    resetIscsiReservationMbit() {
        this._iscsiReservationMbit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iscsiReservationMbitInput() {
        return this._iscsiReservationMbit;
    }
    get iscsiShareCount() {
        return this.getNumberAttribute('iscsi_share_count');
    }
    set iscsiShareCount(value) {
        this._iscsiShareCount = value;
    }
    resetIscsiShareCount() {
        this._iscsiShareCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iscsiShareCountInput() {
        return this._iscsiShareCount;
    }
    get iscsiShareLevel() {
        return this.getStringAttribute('iscsi_share_level');
    }
    set iscsiShareLevel(value) {
        this._iscsiShareLevel = value;
    }
    resetIscsiShareLevel() {
        this._iscsiShareLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iscsiShareLevelInput() {
        return this._iscsiShareLevel;
    }
    get lacpApiVersion() {
        return this.getStringAttribute('lacp_api_version');
    }
    set lacpApiVersion(value) {
        this._lacpApiVersion = value;
    }
    resetLacpApiVersion() {
        this._lacpApiVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lacpApiVersionInput() {
        return this._lacpApiVersion;
    }
    get lacpEnabled() {
        return this.getBooleanAttribute('lacp_enabled');
    }
    set lacpEnabled(value) {
        this._lacpEnabled = value;
    }
    resetLacpEnabled() {
        this._lacpEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lacpEnabledInput() {
        return this._lacpEnabled;
    }
    get lacpMode() {
        return this.getStringAttribute('lacp_mode');
    }
    set lacpMode(value) {
        this._lacpMode = value;
    }
    resetLacpMode() {
        this._lacpMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lacpModeInput() {
        return this._lacpMode;
    }
    get linkDiscoveryOperation() {
        return this.getStringAttribute('link_discovery_operation');
    }
    set linkDiscoveryOperation(value) {
        this._linkDiscoveryOperation = value;
    }
    resetLinkDiscoveryOperation() {
        this._linkDiscoveryOperation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get linkDiscoveryOperationInput() {
        return this._linkDiscoveryOperation;
    }
    get linkDiscoveryProtocol() {
        return this.getStringAttribute('link_discovery_protocol');
    }
    set linkDiscoveryProtocol(value) {
        this._linkDiscoveryProtocol = value;
    }
    resetLinkDiscoveryProtocol() {
        this._linkDiscoveryProtocol = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get linkDiscoveryProtocolInput() {
        return this._linkDiscoveryProtocol;
    }
    get managementMaximumMbit() {
        return this.getNumberAttribute('management_maximum_mbit');
    }
    set managementMaximumMbit(value) {
        this._managementMaximumMbit = value;
    }
    resetManagementMaximumMbit() {
        this._managementMaximumMbit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get managementMaximumMbitInput() {
        return this._managementMaximumMbit;
    }
    get managementReservationMbit() {
        return this.getNumberAttribute('management_reservation_mbit');
    }
    set managementReservationMbit(value) {
        this._managementReservationMbit = value;
    }
    resetManagementReservationMbit() {
        this._managementReservationMbit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get managementReservationMbitInput() {
        return this._managementReservationMbit;
    }
    get managementShareCount() {
        return this.getNumberAttribute('management_share_count');
    }
    set managementShareCount(value) {
        this._managementShareCount = value;
    }
    resetManagementShareCount() {
        this._managementShareCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get managementShareCountInput() {
        return this._managementShareCount;
    }
    get managementShareLevel() {
        return this.getStringAttribute('management_share_level');
    }
    set managementShareLevel(value) {
        this._managementShareLevel = value;
    }
    resetManagementShareLevel() {
        this._managementShareLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get managementShareLevelInput() {
        return this._managementShareLevel;
    }
    get maxMtu() {
        return this.getNumberAttribute('max_mtu');
    }
    set maxMtu(value) {
        this._maxMtu = value;
    }
    resetMaxMtu() {
        this._maxMtu = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxMtuInput() {
        return this._maxMtu;
    }
    get multicastFilteringMode() {
        return this.getStringAttribute('multicast_filtering_mode');
    }
    set multicastFilteringMode(value) {
        this._multicastFilteringMode = value;
    }
    resetMulticastFilteringMode() {
        this._multicastFilteringMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get multicastFilteringModeInput() {
        return this._multicastFilteringMode;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get netflowActiveFlowTimeout() {
        return this.getNumberAttribute('netflow_active_flow_timeout');
    }
    set netflowActiveFlowTimeout(value) {
        this._netflowActiveFlowTimeout = value;
    }
    resetNetflowActiveFlowTimeout() {
        this._netflowActiveFlowTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netflowActiveFlowTimeoutInput() {
        return this._netflowActiveFlowTimeout;
    }
    get netflowCollectorIpAddress() {
        return this.getStringAttribute('netflow_collector_ip_address');
    }
    set netflowCollectorIpAddress(value) {
        this._netflowCollectorIpAddress = value;
    }
    resetNetflowCollectorIpAddress() {
        this._netflowCollectorIpAddress = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netflowCollectorIpAddressInput() {
        return this._netflowCollectorIpAddress;
    }
    get netflowCollectorPort() {
        return this.getNumberAttribute('netflow_collector_port');
    }
    set netflowCollectorPort(value) {
        this._netflowCollectorPort = value;
    }
    resetNetflowCollectorPort() {
        this._netflowCollectorPort = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netflowCollectorPortInput() {
        return this._netflowCollectorPort;
    }
    get netflowEnabled() {
        return this.getBooleanAttribute('netflow_enabled');
    }
    set netflowEnabled(value) {
        this._netflowEnabled = value;
    }
    resetNetflowEnabled() {
        this._netflowEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netflowEnabledInput() {
        return this._netflowEnabled;
    }
    get netflowIdleFlowTimeout() {
        return this.getNumberAttribute('netflow_idle_flow_timeout');
    }
    set netflowIdleFlowTimeout(value) {
        this._netflowIdleFlowTimeout = value;
    }
    resetNetflowIdleFlowTimeout() {
        this._netflowIdleFlowTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netflowIdleFlowTimeoutInput() {
        return this._netflowIdleFlowTimeout;
    }
    get netflowInternalFlowsOnly() {
        return this.getBooleanAttribute('netflow_internal_flows_only');
    }
    set netflowInternalFlowsOnly(value) {
        this._netflowInternalFlowsOnly = value;
    }
    resetNetflowInternalFlowsOnly() {
        this._netflowInternalFlowsOnly = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netflowInternalFlowsOnlyInput() {
        return this._netflowInternalFlowsOnly;
    }
    get netflowObservationDomainId() {
        return this.getNumberAttribute('netflow_observation_domain_id');
    }
    set netflowObservationDomainId(value) {
        this._netflowObservationDomainId = value;
    }
    resetNetflowObservationDomainId() {
        this._netflowObservationDomainId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netflowObservationDomainIdInput() {
        return this._netflowObservationDomainId;
    }
    get netflowSamplingRate() {
        return this.getNumberAttribute('netflow_sampling_rate');
    }
    set netflowSamplingRate(value) {
        this._netflowSamplingRate = value;
    }
    resetNetflowSamplingRate() {
        this._netflowSamplingRate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netflowSamplingRateInput() {
        return this._netflowSamplingRate;
    }
    get networkResourceControlEnabled() {
        return this.getBooleanAttribute('network_resource_control_enabled');
    }
    set networkResourceControlEnabled(value) {
        this._networkResourceControlEnabled = value;
    }
    resetNetworkResourceControlEnabled() {
        this._networkResourceControlEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkResourceControlEnabledInput() {
        return this._networkResourceControlEnabled;
    }
    get networkResourceControlVersion() {
        return this.getStringAttribute('network_resource_control_version');
    }
    set networkResourceControlVersion(value) {
        this._networkResourceControlVersion = value;
    }
    resetNetworkResourceControlVersion() {
        this._networkResourceControlVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkResourceControlVersionInput() {
        return this._networkResourceControlVersion;
    }
    get nfsMaximumMbit() {
        return this.getNumberAttribute('nfs_maximum_mbit');
    }
    set nfsMaximumMbit(value) {
        this._nfsMaximumMbit = value;
    }
    resetNfsMaximumMbit() {
        this._nfsMaximumMbit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nfsMaximumMbitInput() {
        return this._nfsMaximumMbit;
    }
    get nfsReservationMbit() {
        return this.getNumberAttribute('nfs_reservation_mbit');
    }
    set nfsReservationMbit(value) {
        this._nfsReservationMbit = value;
    }
    resetNfsReservationMbit() {
        this._nfsReservationMbit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nfsReservationMbitInput() {
        return this._nfsReservationMbit;
    }
    get nfsShareCount() {
        return this.getNumberAttribute('nfs_share_count');
    }
    set nfsShareCount(value) {
        this._nfsShareCount = value;
    }
    resetNfsShareCount() {
        this._nfsShareCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nfsShareCountInput() {
        return this._nfsShareCount;
    }
    get nfsShareLevel() {
        return this.getStringAttribute('nfs_share_level');
    }
    set nfsShareLevel(value) {
        this._nfsShareLevel = value;
    }
    resetNfsShareLevel() {
        this._nfsShareLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nfsShareLevelInput() {
        return this._nfsShareLevel;
    }
    get notifySwitches() {
        return this.getBooleanAttribute('notify_switches');
    }
    set notifySwitches(value) {
        this._notifySwitches = value;
    }
    resetNotifySwitches() {
        this._notifySwitches = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notifySwitchesInput() {
        return this._notifySwitches;
    }
    get portPrivateSecondaryVlanId() {
        return this.getNumberAttribute('port_private_secondary_vlan_id');
    }
    set portPrivateSecondaryVlanId(value) {
        this._portPrivateSecondaryVlanId = value;
    }
    resetPortPrivateSecondaryVlanId() {
        this._portPrivateSecondaryVlanId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portPrivateSecondaryVlanIdInput() {
        return this._portPrivateSecondaryVlanId;
    }
    get standbyUplinks() {
        return this.getListAttribute('standby_uplinks');
    }
    set standbyUplinks(value) {
        this._standbyUplinks = value;
    }
    resetStandbyUplinks() {
        this._standbyUplinks = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get standbyUplinksInput() {
        return this._standbyUplinks;
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get teamingPolicy() {
        return this.getStringAttribute('teaming_policy');
    }
    set teamingPolicy(value) {
        this._teamingPolicy = value;
    }
    resetTeamingPolicy() {
        this._teamingPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get teamingPolicyInput() {
        return this._teamingPolicy;
    }
    get txUplink() {
        return this.getBooleanAttribute('tx_uplink');
    }
    set txUplink(value) {
        this._txUplink = value;
    }
    resetTxUplink() {
        this._txUplink = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get txUplinkInput() {
        return this._txUplink;
    }
    get uplinks() {
        return this.getListAttribute('uplinks');
    }
    set uplinks(value) {
        this._uplinks = value;
    }
    resetUplinks() {
        this._uplinks = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get uplinksInput() {
        return this._uplinks;
    }
    get vdpMaximumMbit() {
        return this.getNumberAttribute('vdp_maximum_mbit');
    }
    set vdpMaximumMbit(value) {
        this._vdpMaximumMbit = value;
    }
    resetVdpMaximumMbit() {
        this._vdpMaximumMbit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vdpMaximumMbitInput() {
        return this._vdpMaximumMbit;
    }
    get vdpReservationMbit() {
        return this.getNumberAttribute('vdp_reservation_mbit');
    }
    set vdpReservationMbit(value) {
        this._vdpReservationMbit = value;
    }
    resetVdpReservationMbit() {
        this._vdpReservationMbit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vdpReservationMbitInput() {
        return this._vdpReservationMbit;
    }
    get vdpShareCount() {
        return this.getNumberAttribute('vdp_share_count');
    }
    set vdpShareCount(value) {
        this._vdpShareCount = value;
    }
    resetVdpShareCount() {
        this._vdpShareCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vdpShareCountInput() {
        return this._vdpShareCount;
    }
    get vdpShareLevel() {
        return this.getStringAttribute('vdp_share_level');
    }
    set vdpShareLevel(value) {
        this._vdpShareLevel = value;
    }
    resetVdpShareLevel() {
        this._vdpShareLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vdpShareLevelInput() {
        return this._vdpShareLevel;
    }
    get version() {
        return this.getStringAttribute('version');
    }
    set version(value) {
        this._version = value;
    }
    resetVersion() {
        this._version = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get versionInput() {
        return this._version;
    }
    get virtualmachineMaximumMbit() {
        return this.getNumberAttribute('virtualmachine_maximum_mbit');
    }
    set virtualmachineMaximumMbit(value) {
        this._virtualmachineMaximumMbit = value;
    }
    resetVirtualmachineMaximumMbit() {
        this._virtualmachineMaximumMbit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get virtualmachineMaximumMbitInput() {
        return this._virtualmachineMaximumMbit;
    }
    get virtualmachineReservationMbit() {
        return this.getNumberAttribute('virtualmachine_reservation_mbit');
    }
    set virtualmachineReservationMbit(value) {
        this._virtualmachineReservationMbit = value;
    }
    resetVirtualmachineReservationMbit() {
        this._virtualmachineReservationMbit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get virtualmachineReservationMbitInput() {
        return this._virtualmachineReservationMbit;
    }
    get virtualmachineShareCount() {
        return this.getNumberAttribute('virtualmachine_share_count');
    }
    set virtualmachineShareCount(value) {
        this._virtualmachineShareCount = value;
    }
    resetVirtualmachineShareCount() {
        this._virtualmachineShareCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get virtualmachineShareCountInput() {
        return this._virtualmachineShareCount;
    }
    get virtualmachineShareLevel() {
        return this.getStringAttribute('virtualmachine_share_level');
    }
    set virtualmachineShareLevel(value) {
        this._virtualmachineShareLevel = value;
    }
    resetVirtualmachineShareLevel() {
        this._virtualmachineShareLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get virtualmachineShareLevelInput() {
        return this._virtualmachineShareLevel;
    }
    get vlanId() {
        return this.getNumberAttribute('vlan_id');
    }
    set vlanId(value) {
        this._vlanId = value;
    }
    resetVlanId() {
        this._vlanId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vlanIdInput() {
        return this._vlanId;
    }
    get vmotionMaximumMbit() {
        return this.getNumberAttribute('vmotion_maximum_mbit');
    }
    set vmotionMaximumMbit(value) {
        this._vmotionMaximumMbit = value;
    }
    resetVmotionMaximumMbit() {
        this._vmotionMaximumMbit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vmotionMaximumMbitInput() {
        return this._vmotionMaximumMbit;
    }
    get vmotionReservationMbit() {
        return this.getNumberAttribute('vmotion_reservation_mbit');
    }
    set vmotionReservationMbit(value) {
        this._vmotionReservationMbit = value;
    }
    resetVmotionReservationMbit() {
        this._vmotionReservationMbit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vmotionReservationMbitInput() {
        return this._vmotionReservationMbit;
    }
    get vmotionShareCount() {
        return this.getNumberAttribute('vmotion_share_count');
    }
    set vmotionShareCount(value) {
        this._vmotionShareCount = value;
    }
    resetVmotionShareCount() {
        this._vmotionShareCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vmotionShareCountInput() {
        return this._vmotionShareCount;
    }
    get vmotionShareLevel() {
        return this.getStringAttribute('vmotion_share_level');
    }
    set vmotionShareLevel(value) {
        this._vmotionShareLevel = value;
    }
    resetVmotionShareLevel() {
        this._vmotionShareLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vmotionShareLevelInput() {
        return this._vmotionShareLevel;
    }
    get vsanMaximumMbit() {
        return this.getNumberAttribute('vsan_maximum_mbit');
    }
    set vsanMaximumMbit(value) {
        this._vsanMaximumMbit = value;
    }
    resetVsanMaximumMbit() {
        this._vsanMaximumMbit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanMaximumMbitInput() {
        return this._vsanMaximumMbit;
    }
    get vsanReservationMbit() {
        return this.getNumberAttribute('vsan_reservation_mbit');
    }
    set vsanReservationMbit(value) {
        this._vsanReservationMbit = value;
    }
    resetVsanReservationMbit() {
        this._vsanReservationMbit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanReservationMbitInput() {
        return this._vsanReservationMbit;
    }
    get vsanShareCount() {
        return this.getNumberAttribute('vsan_share_count');
    }
    set vsanShareCount(value) {
        this._vsanShareCount = value;
    }
    resetVsanShareCount() {
        this._vsanShareCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanShareCountInput() {
        return this._vsanShareCount;
    }
    get vsanShareLevel() {
        return this.getStringAttribute('vsan_share_level');
    }
    set vsanShareLevel(value) {
        this._vsanShareLevel = value;
    }
    resetVsanShareLevel() {
        this._vsanShareLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanShareLevelInput() {
        return this._vsanShareLevel;
    }
    get host() {
        return this._host;
    }
    putHost(value) {
        this._host.internalValue = value;
    }
    resetHost() {
        this._host.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostInput() {
        return this._host.internalValue;
    }
    get pvlanMapping() {
        return this._pvlanMapping;
    }
    putPvlanMapping(value) {
        this._pvlanMapping.internalValue = value;
    }
    resetPvlanMapping() {
        this._pvlanMapping.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pvlanMappingInput() {
        return this._pvlanMapping.internalValue;
    }
    get vlanRange() {
        return this._vlanRange;
    }
    putVlanRange(value) {
        this._vlanRange.internalValue = value;
    }
    resetVlanRange() {
        this._vlanRange.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vlanRangeInput() {
        return this._vlanRange.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            active_uplinks: cdktf.listMapper(cdktf.stringToTerraform, false)(this._activeUplinks),
            allow_forged_transmits: cdktf.booleanToTerraform(this._allowForgedTransmits),
            allow_mac_changes: cdktf.booleanToTerraform(this._allowMacChanges),
            allow_promiscuous: cdktf.booleanToTerraform(this._allowPromiscuous),
            backupnfc_maximum_mbit: cdktf.numberToTerraform(this._backupnfcMaximumMbit),
            backupnfc_reservation_mbit: cdktf.numberToTerraform(this._backupnfcReservationMbit),
            backupnfc_share_count: cdktf.numberToTerraform(this._backupnfcShareCount),
            backupnfc_share_level: cdktf.stringToTerraform(this._backupnfcShareLevel),
            block_all_ports: cdktf.booleanToTerraform(this._blockAllPorts),
            check_beacon: cdktf.booleanToTerraform(this._checkBeacon),
            contact_detail: cdktf.stringToTerraform(this._contactDetail),
            contact_name: cdktf.stringToTerraform(this._contactName),
            custom_attributes: cdktf.hashMapper(cdktf.stringToTerraform)(this._customAttributes),
            datacenter_id: cdktf.stringToTerraform(this._datacenterId),
            description: cdktf.stringToTerraform(this._description),
            directpath_gen2_allowed: cdktf.booleanToTerraform(this._directpathGen2Allowed),
            egress_shaping_average_bandwidth: cdktf.numberToTerraform(this._egressShapingAverageBandwidth),
            egress_shaping_burst_size: cdktf.numberToTerraform(this._egressShapingBurstSize),
            egress_shaping_enabled: cdktf.booleanToTerraform(this._egressShapingEnabled),
            egress_shaping_peak_bandwidth: cdktf.numberToTerraform(this._egressShapingPeakBandwidth),
            failback: cdktf.booleanToTerraform(this._failback),
            faulttolerance_maximum_mbit: cdktf.numberToTerraform(this._faulttoleranceMaximumMbit),
            faulttolerance_reservation_mbit: cdktf.numberToTerraform(this._faulttoleranceReservationMbit),
            faulttolerance_share_count: cdktf.numberToTerraform(this._faulttoleranceShareCount),
            faulttolerance_share_level: cdktf.stringToTerraform(this._faulttoleranceShareLevel),
            folder: cdktf.stringToTerraform(this._folder),
            hbr_maximum_mbit: cdktf.numberToTerraform(this._hbrMaximumMbit),
            hbr_reservation_mbit: cdktf.numberToTerraform(this._hbrReservationMbit),
            hbr_share_count: cdktf.numberToTerraform(this._hbrShareCount),
            hbr_share_level: cdktf.stringToTerraform(this._hbrShareLevel),
            id: cdktf.stringToTerraform(this._id),
            ignore_other_pvlan_mappings: cdktf.booleanToTerraform(this._ignoreOtherPvlanMappings),
            ingress_shaping_average_bandwidth: cdktf.numberToTerraform(this._ingressShapingAverageBandwidth),
            ingress_shaping_burst_size: cdktf.numberToTerraform(this._ingressShapingBurstSize),
            ingress_shaping_enabled: cdktf.booleanToTerraform(this._ingressShapingEnabled),
            ingress_shaping_peak_bandwidth: cdktf.numberToTerraform(this._ingressShapingPeakBandwidth),
            ipv4_address: cdktf.stringToTerraform(this._ipv4Address),
            iscsi_maximum_mbit: cdktf.numberToTerraform(this._iscsiMaximumMbit),
            iscsi_reservation_mbit: cdktf.numberToTerraform(this._iscsiReservationMbit),
            iscsi_share_count: cdktf.numberToTerraform(this._iscsiShareCount),
            iscsi_share_level: cdktf.stringToTerraform(this._iscsiShareLevel),
            lacp_api_version: cdktf.stringToTerraform(this._lacpApiVersion),
            lacp_enabled: cdktf.booleanToTerraform(this._lacpEnabled),
            lacp_mode: cdktf.stringToTerraform(this._lacpMode),
            link_discovery_operation: cdktf.stringToTerraform(this._linkDiscoveryOperation),
            link_discovery_protocol: cdktf.stringToTerraform(this._linkDiscoveryProtocol),
            management_maximum_mbit: cdktf.numberToTerraform(this._managementMaximumMbit),
            management_reservation_mbit: cdktf.numberToTerraform(this._managementReservationMbit),
            management_share_count: cdktf.numberToTerraform(this._managementShareCount),
            management_share_level: cdktf.stringToTerraform(this._managementShareLevel),
            max_mtu: cdktf.numberToTerraform(this._maxMtu),
            multicast_filtering_mode: cdktf.stringToTerraform(this._multicastFilteringMode),
            name: cdktf.stringToTerraform(this._name),
            netflow_active_flow_timeout: cdktf.numberToTerraform(this._netflowActiveFlowTimeout),
            netflow_collector_ip_address: cdktf.stringToTerraform(this._netflowCollectorIpAddress),
            netflow_collector_port: cdktf.numberToTerraform(this._netflowCollectorPort),
            netflow_enabled: cdktf.booleanToTerraform(this._netflowEnabled),
            netflow_idle_flow_timeout: cdktf.numberToTerraform(this._netflowIdleFlowTimeout),
            netflow_internal_flows_only: cdktf.booleanToTerraform(this._netflowInternalFlowsOnly),
            netflow_observation_domain_id: cdktf.numberToTerraform(this._netflowObservationDomainId),
            netflow_sampling_rate: cdktf.numberToTerraform(this._netflowSamplingRate),
            network_resource_control_enabled: cdktf.booleanToTerraform(this._networkResourceControlEnabled),
            network_resource_control_version: cdktf.stringToTerraform(this._networkResourceControlVersion),
            nfs_maximum_mbit: cdktf.numberToTerraform(this._nfsMaximumMbit),
            nfs_reservation_mbit: cdktf.numberToTerraform(this._nfsReservationMbit),
            nfs_share_count: cdktf.numberToTerraform(this._nfsShareCount),
            nfs_share_level: cdktf.stringToTerraform(this._nfsShareLevel),
            notify_switches: cdktf.booleanToTerraform(this._notifySwitches),
            port_private_secondary_vlan_id: cdktf.numberToTerraform(this._portPrivateSecondaryVlanId),
            standby_uplinks: cdktf.listMapper(cdktf.stringToTerraform, false)(this._standbyUplinks),
            tags: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tags),
            teaming_policy: cdktf.stringToTerraform(this._teamingPolicy),
            tx_uplink: cdktf.booleanToTerraform(this._txUplink),
            uplinks: cdktf.listMapper(cdktf.stringToTerraform, false)(this._uplinks),
            vdp_maximum_mbit: cdktf.numberToTerraform(this._vdpMaximumMbit),
            vdp_reservation_mbit: cdktf.numberToTerraform(this._vdpReservationMbit),
            vdp_share_count: cdktf.numberToTerraform(this._vdpShareCount),
            vdp_share_level: cdktf.stringToTerraform(this._vdpShareLevel),
            version: cdktf.stringToTerraform(this._version),
            virtualmachine_maximum_mbit: cdktf.numberToTerraform(this._virtualmachineMaximumMbit),
            virtualmachine_reservation_mbit: cdktf.numberToTerraform(this._virtualmachineReservationMbit),
            virtualmachine_share_count: cdktf.numberToTerraform(this._virtualmachineShareCount),
            virtualmachine_share_level: cdktf.stringToTerraform(this._virtualmachineShareLevel),
            vlan_id: cdktf.numberToTerraform(this._vlanId),
            vmotion_maximum_mbit: cdktf.numberToTerraform(this._vmotionMaximumMbit),
            vmotion_reservation_mbit: cdktf.numberToTerraform(this._vmotionReservationMbit),
            vmotion_share_count: cdktf.numberToTerraform(this._vmotionShareCount),
            vmotion_share_level: cdktf.stringToTerraform(this._vmotionShareLevel),
            vsan_maximum_mbit: cdktf.numberToTerraform(this._vsanMaximumMbit),
            vsan_reservation_mbit: cdktf.numberToTerraform(this._vsanReservationMbit),
            vsan_share_count: cdktf.numberToTerraform(this._vsanShareCount),
            vsan_share_level: cdktf.stringToTerraform(this._vsanShareLevel),
            host: cdktf.listMapper(distributedVirtualSwitchHostToTerraform, true)(this._host.internalValue),
            pvlan_mapping: cdktf.listMapper(distributedVirtualSwitchPvlanMappingToTerraform, true)(this._pvlanMapping.internalValue),
            vlan_range: cdktf.listMapper(distributedVirtualSwitchVlanRangeToTerraform, true)(this._vlanRange.internalValue),
        };
    }
}
exports.DistributedVirtualSwitch = DistributedVirtualSwitch;
_g = JSII_RTTI_SYMBOL_1;
DistributedVirtualSwitch[_g] = { fqn: "@cdktf/provider-vsphere.distributedVirtualSwitch.DistributedVirtualSwitch", version: "0.0.4" };
// =================
// STATIC PROPERTIES
// =================
DistributedVirtualSwitch.tfResourceType = "vsphere_distributed_virtual_switch";
//# sourceMappingURL=data:application/json;base64,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