import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatacenterConfig extends cdktf.TerraformMetaArguments {
    /**
    * A list of custom attributes to set on this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/datacenter#custom_attributes Datacenter#custom_attributes}
    */
    readonly customAttributes?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/datacenter#folder Datacenter#folder}
    */
    readonly folder?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/datacenter#id Datacenter#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/datacenter#name Datacenter#name}
    */
    readonly name: string;
    /**
    * A list of tag IDs to apply to this object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/datacenter#tags Datacenter#tags}
    */
    readonly tags?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/r/datacenter vsphere_datacenter}
*/
export declare class Datacenter extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_datacenter";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/r/datacenter vsphere_datacenter} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatacenterConfig
    */
    constructor(scope: Construct, id: string, config: DatacenterConfig);
    private _customAttributes?;
    get customAttributes(): {
        [key: string]: string;
    };
    set customAttributes(value: {
        [key: string]: string;
    });
    resetCustomAttributes(): void;
    get customAttributesInput(): {
        [key: string]: string;
    } | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    resetFolder(): void;
    get folderInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get moid(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
