"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataVsphereVirtualMachine = exports.DataVsphereVirtualMachineVappOutputReference = exports.dataVsphereVirtualMachineVappToTerraform = exports.DataVsphereVirtualMachineNetworkInterfacesList = exports.DataVsphereVirtualMachineNetworkInterfacesOutputReference = exports.dataVsphereVirtualMachineNetworkInterfacesToTerraform = exports.DataVsphereVirtualMachineDisksList = exports.DataVsphereVirtualMachineDisksOutputReference = exports.dataVsphereVirtualMachineDisksToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function dataVsphereVirtualMachineDisksToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {};
}
exports.dataVsphereVirtualMachineDisksToTerraform = dataVsphereVirtualMachineDisksToTerraform;
class DataVsphereVirtualMachineDisksOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
        }
    }
    // eagerly_scrub - computed: true, optional: false, required: false
    get eagerlyScrub() {
        return this.getBooleanAttribute('eagerly_scrub');
    }
    // label - computed: true, optional: false, required: false
    get label() {
        return this.getStringAttribute('label');
    }
    // size - computed: true, optional: false, required: false
    get size() {
        return this.getNumberAttribute('size');
    }
    // thin_provisioned - computed: true, optional: false, required: false
    get thinProvisioned() {
        return this.getBooleanAttribute('thin_provisioned');
    }
    // unit_number - computed: true, optional: false, required: false
    get unitNumber() {
        return this.getNumberAttribute('unit_number');
    }
}
exports.DataVsphereVirtualMachineDisksOutputReference = DataVsphereVirtualMachineDisksOutputReference;
_a = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachineDisksOutputReference[_a] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachineDisksOutputReference", version: "0.0.4" };
class DataVsphereVirtualMachineDisksList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new DataVsphereVirtualMachineDisksOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.DataVsphereVirtualMachineDisksList = DataVsphereVirtualMachineDisksList;
_b = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachineDisksList[_b] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachineDisksList", version: "0.0.4" };
function dataVsphereVirtualMachineNetworkInterfacesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {};
}
exports.dataVsphereVirtualMachineNetworkInterfacesToTerraform = dataVsphereVirtualMachineNetworkInterfacesToTerraform;
class DataVsphereVirtualMachineNetworkInterfacesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
        }
    }
    // adapter_type - computed: true, optional: false, required: false
    get adapterType() {
        return this.getStringAttribute('adapter_type');
    }
    // bandwidth_limit - computed: true, optional: false, required: false
    get bandwidthLimit() {
        return this.getNumberAttribute('bandwidth_limit');
    }
    // bandwidth_reservation - computed: true, optional: false, required: false
    get bandwidthReservation() {
        return this.getNumberAttribute('bandwidth_reservation');
    }
    // bandwidth_share_count - computed: true, optional: false, required: false
    get bandwidthShareCount() {
        return this.getNumberAttribute('bandwidth_share_count');
    }
    // bandwidth_share_level - computed: true, optional: false, required: false
    get bandwidthShareLevel() {
        return this.getStringAttribute('bandwidth_share_level');
    }
    // mac_address - computed: true, optional: false, required: false
    get macAddress() {
        return this.getStringAttribute('mac_address');
    }
    // network_id - computed: true, optional: false, required: false
    get networkId() {
        return this.getStringAttribute('network_id');
    }
}
exports.DataVsphereVirtualMachineNetworkInterfacesOutputReference = DataVsphereVirtualMachineNetworkInterfacesOutputReference;
_c = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachineNetworkInterfacesOutputReference[_c] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachineNetworkInterfacesOutputReference", version: "0.0.4" };
class DataVsphereVirtualMachineNetworkInterfacesList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new DataVsphereVirtualMachineNetworkInterfacesOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.DataVsphereVirtualMachineNetworkInterfacesList = DataVsphereVirtualMachineNetworkInterfacesList;
_d = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachineNetworkInterfacesList[_d] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachineNetworkInterfacesList", version: "0.0.4" };
function dataVsphereVirtualMachineVappToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        properties: cdktf.hashMapper(cdktf.stringToTerraform)(struct.properties),
    };
}
exports.dataVsphereVirtualMachineVappToTerraform = dataVsphereVirtualMachineVappToTerraform;
class DataVsphereVirtualMachineVappOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._properties !== undefined) {
            hasAnyValues = true;
            internalValueResult.properties = this._properties;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._properties = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._properties = value.properties;
        }
    }
    get properties() {
        return this.getStringMapAttribute('properties');
    }
    set properties(value) {
        this._properties = value;
    }
    resetProperties() {
        this._properties = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get propertiesInput() {
        return this._properties;
    }
}
exports.DataVsphereVirtualMachineVappOutputReference = DataVsphereVirtualMachineVappOutputReference;
_e = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachineVappOutputReference[_e] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachineVappOutputReference", version: "0.0.4" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine vsphere_virtual_machine}
*/
class DataVsphereVirtualMachine extends cdktf.TerraformDataSource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine vsphere_virtual_machine} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereVirtualMachineConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'vsphere_virtual_machine',
            terraformGeneratorMetadata: {
                providerName: 'vsphere',
                providerVersion: '2.2.0',
                providerVersionConstraint: '~> 2.2'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // disks - computed: true, optional: false, required: false
        this._disks = new DataVsphereVirtualMachineDisksList(this, "disks", false);
        // network_interfaces - computed: true, optional: false, required: false
        this._networkInterfaces = new DataVsphereVirtualMachineNetworkInterfacesList(this, "network_interfaces", false);
        // vapp - computed: false, optional: true, required: false
        this._vapp = new DataVsphereVirtualMachineVappOutputReference(this, "vapp");
        this._alternateGuestName = config.alternateGuestName;
        this._annotation = config.annotation;
        this._bootDelay = config.bootDelay;
        this._bootRetryDelay = config.bootRetryDelay;
        this._bootRetryEnabled = config.bootRetryEnabled;
        this._cpuHotAddEnabled = config.cpuHotAddEnabled;
        this._cpuHotRemoveEnabled = config.cpuHotRemoveEnabled;
        this._cpuLimit = config.cpuLimit;
        this._cpuPerformanceCountersEnabled = config.cpuPerformanceCountersEnabled;
        this._cpuReservation = config.cpuReservation;
        this._cpuShareCount = config.cpuShareCount;
        this._cpuShareLevel = config.cpuShareLevel;
        this._datacenterId = config.datacenterId;
        this._efiSecureBootEnabled = config.efiSecureBootEnabled;
        this._enableDiskUuid = config.enableDiskUuid;
        this._enableLogging = config.enableLogging;
        this._eptRviMode = config.eptRviMode;
        this._extraConfig = config.extraConfig;
        this._firmware = config.firmware;
        this._guestId = config.guestId;
        this._hardwareVersion = config.hardwareVersion;
        this._hvMode = config.hvMode;
        this._id = config.id;
        this._ideControllerScanCount = config.ideControllerScanCount;
        this._latencySensitivity = config.latencySensitivity;
        this._memory = config.memory;
        this._memoryHotAddEnabled = config.memoryHotAddEnabled;
        this._memoryLimit = config.memoryLimit;
        this._memoryReservation = config.memoryReservation;
        this._memoryShareCount = config.memoryShareCount;
        this._memoryShareLevel = config.memoryShareLevel;
        this._name = config.name;
        this._nestedHvEnabled = config.nestedHvEnabled;
        this._numCoresPerSocket = config.numCoresPerSocket;
        this._numCpus = config.numCpus;
        this._replaceTrigger = config.replaceTrigger;
        this._runToolsScriptsAfterPowerOn = config.runToolsScriptsAfterPowerOn;
        this._runToolsScriptsAfterResume = config.runToolsScriptsAfterResume;
        this._runToolsScriptsBeforeGuestReboot = config.runToolsScriptsBeforeGuestReboot;
        this._runToolsScriptsBeforeGuestShutdown = config.runToolsScriptsBeforeGuestShutdown;
        this._runToolsScriptsBeforeGuestStandby = config.runToolsScriptsBeforeGuestStandby;
        this._sataControllerScanCount = config.sataControllerScanCount;
        this._scsiControllerScanCount = config.scsiControllerScanCount;
        this._storagePolicyId = config.storagePolicyId;
        this._swapPlacementPolicy = config.swapPlacementPolicy;
        this._syncTimeWithHost = config.syncTimeWithHost;
        this._syncTimeWithHostPeriodically = config.syncTimeWithHostPeriodically;
        this._toolsUpgradePolicy = config.toolsUpgradePolicy;
        this._uuid = config.uuid;
        this._vbsEnabled = config.vbsEnabled;
        this._vvtdEnabled = config.vvtdEnabled;
        this._vapp.internalValue = config.vapp;
    }
    get alternateGuestName() {
        return this.getStringAttribute('alternate_guest_name');
    }
    set alternateGuestName(value) {
        this._alternateGuestName = value;
    }
    resetAlternateGuestName() {
        this._alternateGuestName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get alternateGuestNameInput() {
        return this._alternateGuestName;
    }
    get annotation() {
        return this.getStringAttribute('annotation');
    }
    set annotation(value) {
        this._annotation = value;
    }
    resetAnnotation() {
        this._annotation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get annotationInput() {
        return this._annotation;
    }
    get bootDelay() {
        return this.getNumberAttribute('boot_delay');
    }
    set bootDelay(value) {
        this._bootDelay = value;
    }
    resetBootDelay() {
        this._bootDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bootDelayInput() {
        return this._bootDelay;
    }
    get bootRetryDelay() {
        return this.getNumberAttribute('boot_retry_delay');
    }
    set bootRetryDelay(value) {
        this._bootRetryDelay = value;
    }
    resetBootRetryDelay() {
        this._bootRetryDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bootRetryDelayInput() {
        return this._bootRetryDelay;
    }
    get bootRetryEnabled() {
        return this.getBooleanAttribute('boot_retry_enabled');
    }
    set bootRetryEnabled(value) {
        this._bootRetryEnabled = value;
    }
    resetBootRetryEnabled() {
        this._bootRetryEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bootRetryEnabledInput() {
        return this._bootRetryEnabled;
    }
    // change_version - computed: true, optional: false, required: false
    get changeVersion() {
        return this.getStringAttribute('change_version');
    }
    get cpuHotAddEnabled() {
        return this.getBooleanAttribute('cpu_hot_add_enabled');
    }
    set cpuHotAddEnabled(value) {
        this._cpuHotAddEnabled = value;
    }
    resetCpuHotAddEnabled() {
        this._cpuHotAddEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuHotAddEnabledInput() {
        return this._cpuHotAddEnabled;
    }
    get cpuHotRemoveEnabled() {
        return this.getBooleanAttribute('cpu_hot_remove_enabled');
    }
    set cpuHotRemoveEnabled(value) {
        this._cpuHotRemoveEnabled = value;
    }
    resetCpuHotRemoveEnabled() {
        this._cpuHotRemoveEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuHotRemoveEnabledInput() {
        return this._cpuHotRemoveEnabled;
    }
    get cpuLimit() {
        return this.getNumberAttribute('cpu_limit');
    }
    set cpuLimit(value) {
        this._cpuLimit = value;
    }
    resetCpuLimit() {
        this._cpuLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuLimitInput() {
        return this._cpuLimit;
    }
    get cpuPerformanceCountersEnabled() {
        return this.getBooleanAttribute('cpu_performance_counters_enabled');
    }
    set cpuPerformanceCountersEnabled(value) {
        this._cpuPerformanceCountersEnabled = value;
    }
    resetCpuPerformanceCountersEnabled() {
        this._cpuPerformanceCountersEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuPerformanceCountersEnabledInput() {
        return this._cpuPerformanceCountersEnabled;
    }
    get cpuReservation() {
        return this.getNumberAttribute('cpu_reservation');
    }
    set cpuReservation(value) {
        this._cpuReservation = value;
    }
    resetCpuReservation() {
        this._cpuReservation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuReservationInput() {
        return this._cpuReservation;
    }
    get cpuShareCount() {
        return this.getNumberAttribute('cpu_share_count');
    }
    set cpuShareCount(value) {
        this._cpuShareCount = value;
    }
    resetCpuShareCount() {
        this._cpuShareCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuShareCountInput() {
        return this._cpuShareCount;
    }
    get cpuShareLevel() {
        return this.getStringAttribute('cpu_share_level');
    }
    set cpuShareLevel(value) {
        this._cpuShareLevel = value;
    }
    resetCpuShareLevel() {
        this._cpuShareLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuShareLevelInput() {
        return this._cpuShareLevel;
    }
    get datacenterId() {
        return this.getStringAttribute('datacenter_id');
    }
    set datacenterId(value) {
        this._datacenterId = value;
    }
    resetDatacenterId() {
        this._datacenterId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get datacenterIdInput() {
        return this._datacenterId;
    }
    // default_ip_address - computed: true, optional: false, required: false
    get defaultIpAddress() {
        return this.getStringAttribute('default_ip_address');
    }
    get disks() {
        return this._disks;
    }
    get efiSecureBootEnabled() {
        return this.getBooleanAttribute('efi_secure_boot_enabled');
    }
    set efiSecureBootEnabled(value) {
        this._efiSecureBootEnabled = value;
    }
    resetEfiSecureBootEnabled() {
        this._efiSecureBootEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get efiSecureBootEnabledInput() {
        return this._efiSecureBootEnabled;
    }
    get enableDiskUuid() {
        return this.getBooleanAttribute('enable_disk_uuid');
    }
    set enableDiskUuid(value) {
        this._enableDiskUuid = value;
    }
    resetEnableDiskUuid() {
        this._enableDiskUuid = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableDiskUuidInput() {
        return this._enableDiskUuid;
    }
    get enableLogging() {
        return this.getBooleanAttribute('enable_logging');
    }
    set enableLogging(value) {
        this._enableLogging = value;
    }
    resetEnableLogging() {
        this._enableLogging = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableLoggingInput() {
        return this._enableLogging;
    }
    get eptRviMode() {
        return this.getStringAttribute('ept_rvi_mode');
    }
    set eptRviMode(value) {
        this._eptRviMode = value;
    }
    resetEptRviMode() {
        this._eptRviMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eptRviModeInput() {
        return this._eptRviMode;
    }
    get extraConfig() {
        return this.getStringMapAttribute('extra_config');
    }
    set extraConfig(value) {
        this._extraConfig = value;
    }
    resetExtraConfig() {
        this._extraConfig = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get extraConfigInput() {
        return this._extraConfig;
    }
    get firmware() {
        return this.getStringAttribute('firmware');
    }
    set firmware(value) {
        this._firmware = value;
    }
    resetFirmware() {
        this._firmware = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get firmwareInput() {
        return this._firmware;
    }
    get guestId() {
        return this.getStringAttribute('guest_id');
    }
    set guestId(value) {
        this._guestId = value;
    }
    resetGuestId() {
        this._guestId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get guestIdInput() {
        return this._guestId;
    }
    // guest_ip_addresses - computed: true, optional: false, required: false
    get guestIpAddresses() {
        return this.getListAttribute('guest_ip_addresses');
    }
    get hardwareVersion() {
        return this.getNumberAttribute('hardware_version');
    }
    set hardwareVersion(value) {
        this._hardwareVersion = value;
    }
    resetHardwareVersion() {
        this._hardwareVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hardwareVersionInput() {
        return this._hardwareVersion;
    }
    get hvMode() {
        return this.getStringAttribute('hv_mode');
    }
    set hvMode(value) {
        this._hvMode = value;
    }
    resetHvMode() {
        this._hvMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hvModeInput() {
        return this._hvMode;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get ideControllerScanCount() {
        return this.getNumberAttribute('ide_controller_scan_count');
    }
    set ideControllerScanCount(value) {
        this._ideControllerScanCount = value;
    }
    resetIdeControllerScanCount() {
        this._ideControllerScanCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ideControllerScanCountInput() {
        return this._ideControllerScanCount;
    }
    get latencySensitivity() {
        return this.getStringAttribute('latency_sensitivity');
    }
    set latencySensitivity(value) {
        this._latencySensitivity = value;
    }
    resetLatencySensitivity() {
        this._latencySensitivity = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get latencySensitivityInput() {
        return this._latencySensitivity;
    }
    get memory() {
        return this.getNumberAttribute('memory');
    }
    set memory(value) {
        this._memory = value;
    }
    resetMemory() {
        this._memory = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryInput() {
        return this._memory;
    }
    get memoryHotAddEnabled() {
        return this.getBooleanAttribute('memory_hot_add_enabled');
    }
    set memoryHotAddEnabled(value) {
        this._memoryHotAddEnabled = value;
    }
    resetMemoryHotAddEnabled() {
        this._memoryHotAddEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryHotAddEnabledInput() {
        return this._memoryHotAddEnabled;
    }
    get memoryLimit() {
        return this.getNumberAttribute('memory_limit');
    }
    set memoryLimit(value) {
        this._memoryLimit = value;
    }
    resetMemoryLimit() {
        this._memoryLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryLimitInput() {
        return this._memoryLimit;
    }
    get memoryReservation() {
        return this.getNumberAttribute('memory_reservation');
    }
    set memoryReservation(value) {
        this._memoryReservation = value;
    }
    resetMemoryReservation() {
        this._memoryReservation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryReservationInput() {
        return this._memoryReservation;
    }
    get memoryShareCount() {
        return this.getNumberAttribute('memory_share_count');
    }
    set memoryShareCount(value) {
        this._memoryShareCount = value;
    }
    resetMemoryShareCount() {
        this._memoryShareCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryShareCountInput() {
        return this._memoryShareCount;
    }
    get memoryShareLevel() {
        return this.getStringAttribute('memory_share_level');
    }
    set memoryShareLevel(value) {
        this._memoryShareLevel = value;
    }
    resetMemoryShareLevel() {
        this._memoryShareLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryShareLevelInput() {
        return this._memoryShareLevel;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    resetName() {
        this._name = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get nestedHvEnabled() {
        return this.getBooleanAttribute('nested_hv_enabled');
    }
    set nestedHvEnabled(value) {
        this._nestedHvEnabled = value;
    }
    resetNestedHvEnabled() {
        this._nestedHvEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nestedHvEnabledInput() {
        return this._nestedHvEnabled;
    }
    // network_interface_types - computed: true, optional: false, required: false
    get networkInterfaceTypes() {
        return this.getListAttribute('network_interface_types');
    }
    get networkInterfaces() {
        return this._networkInterfaces;
    }
    get numCoresPerSocket() {
        return this.getNumberAttribute('num_cores_per_socket');
    }
    set numCoresPerSocket(value) {
        this._numCoresPerSocket = value;
    }
    resetNumCoresPerSocket() {
        this._numCoresPerSocket = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get numCoresPerSocketInput() {
        return this._numCoresPerSocket;
    }
    get numCpus() {
        return this.getNumberAttribute('num_cpus');
    }
    set numCpus(value) {
        this._numCpus = value;
    }
    resetNumCpus() {
        this._numCpus = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get numCpusInput() {
        return this._numCpus;
    }
    get replaceTrigger() {
        return this.getStringAttribute('replace_trigger');
    }
    set replaceTrigger(value) {
        this._replaceTrigger = value;
    }
    resetReplaceTrigger() {
        this._replaceTrigger = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get replaceTriggerInput() {
        return this._replaceTrigger;
    }
    get runToolsScriptsAfterPowerOn() {
        return this.getBooleanAttribute('run_tools_scripts_after_power_on');
    }
    set runToolsScriptsAfterPowerOn(value) {
        this._runToolsScriptsAfterPowerOn = value;
    }
    resetRunToolsScriptsAfterPowerOn() {
        this._runToolsScriptsAfterPowerOn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runToolsScriptsAfterPowerOnInput() {
        return this._runToolsScriptsAfterPowerOn;
    }
    get runToolsScriptsAfterResume() {
        return this.getBooleanAttribute('run_tools_scripts_after_resume');
    }
    set runToolsScriptsAfterResume(value) {
        this._runToolsScriptsAfterResume = value;
    }
    resetRunToolsScriptsAfterResume() {
        this._runToolsScriptsAfterResume = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runToolsScriptsAfterResumeInput() {
        return this._runToolsScriptsAfterResume;
    }
    get runToolsScriptsBeforeGuestReboot() {
        return this.getBooleanAttribute('run_tools_scripts_before_guest_reboot');
    }
    set runToolsScriptsBeforeGuestReboot(value) {
        this._runToolsScriptsBeforeGuestReboot = value;
    }
    resetRunToolsScriptsBeforeGuestReboot() {
        this._runToolsScriptsBeforeGuestReboot = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runToolsScriptsBeforeGuestRebootInput() {
        return this._runToolsScriptsBeforeGuestReboot;
    }
    get runToolsScriptsBeforeGuestShutdown() {
        return this.getBooleanAttribute('run_tools_scripts_before_guest_shutdown');
    }
    set runToolsScriptsBeforeGuestShutdown(value) {
        this._runToolsScriptsBeforeGuestShutdown = value;
    }
    resetRunToolsScriptsBeforeGuestShutdown() {
        this._runToolsScriptsBeforeGuestShutdown = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runToolsScriptsBeforeGuestShutdownInput() {
        return this._runToolsScriptsBeforeGuestShutdown;
    }
    get runToolsScriptsBeforeGuestStandby() {
        return this.getBooleanAttribute('run_tools_scripts_before_guest_standby');
    }
    set runToolsScriptsBeforeGuestStandby(value) {
        this._runToolsScriptsBeforeGuestStandby = value;
    }
    resetRunToolsScriptsBeforeGuestStandby() {
        this._runToolsScriptsBeforeGuestStandby = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runToolsScriptsBeforeGuestStandbyInput() {
        return this._runToolsScriptsBeforeGuestStandby;
    }
    get sataControllerScanCount() {
        return this.getNumberAttribute('sata_controller_scan_count');
    }
    set sataControllerScanCount(value) {
        this._sataControllerScanCount = value;
    }
    resetSataControllerScanCount() {
        this._sataControllerScanCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sataControllerScanCountInput() {
        return this._sataControllerScanCount;
    }
    // scsi_bus_sharing - computed: true, optional: false, required: false
    get scsiBusSharing() {
        return this.getStringAttribute('scsi_bus_sharing');
    }
    get scsiControllerScanCount() {
        return this.getNumberAttribute('scsi_controller_scan_count');
    }
    set scsiControllerScanCount(value) {
        this._scsiControllerScanCount = value;
    }
    resetScsiControllerScanCount() {
        this._scsiControllerScanCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get scsiControllerScanCountInput() {
        return this._scsiControllerScanCount;
    }
    // scsi_type - computed: true, optional: false, required: false
    get scsiType() {
        return this.getStringAttribute('scsi_type');
    }
    get storagePolicyId() {
        return this.getStringAttribute('storage_policy_id');
    }
    set storagePolicyId(value) {
        this._storagePolicyId = value;
    }
    resetStoragePolicyId() {
        this._storagePolicyId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storagePolicyIdInput() {
        return this._storagePolicyId;
    }
    get swapPlacementPolicy() {
        return this.getStringAttribute('swap_placement_policy');
    }
    set swapPlacementPolicy(value) {
        this._swapPlacementPolicy = value;
    }
    resetSwapPlacementPolicy() {
        this._swapPlacementPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get swapPlacementPolicyInput() {
        return this._swapPlacementPolicy;
    }
    get syncTimeWithHost() {
        return this.getBooleanAttribute('sync_time_with_host');
    }
    set syncTimeWithHost(value) {
        this._syncTimeWithHost = value;
    }
    resetSyncTimeWithHost() {
        this._syncTimeWithHost = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get syncTimeWithHostInput() {
        return this._syncTimeWithHost;
    }
    get syncTimeWithHostPeriodically() {
        return this.getBooleanAttribute('sync_time_with_host_periodically');
    }
    set syncTimeWithHostPeriodically(value) {
        this._syncTimeWithHostPeriodically = value;
    }
    resetSyncTimeWithHostPeriodically() {
        this._syncTimeWithHostPeriodically = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get syncTimeWithHostPeriodicallyInput() {
        return this._syncTimeWithHostPeriodically;
    }
    get toolsUpgradePolicy() {
        return this.getStringAttribute('tools_upgrade_policy');
    }
    set toolsUpgradePolicy(value) {
        this._toolsUpgradePolicy = value;
    }
    resetToolsUpgradePolicy() {
        this._toolsUpgradePolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get toolsUpgradePolicyInput() {
        return this._toolsUpgradePolicy;
    }
    get uuid() {
        return this.getStringAttribute('uuid');
    }
    set uuid(value) {
        this._uuid = value;
    }
    resetUuid() {
        this._uuid = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get uuidInput() {
        return this._uuid;
    }
    // vapp_transport - computed: true, optional: false, required: false
    get vappTransport() {
        return this.getListAttribute('vapp_transport');
    }
    get vbsEnabled() {
        return this.getBooleanAttribute('vbs_enabled');
    }
    set vbsEnabled(value) {
        this._vbsEnabled = value;
    }
    resetVbsEnabled() {
        this._vbsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vbsEnabledInput() {
        return this._vbsEnabled;
    }
    get vvtdEnabled() {
        return this.getBooleanAttribute('vvtd_enabled');
    }
    set vvtdEnabled(value) {
        this._vvtdEnabled = value;
    }
    resetVvtdEnabled() {
        this._vvtdEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vvtdEnabledInput() {
        return this._vvtdEnabled;
    }
    get vapp() {
        return this._vapp;
    }
    putVapp(value) {
        this._vapp.internalValue = value;
    }
    resetVapp() {
        this._vapp.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vappInput() {
        return this._vapp.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            alternate_guest_name: cdktf.stringToTerraform(this._alternateGuestName),
            annotation: cdktf.stringToTerraform(this._annotation),
            boot_delay: cdktf.numberToTerraform(this._bootDelay),
            boot_retry_delay: cdktf.numberToTerraform(this._bootRetryDelay),
            boot_retry_enabled: cdktf.booleanToTerraform(this._bootRetryEnabled),
            cpu_hot_add_enabled: cdktf.booleanToTerraform(this._cpuHotAddEnabled),
            cpu_hot_remove_enabled: cdktf.booleanToTerraform(this._cpuHotRemoveEnabled),
            cpu_limit: cdktf.numberToTerraform(this._cpuLimit),
            cpu_performance_counters_enabled: cdktf.booleanToTerraform(this._cpuPerformanceCountersEnabled),
            cpu_reservation: cdktf.numberToTerraform(this._cpuReservation),
            cpu_share_count: cdktf.numberToTerraform(this._cpuShareCount),
            cpu_share_level: cdktf.stringToTerraform(this._cpuShareLevel),
            datacenter_id: cdktf.stringToTerraform(this._datacenterId),
            efi_secure_boot_enabled: cdktf.booleanToTerraform(this._efiSecureBootEnabled),
            enable_disk_uuid: cdktf.booleanToTerraform(this._enableDiskUuid),
            enable_logging: cdktf.booleanToTerraform(this._enableLogging),
            ept_rvi_mode: cdktf.stringToTerraform(this._eptRviMode),
            extra_config: cdktf.hashMapper(cdktf.stringToTerraform)(this._extraConfig),
            firmware: cdktf.stringToTerraform(this._firmware),
            guest_id: cdktf.stringToTerraform(this._guestId),
            hardware_version: cdktf.numberToTerraform(this._hardwareVersion),
            hv_mode: cdktf.stringToTerraform(this._hvMode),
            id: cdktf.stringToTerraform(this._id),
            ide_controller_scan_count: cdktf.numberToTerraform(this._ideControllerScanCount),
            latency_sensitivity: cdktf.stringToTerraform(this._latencySensitivity),
            memory: cdktf.numberToTerraform(this._memory),
            memory_hot_add_enabled: cdktf.booleanToTerraform(this._memoryHotAddEnabled),
            memory_limit: cdktf.numberToTerraform(this._memoryLimit),
            memory_reservation: cdktf.numberToTerraform(this._memoryReservation),
            memory_share_count: cdktf.numberToTerraform(this._memoryShareCount),
            memory_share_level: cdktf.stringToTerraform(this._memoryShareLevel),
            name: cdktf.stringToTerraform(this._name),
            nested_hv_enabled: cdktf.booleanToTerraform(this._nestedHvEnabled),
            num_cores_per_socket: cdktf.numberToTerraform(this._numCoresPerSocket),
            num_cpus: cdktf.numberToTerraform(this._numCpus),
            replace_trigger: cdktf.stringToTerraform(this._replaceTrigger),
            run_tools_scripts_after_power_on: cdktf.booleanToTerraform(this._runToolsScriptsAfterPowerOn),
            run_tools_scripts_after_resume: cdktf.booleanToTerraform(this._runToolsScriptsAfterResume),
            run_tools_scripts_before_guest_reboot: cdktf.booleanToTerraform(this._runToolsScriptsBeforeGuestReboot),
            run_tools_scripts_before_guest_shutdown: cdktf.booleanToTerraform(this._runToolsScriptsBeforeGuestShutdown),
            run_tools_scripts_before_guest_standby: cdktf.booleanToTerraform(this._runToolsScriptsBeforeGuestStandby),
            sata_controller_scan_count: cdktf.numberToTerraform(this._sataControllerScanCount),
            scsi_controller_scan_count: cdktf.numberToTerraform(this._scsiControllerScanCount),
            storage_policy_id: cdktf.stringToTerraform(this._storagePolicyId),
            swap_placement_policy: cdktf.stringToTerraform(this._swapPlacementPolicy),
            sync_time_with_host: cdktf.booleanToTerraform(this._syncTimeWithHost),
            sync_time_with_host_periodically: cdktf.booleanToTerraform(this._syncTimeWithHostPeriodically),
            tools_upgrade_policy: cdktf.stringToTerraform(this._toolsUpgradePolicy),
            uuid: cdktf.stringToTerraform(this._uuid),
            vbs_enabled: cdktf.booleanToTerraform(this._vbsEnabled),
            vvtd_enabled: cdktf.booleanToTerraform(this._vvtdEnabled),
            vapp: dataVsphereVirtualMachineVappToTerraform(this._vapp.internalValue),
        };
    }
}
exports.DataVsphereVirtualMachine = DataVsphereVirtualMachine;
_f = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachine[_f] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachine", version: "0.0.4" };
// =================
// STATIC PROPERTIES
// =================
DataVsphereVirtualMachine.tfResourceType = "vsphere_virtual_machine";
//# sourceMappingURL=data:application/json;base64,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