"""Add UserFieldValue model

Revision ID: ac76d4c912eb
Revises: b530ce0d8bd9
Create Date: 2022-04-28 15:36:49.761231

"""
import sqlalchemy as sa
from alembic import op

import fief

# revision identifiers, used by Alembic.
revision = "ac76d4c912eb"
down_revision = "b530ce0d8bd9"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "fief_user_field_values",
        sa.Column("id", fief.models.generics.GUID(), nullable=False),
        sa.Column(
            "created_at",
            fief.models.generics.TIMESTAMPAware(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            fief.models.generics.TIMESTAMPAware(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column("value_string", sa.Text(), nullable=True),
        sa.Column("value_integer", sa.Integer(), nullable=True),
        sa.Column("value_boolean", sa.Boolean(), nullable=True),
        sa.Column("value_date", sa.Date(), nullable=True),
        sa.Column(
            "value_datetime",
            fief.models.generics.TIMESTAMPAware(timezone=True),
            nullable=True,
        ),
        sa.Column("value_json", sa.JSON(), nullable=True),
        sa.Column("user_id", fief.models.generics.GUID(), nullable=False),
        sa.Column("user_field_id", fief.models.generics.GUID(), nullable=False),
        sa.ForeignKeyConstraint(
            ["user_field_id"], ["fief_user_fields.id"], ondelete="CASCADE"
        ),
        sa.ForeignKeyConstraint(["user_id"], ["fief_users.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("user_field_id", "user_id"),
    )
    op.create_index(
        op.f("ix_fief_user_field_values_created_at"),
        "fief_user_field_values",
        ["created_at"],
        unique=False,
    )
    op.create_index(
        op.f("ix_fief_user_field_values_updated_at"),
        "fief_user_field_values",
        ["updated_at"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        op.f("ix_fief_user_field_values_updated_at"),
        table_name="fief_user_field_values",
    )
    op.drop_index(
        op.f("ix_fief_user_field_values_created_at"),
        table_name="fief_user_field_values",
    )
    op.drop_table("fief_user_field_values")
    # ### end Alembic commands ###
