# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations
from dataclasses import dataclass, field
from typing import Dict, Optional
from .base import NetworkManagerSettingsMixin


@dataclass
class VpnSettings(NetworkManagerSettingsMixin):
    """VPN Settings"""

    data: Optional[Dict[str, str]] = field(
        metadata={
            'dbus_name': 'data',
            'dbus_type': 'a{ss}',
        },
        default=None,
    )
    """Dictionary of key/value pairs of VPN plugin specific data.  Both keys
    and values must be strings."""
    persistent: Optional[bool] = field(
        metadata={
            'dbus_name': 'persistent',
            'dbus_type': 'b',
        },
        default=None,
    )
    """If the VPN service supports persistence, and this property is TRUE, the
    VPN will attempt to stay connected across link changes and outages,
    until explicitly disconnected."""
    secrets: Optional[Dict[str, str]] = field(
        metadata={
            'dbus_name': 'secrets',
            'dbus_type': 'a{ss}',
        },
        default=None,
    )
    """Dictionary of key/value pairs of VPN plugin specific secrets like
    passwords or private keys.  Both keys and values must be strings."""
    service_type: Optional[str] = field(
        metadata={
            'dbus_name': 'service-type',
            'dbus_type': 's',
        },
        default=None,
    )
    """D-Bus service name of the VPN plugin that this setting uses to connect
    to its network.  i.e. org.freedesktop.NetworkManager.vpnc for the
    vpnc plugin."""
    timeout: Optional[int] = field(
        metadata={
            'dbus_name': 'timeout',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Timeout for the VPN service to establish the connection. Some services
    may take quite a long time to connect. Value of 0 means a default
    timeout, which is 60 seconds (unless overridden by vpn.timeout in
    configuration file). Values greater than zero mean timeout in
    seconds."""
    user_name: Optional[str] = field(
        metadata={
            'dbus_name': 'user-name',
            'dbus_type': 's',
        },
        default=None,
    )
    """If the VPN connection requires a user name for authentication, that name
    should be provided here.  If the connection is available to more
    than one user, and the VPN requires each user to supply a different
    name, then leave this property empty.  If this property is empty,
    NetworkManager will automatically supply the username of the user
    which requested the VPN connection."""
