# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations
from dataclasses import dataclass, field
from typing import Any, List, Optional, Tuple
from .base import NetworkManagerSettingsMixin
from .datatypes import LinkWatchers


@dataclass
class TeamSettings(NetworkManagerSettingsMixin):
    """Teaming Settings"""

    config: Optional[str] = field(
        metadata={
            'dbus_name': 'config',
            'dbus_type': 's',
        },
        default=None,
    )
    """The JSON configuration for the team network interface.  The property
    should contain raw JSON configuration data suitable for teamd,
    because the value is passed directly to teamd. If not specified, the
    default configuration is used.  See man teamd.conf for the format
    details."""
    interface_name: Optional[str] = field(
        metadata={
            'dbus_name': 'interface-name',
            'dbus_type': 's',
        },
        default=None,
    )
    """Deprecated in favor of connection.interface-name, but can be used for
    backward-compatibility with older daemons, to set the team's
    interface name."""
    link_watchers: Optional[List[LinkWatchers]] = field(
        metadata={
            'dbus_name': 'link-watchers',
            'dbus_type': 'aa{sv}',
            'dbus_inner_class': LinkWatchers,
        },
        default=None,
    )
    """Link watchers configuration for the connection: each link watcher is
    defined by a dictionary, whose keys depend upon the selected link
    watcher. Available link watchers are 'ethtool', 'nsna_ping' and
    'arp_ping' and it is specified in the dictionary with the key
    'name'. Available keys are:   ethtool: 'delay-up', 'delay-down',
    'init-wait'; nsna_ping: 'init-wait', 'interval', 'missed-max',
    'target-host'; arp_ping: all the ones in nsna_ping and 'source-
    host', 'validate-active', 'validate-inactive', 'send-always'. See
    teamd.conf man for more details."""
    mcast_rejoin_count: Optional[int] = field(
        metadata={
            'dbus_name': 'mcast-rejoin-count',
            'dbus_type': 'i',
        },
        default=None,
    )
    """Corresponds to the teamd mcast_rejoin.count."""
    mcast_rejoin_interval: Optional[int] = field(
        metadata={
            'dbus_name': 'mcast-rejoin-interval',
            'dbus_type': 'i',
        },
        default=None,
    )
    """Corresponds to the teamd mcast_rejoin.interval."""
    notify_peers_count: Optional[int] = field(
        metadata={
            'dbus_name': 'notify-peers-count',
            'dbus_type': 'i',
        },
        default=None,
    )
    """Corresponds to the teamd notify_peers.count."""
    notify_peers_interval: Optional[int] = field(
        metadata={
            'dbus_name': 'notify-peers-interval',
            'dbus_type': 'i',
        },
        default=None,
    )
    """Corresponds to the teamd notify_peers.interval."""
    runner: Optional[str] = field(
        metadata={
            'dbus_name': 'runner',
            'dbus_type': 's',
        },
        default=None,
    )
    """Corresponds to the teamd runner.name. Permitted values are:
    "roundrobin", "broadcast", "activebackup", "loadbalance", "lacp",
    "random"."""
    runner_active: Optional[bool] = field(
        metadata={
            'dbus_name': 'runner-active',
            'dbus_type': 'b',
        },
        default=None,
    )
    """Corresponds to the teamd runner.active."""
    runner_agg_select_policy: Optional[str] = field(
        metadata={
            'dbus_name': 'runner-agg-select-policy',
            'dbus_type': 's',
        },
        default=None,
    )
    """Corresponds to the teamd runner.agg_select_policy."""
    runner_fast_rate: Optional[bool] = field(
        metadata={
            'dbus_name': 'runner-fast-rate',
            'dbus_type': 'b',
        },
        default=None,
    )
    """Corresponds to the teamd runner.fast_rate."""
    runner_hwaddr_policy: Optional[str] = field(
        metadata={
            'dbus_name': 'runner-hwaddr-policy',
            'dbus_type': 's',
        },
        default=None,
    )
    """Corresponds to the teamd runner.hwaddr_policy."""
    runner_min_ports: Optional[int] = field(
        metadata={
            'dbus_name': 'runner-min-ports',
            'dbus_type': 'i',
        },
        default=None,
    )
    """Corresponds to the teamd runner.min_ports."""
    runner_sys_prio: Optional[int] = field(
        metadata={
            'dbus_name': 'runner-sys-prio',
            'dbus_type': 'i',
        },
        default=None,
    )
    """Corresponds to the teamd runner.sys_prio."""
    runner_tx_balancer: Optional[str] = field(
        metadata={
            'dbus_name': 'runner-tx-balancer',
            'dbus_type': 's',
        },
        default=None,
    )
    """Corresponds to the teamd runner.tx_balancer.name."""
    runner_tx_balancer_interval: Optional[int] = field(
        metadata={
            'dbus_name': 'runner-tx-balancer-interval',
            'dbus_type': 'i',
        },
        default=None,
    )
    """Corresponds to the teamd runner.tx_balancer.interval."""
    runner_tx_hash: Optional[List[str]] = field(
        metadata={
            'dbus_name': 'runner-tx-hash',
            'dbus_type': 'as',
        },
        default=None,
    )
    """Corresponds to the teamd runner.tx_hash."""
