# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations
from dataclasses import dataclass, field
from typing import Any, List, Optional, Tuple
from .base import NetworkManagerSettingsMixin
from .datatypes import Qdiscs, Tfilters


@dataclass
class TcSettings(NetworkManagerSettingsMixin):
    """Linux Traffic Control Settings"""

    qdiscs: Optional[List[Qdiscs]] = field(
        metadata={
            'dbus_name': 'qdiscs',
            'dbus_type': 'aa{sv}',
            'dbus_inner_class': Qdiscs,
        },
        default=None,
    )
    """Array of TC queueing disciplines.

    When the "tc" setting is present, qdiscs from this property are
    applied upon activation. If the property is empty, all qdiscs are
    removed and the device will only have the default qdisc assigned by
    kernel according to the "net.core.default_qdisc" sysctl.

    If the "tc" setting is not present, NetworkManager doesn't touch the
    qdiscs present on the interface."""
    tfilters: Optional[List[Tfilters]] = field(
        metadata={
            'dbus_name': 'tfilters',
            'dbus_type': 'aa{sv}',
            'dbus_inner_class': Tfilters,
        },
        default=None,
    )
    """Array of TC traffic filters.

    When the "tc" setting is present, filters from this property are
    applied upon activation. If the property is empty, NetworkManager
    removes all the filters.

    If the "tc" setting is not present, NetworkManager doesn't touch the
    filters present on the interface."""
