# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations
from dataclasses import dataclass, field
from typing import Optional
from .base import NetworkManagerSettingsMixin


@dataclass
class SerialSettings(NetworkManagerSettingsMixin):
    """Serial Link Settings"""

    baud: Optional[int] = field(
        metadata={
            'dbus_name': 'baud',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Speed to use for communication over the serial port.  Note that this
    value usually has no effect for mobile broadband modems as they
    generally ignore speed settings and use the highest available speed."""
    bits: Optional[int] = field(
        metadata={
            'dbus_name': 'bits',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Byte-width of the serial communication. The 8 in "8n1" for example."""
    parity: Optional[int] = field(
        metadata={
            'dbus_name': 'parity',
            'dbus_type': 'y',
        },
        default=None,
    )
    """Parity setting of the serial port."""
    send_delay: Optional[int] = field(
        metadata={
            'dbus_name': 'send-delay',
            'dbus_type': 't',
        },
        default=None,
    )
    """Time to delay between each byte sent to the modem, in microseconds."""
    stopbits: Optional[int] = field(
        metadata={
            'dbus_name': 'stopbits',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Number of stop bits for communication on the serial port.  Either 1 or
    2. The 1 in "8n1" for example."""
