# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations
from dataclasses import dataclass, field
from typing import Optional
from .base import NetworkManagerSettingsMixin


@dataclass
class ProxySettings(NetworkManagerSettingsMixin):
    """WWW Proxy Settings"""

    browser_only: Optional[bool] = field(
        metadata={
            'dbus_name': 'browser-only',
            'dbus_type': 'b',
        },
        default=None,
    )
    """Whether the proxy configuration is for browser only."""
    method: Optional[int] = field(
        metadata={
            'dbus_name': 'method',
            'dbus_type': 'i',
        },
        default=None,
    )
    """Method for proxy configuration, Default is NM_SETTING_PROXY_METHOD_NONE
    (0)"""
    pac_script: Optional[str] = field(
        metadata={
            'dbus_name': 'pac-script',
            'dbus_type': 's',
        },
        default=None,
    )
    """PAC script for the connection. This is an UTF-8 encoded javascript code
    that defines a FindProxyForURL() function."""
    pac_url: Optional[str] = field(
        metadata={
            'dbus_name': 'pac-url',
            'dbus_type': 's',
        },
        default=None,
    )
    """PAC URL for obtaining PAC file."""
