# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations

from dataclasses import dataclass, field, fields
from typing import Any, Dict, Generator, Optional

from .base import NetworkManagerSettingsMixin
from .adsl import AdslSettings
from .bluetooth import BluetoothSettings
from .bond import BondSettings
from .bond_port import BondPortSettings
from .bridge import BridgeSettings
from .bridge_port import BridgePortSettings
from .cdma import CdmaSettings
from .connection import ConnectionSettings
from .dcb import DcbSettings
from .dummy import DummySettings
from .eapol import EapolSettings
from .ethernet import EthernetSettings
from .ethtool import EthtoolSettings
from .generic import GenericSettings
from .gsm import GsmSettings
from .hostname import HostnameSettings
from .infiniband import InfinibandSettings
from .ip_tunnel import IpTunnelSettings
from .ipv4 import Ipv4Settings
from .ipv6 import Ipv6Settings
from .lowpan import LowpanSettings
from .macsec import MacsecSettings
from .macvlan import MacvlanSettings
from .match import MatchSettings
from .olpc_mesh import OlpcMeshSettings
from .ovs_bridge import OvsBridgeSettings
from .ovs_dpdk import OvsDpdkSettings
from .ovs_external_ids import OvsExternalIdsSettings
from .ovs_interface import OvsInterfaceSettings
from .ovs_patch import OvsPatchSettings
from .ovs_port import OvsPortSettings
from .ppp import PppSettings
from .pppoe import PppoeSettings
from .proxy import ProxySettings
from .serial import SerialSettings
from .sriov import SriovSettings
from .tc import TcSettings
from .team import TeamSettings
from .team_port import TeamPortSettings
from .tun import TunSettings
from .user import UserSettings
from .veth import VethSettings
from .vlan import VlanSettings
from .vpn import VpnSettings
from .vrf import VrfSettings
from .vxlan import VxlanSettings
from .wifi_p2p import WifiP2PSettings
from .wimax import WimaxSettings
from .wireguard import WireguardSettings
from .wireless import WirelessSettings
from .wireless_security import WirelessSecuritySettings
from .wpan import WpanSettings
from ..types import NetworkManagerConnectionProperties, SettingsDict


@dataclass
class ConnectionProfile:
    """
    Connection profiles
    -------------------

    NetworkManager is based on a concept of connection profiles, most often
    referred to just as "connections". Connection profiles provide a network
    configuration. When NetworkManager activates a connection profile on a
    network device, the configuration will be applied and an active network
    connection will be established. Users are free to create as many
    connection profiles as they see fit. Thus they are flexible in having
    various network configurations for different networking needs:
    https://networkmanager.pages.freedesktop.org/NetworkManager/NetworkManager/nm-settings-dbus.html

    Connection profiles are handled by NetworkManager via a settings service
    and are exported on D-Bus (/org/freedesktop/NetworkManager/Settings/<num>)

    Definition of a connection profile:
    A specific, encapsulated, independent group of settings describing
    all the configuration required to connect to a specific network.

    It is referred to by a unique identifier called the UUID.
    A connection profile is tied to a one specific device type,
    but not necessarily a specific hardware device.

    A connection profile is composed of one or more Settings objects.

    Settings objects
    ----------------

    A group of related key/value pairs describing a specific piece
    of a Connection (profile). Keys are also referred to as properties.
    """
    # The list of the settings classes was generated by
    # tools/generate-settings-dataclasses-jinja.py which generates the
    # settings classes themselfes as well.
    # If possible, please make changes by also updating the script.

    # start of the generated list of settings classes
    adsl: Optional[AdslSettings] = field(
        metadata={'dbus_name': 'adsl',
                  'settings_class': AdslSettings},
        default=None,
    )
    bluetooth: Optional[BluetoothSettings] = field(
        metadata={'dbus_name': 'bluetooth',
                  'settings_class': BluetoothSettings},
        default=None,
    )
    bond: Optional[BondSettings] = field(
        metadata={'dbus_name': 'bond',
                  'settings_class': BondSettings},
        default=None,
    )
    bond_port: Optional[BondPortSettings] = field(
        metadata={'dbus_name': 'bond-port',
                  'settings_class': BondPortSettings},
        default=None,
    )
    bridge: Optional[BridgeSettings] = field(
        metadata={'dbus_name': 'bridge',
                  'settings_class': BridgeSettings},
        default=None,
    )
    bridge_port: Optional[BridgePortSettings] = field(
        metadata={'dbus_name': 'bridge-port',
                  'settings_class': BridgePortSettings},
        default=None,
    )
    cdma: Optional[CdmaSettings] = field(
        metadata={'dbus_name': 'cdma',
                  'settings_class': CdmaSettings},
        default=None,
    )
    connection: ConnectionSettings = field(
        metadata={'dbus_name': 'connection',
                  'settings_class': ConnectionSettings},
        default_factory=ConnectionSettings,
    )
    dcb: Optional[DcbSettings] = field(
        metadata={'dbus_name': 'dcb',
                  'settings_class': DcbSettings},
        default=None,
    )
    dummy: Optional[DummySettings] = field(
        metadata={'dbus_name': 'dummy',
                  'settings_class': DummySettings},
        default=None,
    )
    eapol: Optional[EapolSettings] = field(
        metadata={'dbus_name': '802-1x',
                  'settings_class': EapolSettings},
        default=None,
    )
    ethernet: Optional[EthernetSettings] = field(
        metadata={'dbus_name': '802-3-ethernet',
                  'settings_class': EthernetSettings},
        default=None,
    )
    ethtool: Optional[EthtoolSettings] = field(
        metadata={'dbus_name': 'ethtool',
                  'settings_class': EthtoolSettings},
        default=None,
    )
    generic: Optional[GenericSettings] = field(
        metadata={'dbus_name': 'generic',
                  'settings_class': GenericSettings},
        default=None,
    )
    gsm: Optional[GsmSettings] = field(
        metadata={'dbus_name': 'gsm',
                  'settings_class': GsmSettings},
        default=None,
    )
    hostname: Optional[HostnameSettings] = field(
        metadata={'dbus_name': 'hostname',
                  'settings_class': HostnameSettings},
        default=None,
    )
    infiniband: Optional[InfinibandSettings] = field(
        metadata={'dbus_name': 'infiniband',
                  'settings_class': InfinibandSettings},
        default=None,
    )
    ip_tunnel: Optional[IpTunnelSettings] = field(
        metadata={'dbus_name': 'ip-tunnel',
                  'settings_class': IpTunnelSettings},
        default=None,
    )
    ipv4: Optional[Ipv4Settings] = field(
        metadata={'dbus_name': 'ipv4',
                  'settings_class': Ipv4Settings},
        default=None,
    )
    ipv6: Optional[Ipv6Settings] = field(
        metadata={'dbus_name': 'ipv6',
                  'settings_class': Ipv6Settings},
        default=None,
    )
    lowpan: Optional[LowpanSettings] = field(
        metadata={'dbus_name': '6lowpan',
                  'settings_class': LowpanSettings},
        default=None,
    )
    macsec: Optional[MacsecSettings] = field(
        metadata={'dbus_name': 'macsec',
                  'settings_class': MacsecSettings},
        default=None,
    )
    macvlan: Optional[MacvlanSettings] = field(
        metadata={'dbus_name': 'macvlan',
                  'settings_class': MacvlanSettings},
        default=None,
    )
    match: Optional[MatchSettings] = field(
        metadata={'dbus_name': 'match',
                  'settings_class': MatchSettings},
        default=None,
    )
    olpc_mesh: Optional[OlpcMeshSettings] = field(
        metadata={'dbus_name': '802-11-olpc-mesh',
                  'settings_class': OlpcMeshSettings},
        default=None,
    )
    ovs_bridge: Optional[OvsBridgeSettings] = field(
        metadata={'dbus_name': 'ovs-bridge',
                  'settings_class': OvsBridgeSettings},
        default=None,
    )
    ovs_dpdk: Optional[OvsDpdkSettings] = field(
        metadata={'dbus_name': 'ovs-dpdk',
                  'settings_class': OvsDpdkSettings},
        default=None,
    )
    ovs_external_ids: Optional[OvsExternalIdsSettings] = field(
        metadata={'dbus_name': 'ovs-external-ids',
                  'settings_class': OvsExternalIdsSettings},
        default=None,
    )
    ovs_interface: Optional[OvsInterfaceSettings] = field(
        metadata={'dbus_name': 'ovs-interface',
                  'settings_class': OvsInterfaceSettings},
        default=None,
    )
    ovs_patch: Optional[OvsPatchSettings] = field(
        metadata={'dbus_name': 'ovs-patch',
                  'settings_class': OvsPatchSettings},
        default=None,
    )
    ovs_port: Optional[OvsPortSettings] = field(
        metadata={'dbus_name': 'ovs-port',
                  'settings_class': OvsPortSettings},
        default=None,
    )
    ppp: Optional[PppSettings] = field(
        metadata={'dbus_name': 'ppp',
                  'settings_class': PppSettings},
        default=None,
    )
    pppoe: Optional[PppoeSettings] = field(
        metadata={'dbus_name': 'pppoe',
                  'settings_class': PppoeSettings},
        default=None,
    )
    proxy: Optional[ProxySettings] = field(
        metadata={'dbus_name': 'proxy',
                  'settings_class': ProxySettings},
        default=None,
    )
    serial: Optional[SerialSettings] = field(
        metadata={'dbus_name': 'serial',
                  'settings_class': SerialSettings},
        default=None,
    )
    sriov: Optional[SriovSettings] = field(
        metadata={'dbus_name': 'sriov',
                  'settings_class': SriovSettings},
        default=None,
    )
    tc: Optional[TcSettings] = field(
        metadata={'dbus_name': 'tc',
                  'settings_class': TcSettings},
        default=None,
    )
    team: Optional[TeamSettings] = field(
        metadata={'dbus_name': 'team',
                  'settings_class': TeamSettings},
        default=None,
    )
    team_port: Optional[TeamPortSettings] = field(
        metadata={'dbus_name': 'team-port',
                  'settings_class': TeamPortSettings},
        default=None,
    )
    tun: Optional[TunSettings] = field(
        metadata={'dbus_name': 'tun',
                  'settings_class': TunSettings},
        default=None,
    )
    user: Optional[UserSettings] = field(
        metadata={'dbus_name': 'user',
                  'settings_class': UserSettings},
        default=None,
    )
    veth: Optional[VethSettings] = field(
        metadata={'dbus_name': 'veth',
                  'settings_class': VethSettings},
        default=None,
    )
    vlan: Optional[VlanSettings] = field(
        metadata={'dbus_name': 'vlan',
                  'settings_class': VlanSettings},
        default=None,
    )
    vpn: Optional[VpnSettings] = field(
        metadata={'dbus_name': 'vpn',
                  'settings_class': VpnSettings},
        default=None,
    )
    vrf: Optional[VrfSettings] = field(
        metadata={'dbus_name': 'vrf',
                  'settings_class': VrfSettings},
        default=None,
    )
    vxlan: Optional[VxlanSettings] = field(
        metadata={'dbus_name': 'vxlan',
                  'settings_class': VxlanSettings},
        default=None,
    )
    wifi_p2p: Optional[WifiP2PSettings] = field(
        metadata={'dbus_name': 'wifi-p2p',
                  'settings_class': WifiP2PSettings},
        default=None,
    )
    wimax: Optional[WimaxSettings] = field(
        metadata={'dbus_name': 'wimax',
                  'settings_class': WimaxSettings},
        default=None,
    )
    wireguard: Optional[WireguardSettings] = field(
        metadata={'dbus_name': 'wireguard',
                  'settings_class': WireguardSettings},
        default=None,
    )
    wireless: Optional[WirelessSettings] = field(
        metadata={'dbus_name': '802-11-wireless',
                  'settings_class': WirelessSettings},
        default=None,
    )
    wireless_security: Optional[WirelessSecuritySettings] = field(
        metadata={'dbus_name': '802-11-wireless-security',
                  'settings_class': WirelessSecuritySettings},
        default=None,
    )
    wpan: Optional[WpanSettings] = field(
        metadata={'dbus_name': 'wpan',
                  'settings_class': WpanSettings},
        default=None,
    )
    # end of the generated list of settings classes

    def to_dbus(self) -> NetworkManagerConnectionProperties:
        new_dict: NetworkManagerConnectionProperties = {}

        for x in fields(self):
            value = getattr(self, x.name)
            if value is None:
                continue

            new_dict[x.metadata['dbus_name']] = value.to_dbus()

        return new_dict

    def to_settings_dict(self, defaults: bool = False) -> SettingsDict:
        """Return a simple dictionary using the same key names like the dbus
        dict from to_dbus(), but without the dbus signatures returned by it.

        Contrary to dataclasses.asdict(), it provides the orignal dbus keys,
        e.g. with numerical prefixes like "802-11-", dashes, and "id"/"type".

        The key names provided are exactly as documented in these tables:
        https://networkmanager.dev/docs/api/latest/nm-settings-dbus.html

        param defaults: Whether properies with default values are returned.
        """
        new_dict = {}
        for x in fields(self):
            settings_class = getattr(self, x.name)
            if settings_class:
                settingsdomain_dict = settings_class.to_settings_dict(defaults)
                if settingsdomain_dict != {}:
                    new_dict[x.metadata['dbus_name']] = settingsdomain_dict
        return new_dict

    @property
    def dbus_name_to_settings_class(self) -> Dict[str, str]:
        return {f.metadata['dbus_name']: f.name
                for f in fields(self)}

    @classmethod
    def from_dbus(cls, dbus_dict: NetworkManagerConnectionProperties
                  ) -> ConnectionProfile:
        for domain in ("ipv4", "ipv6"):
            group = dbus_dict.get(domain, None)
            if group:
                for key in ("addresses", "routes"):
                    group.pop(key, None)
        try:
            unvarianted_options: Dict[str, Any] = {
                SETTING_DBUS_NAME_TO_NAME[k]: SETTING_TO_CLASS[k].from_dbus(v)
                for k, v in dbus_dict.items()}
        except KeyError as e:
            print(dbus_dict)
            raise e
        return cls(**unvarianted_options)

    @classmethod
    def from_settings_dict(
        cls, settings_dict: SettingsDict
    ) -> ConnectionProfile:
        """Return a ConnectionProfile created from a simple settings dict
        A simple settings dict uses the same keys as from_dbus() and to_dbus()
        but without the dbus variable signatures used by NetworkManader.py

        This means a simple settings dict does not use the underscore in keys
        like the attributes of this class have to use and use "id" and "type".
        """
        unvarianted_options: Dict[str, Any] = {
            SETTING_DBUS_NAME_TO_NAME[k]: SETTING_TO_CLASS[k].from_dict(v)
            for k, v in settings_dict.items()}
        return cls(**unvarianted_options)

    def update(self, other: ConnectionProfile) -> None:
        """Update this connection profile with the settings from the other.

        Similar to dict.update method.
        """
        for f in fields(other):
            settings_field_name = f.name
            other_settings = getattr(other, settings_field_name)

            if other_settings is None:
                continue

            my_settings = getattr(self, settings_field_name)

            if my_settings is None:
                setattr(self, settings_field_name, other_settings)
                continue

            for setting_field in fields(other_settings):
                setting_field_name = setting_field.name

                other_setting = getattr(other_settings, setting_field_name)

                if other_setting is None:
                    continue

                setattr(my_settings, setting_field_name, other_setting)

    def update_secrets_generator(
            self) -> Generator[str, ConnectionProfile, None]:
        for attr_name, value in vars(self).items():
            if value is None:
                continue

            if not isinstance(value, NetworkManagerSettingsMixin):
                continue

            secret_setting_name = value.secret_name

            if not secret_setting_name:
                continue

            secret_profile = yield secret_setting_name
            current_setting_secrets = getattr(secret_profile, attr_name)

            for secret_attribute in value.secret_fields_names:
                setattr(
                    value,
                    secret_attribute,
                    getattr(
                        current_setting_secrets,
                        secret_attribute,
                    ),
                )


SETTING_DBUS_NAME_TO_NAME: Dict[str, str] = {
    f.metadata['dbus_name']: f.name
    for f in fields(ConnectionProfile)
}

SETTING_TO_CLASS: Dict[str, NetworkManagerSettingsMixin] = {
    f.metadata['dbus_name']: f.metadata['settings_class']
    for f in fields(ConnectionProfile)
}
