# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations
from dataclasses import dataclass, field
from typing import Any, List, Optional, Tuple
from .base import NetworkManagerSettingsMixin
from .datatypes import Vlans


@dataclass
class BridgePortSettings(NetworkManagerSettingsMixin):
    """Bridge Port Settings"""

    hairpin_mode: Optional[bool] = field(
        metadata={
            'dbus_name': 'hairpin-mode',
            'dbus_type': 'b',
        },
        default=None,
    )
    """Enables or disables "hairpin mode" for the port, which allows frames to
    be sent back out through the port the frame was received on."""
    path_cost: Optional[int] = field(
        metadata={
            'dbus_name': 'path-cost',
            'dbus_type': 'u',
        },
        default=None,
    )
    """The Spanning Tree Protocol (STP) port cost for destinations via this
    port."""
    priority: Optional[int] = field(
        metadata={
            'dbus_name': 'priority',
            'dbus_type': 'u',
        },
        default=None,
    )
    """The Spanning Tree Protocol (STP) priority of this bridge port."""
    vlans: Optional[List[Vlans]] = field(
        metadata={
            'dbus_name': 'vlans',
            'dbus_type': 'aa{sv}',
            'dbus_inner_class': Vlans,
        },
        default=None,
    )
    """Array of bridge VLAN objects. In addition to the VLANs specified here,
    the port will also have the default-pvid VLAN configured on the
    bridge by the bridge.vlan-default-pvid property.

    In nmcli the VLAN list can be specified with the following syntax:

    $vid [pvid] [untagged] [, $vid [pvid] [untagged]]...

    where $vid is either a single id between 1 and 4094 or a range,
    represented as a couple of ids separated by a dash."""
