# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations
from dataclasses import dataclass, field
from typing import Dict, Optional
from .base import NetworkManagerSettingsMixin


@dataclass
class BondSettings(NetworkManagerSettingsMixin):
    """Bonding Settings"""

    interface_name: Optional[str] = field(
        metadata={
            'dbus_name': 'interface-name',
            'dbus_type': 's',
        },
        default=None,
    )
    """Deprecated in favor of connection.interface-name, but can be used for
    backward-compatibility with older daemons, to set the bond's
    interface name."""
    options: Optional[Dict[str, str]] = field(
        metadata={
            'dbus_name': 'options',
            'dbus_type': 'a{ss}',
        },
        default=None,
    )
    """Dictionary of key/value pairs of bonding options.  Both keys and values
    must be strings. Option names must contain only alphanumeric
    characters (ie, [a-zA-Z0-9])."""
