# SPDX-License-Identifier: LGPL-2.1-or-later

# Copyright (C) 2020, 2021 igo95862

# This file is part of python-sdbus

# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.

# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.

# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA
from __future__ import annotations

from .enums import (
    AccessPointCapabilities,
    BluetoothCapabilities,
    ConnectionFlags,
    ConnectionState,
    ConnectionStateFlags,
    ConnectionStateReason,
    ConnectionType,
    ConnectivityState,
    DeviceCapabilities,
    DeviceInterfaceFlags,
    DeviceMetered,
    DeviceState,
    DeviceStateReason,
    DeviceType,
    IpTunnelMode,
    ModemCapabilities,
    NetworkManagerConnectivityState,
    NetworkManagerState,
    SecretAgentCapabilities,
    VpnFailure,
    VpnState,
    WiFiOperationMode,
    WirelessCapabilities,
    WpaSecurityFlags,
)
from .exceptions import (
    NetworkManagerAlreadyAsleepOrAwakeError,
    NetworkManagerAlreadyEnabledOrDisabledError,
    NetworkManagerBaseError,
    NetworkManagerConnectionAlreadyActiveError,
    NetworkManagerConnectionNotActiveError,
    NetworkManagerConnectionNotAvailableError,
    NetworkManagerDependencyFailedError,
    NetworkManagerFailedError,
    NetworkManagerInvalidArgumentsError,
    NetworkManagerMissingPluginError,
    NetworkManagerPermissionDeniedError,
    NetworkManagerUnknownConnectionError,
    NetworkManagerUnknownDeviceError,
    NetworkManagerUnknownLogDomainError,
    NetworkManagerUnknownLogLevelError,
    NmAgentManagerFailedError,
    NmAgentManagerInvalidIdentifierError,
    NmAgentManagerNoSecretsError,
    NmAgentManagerNotRegisteredError,
    NmAgentManagerPermissionDeniedError,
    NmAgentManagerUserCanceledError,
    NmConnectionFailedError,
    NmConnectionInvalidPropertyError,
    NmConnectionInvalidSettingError,
    NmConnectionMissingPropertyError,
    NmConnectionMissingSettingError,
    NmConnectionPropertyNotFoundError,
    NmConnectionPropertyNotSecretError,
    NmConnectionSettingNotFoundError,
    NmDeviceCreationFailedError,
    NmDeviceFailedError,
    NmDeviceIncompatibleConnectionError,
    NmDeviceInvalidArgumentError,
    NmDeviceInvalidConnectionError,
    NmDeviceMissingDependenciesError,
    NmDeviceNotActiveError,
    NmDeviceNotAllowedError,
    NmDeviceNotSoftwareError,
    NmDeviceSpecificObjectNotFoundError,
    NmDeviceVersionIdMismatchError,
    NmSecretManagerAgentCanceledError,
    NmSecretManagerFailedError,
    NmSecretManagerInvalidConnectionError,
    NmSecretManagerNoSecretsError,
    NmSecretManagerPermissionDeniedError,
    NmSecretManagerUserCanceledError,
    NmSettingsFailedError,
    NmSettingsInvalidArgumentsError,
    NmSettingsInvalidConnectionError,
    NmSettingsInvalidHostnameError,
    NmSettingsNotSupportedError,
    NmSettingsPermissionDeniedError,
    NmSettingsReadOnlyConnectionError,
    NmSettingsUuidExistsError,
    NmVpnPluginAlreadyStartedError,
    NmVpnPluginAlreadyStoppedError,
    NmVpnPluginBadArgumentsError,
    NmVpnPluginFailedError,
    NmVpnPluginInteractiveNotSupportedError,
    NmVpnPluginInvalidConnectionError,
    NmVpnPluginLaunchFailedError,
    NmVpnPluginStartingInProgressError,
    NmVpnPluginStoppingInProgressError,
    NmVpnPluginWrongStateError,
)
from .interfaces_devices import (
    NetworkManagerDeviceBluetoothInterface,
    NetworkManagerDeviceBondInterface,
    NetworkManagerDeviceBridgeInterface,
    NetworkManagerDeviceGenericInterface,
    NetworkManagerDeviceInterface,
    NetworkManagerDeviceIPTunnelInterface,
    NetworkManagerDeviceLowpanInterface,
    NetworkManagerDeviceMacsecInterface,
    NetworkManagerDeviceMacvlanInterface,
    NetworkManagerDeviceModemInterface,
    NetworkManagerDeviceOlpcMeshInterface,
    NetworkManagerDeviceOvsBridgeInterface,
    NetworkManagerDeviceOvsPortInterface,
    NetworkManagerDeviceStatisticsInterface,
    NetworkManagerDeviceTeamInterface,
    NetworkManagerDeviceTunInterface,
    NetworkManagerDeviceVethInterface,
    NetworkManagerDeviceVlanInterface,
    NetworkManagerDeviceVrfInterface,
    NetworkManagerDeviceVxlanInterface,
    NetworkManagerDeviceWifiP2PInterface,
    NetworkManagerDeviceWiredInterface,
    NetworkManagerDeviceWireGuardInterface,
    NetworkManagerDeviceWirelessInterface,
    NetworkManagerPPPInterface,
)
from .interfaces_other import (
    NetworkManagerAccessPointInterface,
    NetworkManagerCheckpointInterface,
    NetworkManagerConnectionActiveInterface,
    NetworkManagerDHCP4ConfigInterface,
    NetworkManagerDHCP6ConfigInterface,
    NetworkManagerDnsManagerInterface,
    NetworkManagerInterface,
    NetworkManagerIP4ConfigInterface,
    NetworkManagerIP6ConfigInterface,
    NetworkManagerSecretAgentInterface,
    NetworkManagerSecretAgentManagerInterface,
    NetworkManagerSettingsConnectionInterface,
    NetworkManagerSettingsInterface,
    NetworkManagerVPNConnectionInterface,
    NetworkManagerVPNPluginInterface,
    NetworkManagerWifiP2PPeerInterface,
)
from .objects import (
    AccessPoint,
    ActiveConnection,
    ActiveVPNConnection,
    ConfigCheckpoint,
    DHCPv4Config,
    DHCPv6Config,
    IPv4Config,
    IPv6Config,
    NetworkConnectionSettings,
    NetworkDeviceBluetooth,
    NetworkDeviceBond,
    NetworkDeviceBridge,
    NetworkDeviceGeneric,
    NetworkDeviceIpTunnel,
    NetworkDeviceMacsec,
    NetworkDeviceMacvlan,
    NetworkDeviceModem,
    NetworkDeviceOlpcMesh,
    NetworkDeviceOpenVSwitchBridge,
    NetworkDeviceOpenVSwitchPort,
    NetworkDevicePPP,
    NetworkDeviceTeam,
    NetworkDeviceTun,
    NetworkDeviceVeth,
    NetworkDeviceVlan,
    NetworkDeviceVrf,
    NetworkDeviceVxlan,
    NetworkDeviceWifiP2P,
    NetworkDeviceWired,
    NetworkDeviceWireGuard,
    NetworkDeviceWireless,
    NetworkManager,
    NetworkManagerAgentManager,
    NetworkManagerDnsManager,
    NetworkManagerSettings,
    WiFiP2PPeer,
)
from .types import (
    NetworkManagerConnectionProperties,
    NetworkManagerSetting,
    NetworkManagerSettingsDomain,
    SettingsDict,
)

DEVICE_TYPE_TO_CLASS = {
    DeviceType.ETHERNET: NetworkDeviceWired,
    DeviceType.WIFI: NetworkDeviceWireless,
    DeviceType.BLUETOOTH: NetworkDeviceBluetooth,
    DeviceType.OLPC_MESH: NetworkDeviceOlpcMesh,
    DeviceType.VETH: NetworkDeviceVeth,
    DeviceType.WIREGUARD: NetworkDeviceWireGuard,
    DeviceType.PPP: NetworkDevicePPP,
    DeviceType.BRIDGE: NetworkDeviceBridge,
    DeviceType.MODEM: NetworkDeviceModem,
}


__all__ = (
    # .enums
    'AccessPointCapabilities',
    'BluetoothCapabilities',
    'ConnectionFlags',
    'ConnectionState',
    'ConnectionStateFlags',
    'ConnectionStateReason',
    'ConnectionType',
    'ConnectivityState',
    'DeviceCapabilities',
    'DeviceInterfaceFlags',
    'DeviceMetered',
    'DeviceState',
    'DeviceStateReason',
    'DeviceType',
    'IpTunnelMode',
    'ModemCapabilities',
    'NetworkManagerConnectivityState',
    'NetworkManagerState',
    'SecretAgentCapabilities',
    'VpnFailure',
    'VpnState',
    'WiFiOperationMode',
    'WirelessCapabilities',
    'WpaSecurityFlags',
    # .exceptions
    'NetworkManagerAlreadyAsleepOrAwakeError',
    'NetworkManagerAlreadyEnabledOrDisabledError',
    'NetworkManagerBaseError',
    'NetworkManagerConnectionAlreadyActiveError',
    'NetworkManagerConnectionNotActiveError',
    'NetworkManagerConnectionNotAvailableError',
    'NetworkManagerDependencyFailedError',
    'NetworkManagerFailedError',
    'NetworkManagerInvalidArgumentsError',
    'NetworkManagerMissingPluginError',
    'NetworkManagerPermissionDeniedError',
    'NetworkManagerUnknownConnectionError',
    'NetworkManagerUnknownDeviceError',
    'NetworkManagerUnknownLogDomainError',
    'NetworkManagerUnknownLogLevelError',
    'NmAgentManagerFailedError',
    'NmAgentManagerInvalidIdentifierError',
    'NmAgentManagerNoSecretsError',
    'NmAgentManagerNotRegisteredError',
    'NmAgentManagerPermissionDeniedError',
    'NmAgentManagerUserCanceledError',
    'NmConnectionFailedError',
    'NmConnectionInvalidPropertyError',
    'NmConnectionInvalidSettingError',
    'NmConnectionMissingPropertyError',
    'NmConnectionMissingSettingError',
    'NmConnectionPropertyNotFoundError',
    'NmConnectionPropertyNotSecretError',
    'NmConnectionSettingNotFoundError',
    'NmDeviceCreationFailedError',
    'NmDeviceFailedError',
    'NmDeviceIncompatibleConnectionError',
    'NmDeviceInvalidArgumentError',
    'NmDeviceInvalidConnectionError',
    'NmDeviceMissingDependenciesError',
    'NmDeviceNotActiveError',
    'NmDeviceNotAllowedError',
    'NmDeviceNotSoftwareError',
    'NmDeviceSpecificObjectNotFoundError',
    'NmDeviceVersionIdMismatchError',
    'NmSecretManagerAgentCanceledError',
    'NmSecretManagerFailedError',
    'NmSecretManagerInvalidConnectionError',
    'NmSecretManagerNoSecretsError',
    'NmSecretManagerPermissionDeniedError',
    'NmSecretManagerUserCanceledError',
    'NmSettingsFailedError',
    'NmSettingsInvalidArgumentsError',
    'NmSettingsInvalidConnectionError',
    'NmSettingsInvalidHostnameError',
    'NmSettingsNotSupportedError',
    'NmSettingsPermissionDeniedError',
    'NmSettingsReadOnlyConnectionError',
    'NmSettingsUuidExistsError',
    'NmVpnPluginAlreadyStartedError',
    'NmVpnPluginAlreadyStoppedError',
    'NmVpnPluginBadArgumentsError',
    'NmVpnPluginFailedError',
    'NmVpnPluginInteractiveNotSupportedError',
    'NmVpnPluginInvalidConnectionError',
    'NmVpnPluginLaunchFailedError',
    'NmVpnPluginStartingInProgressError',
    'NmVpnPluginStoppingInProgressError',
    'NmVpnPluginWrongStateError',
    # .interfaces_devices
    'NetworkManagerDeviceBluetoothInterface',
    'NetworkManagerDeviceBondInterface',
    'NetworkManagerDeviceBridgeInterface',
    'NetworkManagerDeviceGenericInterface',
    'NetworkManagerDeviceInterface',
    'NetworkManagerDeviceIPTunnelInterface',
    'NetworkManagerDeviceLowpanInterface',
    'NetworkManagerDeviceMacsecInterface',
    'NetworkManagerDeviceMacvlanInterface',
    'NetworkManagerDeviceModemInterface',
    'NetworkManagerDeviceOlpcMeshInterface',
    'NetworkManagerDeviceOvsBridgeInterface',
    'NetworkManagerDeviceOvsPortInterface',
    'NetworkManagerDeviceStatisticsInterface',
    'NetworkManagerDeviceTeamInterface',
    'NetworkManagerDeviceTunInterface',
    'NetworkManagerDeviceVethInterface',
    'NetworkManagerDeviceVlanInterface',
    'NetworkManagerDeviceVrfInterface',
    'NetworkManagerDeviceVxlanInterface',
    'NetworkManagerDeviceWifiP2PInterface',
    'NetworkManagerDeviceWiredInterface',
    'NetworkManagerDeviceWireGuardInterface',
    'NetworkManagerDeviceWirelessInterface',
    'NetworkManagerPPPInterface',
    # .interfaces_other
    'NetworkManagerAccessPointInterface',
    'NetworkManagerCheckpointInterface',
    'NetworkManagerConnectionActiveInterface',
    'NetworkManagerDHCP4ConfigInterface',
    'NetworkManagerDHCP6ConfigInterface',
    'NetworkManagerDnsManagerInterface',
    'NetworkManagerInterface',
    'NetworkManagerIP4ConfigInterface',
    'NetworkManagerIP6ConfigInterface',
    'NetworkManagerSecretAgentInterface',
    'NetworkManagerSecretAgentManagerInterface',
    'NetworkManagerSettingsConnectionInterface',
    'NetworkManagerSettingsInterface',
    'NetworkManagerVPNConnectionInterface',
    'NetworkManagerVPNPluginInterface',
    'NetworkManagerWifiP2PPeerInterface',
    # .objects
    'AccessPoint',
    'ActiveConnection',
    'ActiveVPNConnection',
    'ConfigCheckpoint',
    'DHCPv4Config',
    'DHCPv6Config',
    'IPv4Config',
    'IPv6Config',
    'NetworkConnectionSettings',
    'NetworkDeviceBluetooth',
    'NetworkDeviceBond',
    'NetworkDeviceBridge',
    'NetworkDeviceGeneric',
    'NetworkDeviceIpTunnel',
    'NetworkDeviceMacsec',
    'NetworkDeviceMacvlan',
    'NetworkDeviceModem',
    'NetworkDeviceOlpcMesh',
    'NetworkDeviceOpenVSwitchBridge',
    'NetworkDeviceOpenVSwitchPort',
    'NetworkDevicePPP',
    'NetworkDeviceTeam',
    'NetworkDeviceTun',
    'NetworkDeviceVeth',
    'NetworkDeviceVlan',
    'NetworkDeviceVrf',
    'NetworkDeviceVxlan',
    'NetworkDeviceWifiP2P',
    'NetworkDeviceWired',
    'NetworkDeviceWireGuard',
    'NetworkDeviceWireless',
    'NetworkManager',
    'NetworkManagerAgentManager',
    'NetworkManagerDnsManager',
    'NetworkManagerSettings',
    'WiFiP2PPeer',
    # .types
    'NetworkManagerConnectionProperties',
    'NetworkManagerSetting',
    'NetworkManagerSettingsDomain',
    'SettingsDict',

    'DEVICE_TYPE_TO_CLASS',
)
