# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations
from dataclasses import dataclass, field
from typing import Optional
from .base import NetworkManagerSettingsMixin


@dataclass
class WpanSettings(NetworkManagerSettingsMixin):
    """IEEE 802.15.4 (WPAN) MAC Settings"""

    channel: Optional[int] = field(
        metadata={
            'dbus_name': 'channel',
            'dbus_type': 'i',
        },
        default=None,
    )
    """IEEE 802.15.4 channel. A positive integer or -1, meaning "do not set,
    use whatever the device is already set to"."""
    mac_address: Optional[str] = field(
        metadata={
            'dbus_name': 'mac-address',
            'dbus_type': 's',
        },
        default=None,
    )
    """If specified, this connection will only apply to the IEEE 802.15.4
    (WPAN) MAC layer device whose permanent MAC address matches."""
    page: Optional[int] = field(
        metadata={
            'dbus_name': 'page',
            'dbus_type': 'i',
        },
        default=None,
    )
    """IEEE 802.15.4 channel page. A positive integer or -1, meaning "do not
    set, use whatever the device is already set to"."""
    pan_id: Optional[int] = field(
        metadata={
            'dbus_name': 'pan-id',
            'dbus_type': 'u',
        },
        default=None,
    )
    """IEEE 802.15.4 Personal Area Network (PAN) identifier."""
    short_address: Optional[int] = field(
        metadata={
            'dbus_name': 'short-address',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Short IEEE 802.15.4 address to be used within a restricted environment."""
