# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations
from dataclasses import dataclass, field
from typing import List, Optional
from .base import NetworkManagerSettingsMixin


@dataclass
class WirelessSecuritySettings(NetworkManagerSettingsMixin):
    """Wi-Fi Security Settings"""
    secret_fields_names = ['leap_password', 'psk']
    secret_name = '802-11-wireless-security'

    auth_alg: Optional[str] = field(
        metadata={
            'dbus_name': 'auth-alg',
            'dbus_type': 's',
        },
        default=None,
    )
    """When WEP is used (ie, key-mgmt = "none" or "ieee8021x") indicate the
    802.11 authentication algorithm required by the AP here.  One of
    "open" for Open System, "shared" for Shared Key, or "leap" for Cisco
    LEAP.  When using Cisco LEAP (ie, key-mgmt = "ieee8021x" and auth-
    alg = "leap") the "leap-username" and "leap-password" properties
    must be specified."""
    fils: Optional[int] = field(
        metadata={
            'dbus_name': 'fils',
            'dbus_type': 'i',
        },
        default=None,
    )
    """Indicates whether Fast Initial Link Setup (802.11ai) must be enabled for
    the connection.  One of NM_SETTING_WIRELESS_SECURITY_FILS_DEFAULT
    (0) (use global default value),
    NM_SETTING_WIRELESS_SECURITY_FILS_DISABLE (1) (disable FILS),
    NM_SETTING_WIRELESS_SECURITY_FILS_OPTIONAL (2) (enable FILS if the
    supplicant and the access point support it) or
    NM_SETTING_WIRELESS_SECURITY_FILS_REQUIRED (3) (enable FILS and fail
    if not supported).  When set to
    NM_SETTING_WIRELESS_SECURITY_FILS_DEFAULT (0) and no global default
    is set, FILS will be optionally enabled."""
    group: Optional[List[str]] = field(
        metadata={
            'dbus_name': 'group',
            'dbus_type': 'as',
        },
        default=None,
    )
    """A list of group/broadcast encryption algorithms which prevents
    connections to Wi-Fi networks that do not utilize one of the
    algorithms in the list.  For maximum compatibility leave this
    property empty.  Each list element may be one of "wep40", "wep104",
    "tkip", or "ccmp"."""
    key_mgmt: Optional[str] = field(
        metadata={
            'dbus_name': 'key-mgmt',
            'dbus_type': 's',
        },
        default=None,
    )
    """Key management used for the connection. One of "none" (WEP or no
    password protection), "ieee8021x" (Dynamic WEP), "owe"
    (Opportunistic Wireless Encryption), "wpa-psk" (WPA2 + WPA3
    personal), "sae" (WPA3 personal only), "wpa-eap" (WPA2 + WPA3
    enterprise) or "wpa-eap-suite-b-192" (WPA3 enterprise only).

    This property must be set for any Wi-Fi connection that uses
    security."""
    leap_password: Optional[str] = field(
        metadata={
            'dbus_name': 'leap-password',
            'dbus_type': 's',
        },
        default=None,
    )
    """The login password for legacy LEAP connections (ie, key-mgmt =
    "ieee8021x" and auth-alg = "leap")."""
    leap_password_flags: Optional[int] = field(
        metadata={
            'dbus_name': 'leap-password-flags',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Flags indicating how to handle the "leap-password" property."""
    leap_username: Optional[str] = field(
        metadata={
            'dbus_name': 'leap-username',
            'dbus_type': 's',
        },
        default=None,
    )
    """The login username for legacy LEAP connections (ie, key-mgmt =
    "ieee8021x" and auth-alg = "leap")."""
    pairwise: Optional[List[str]] = field(
        metadata={
            'dbus_name': 'pairwise',
            'dbus_type': 'as',
        },
        default=None,
    )
    """A list of pairwise encryption algorithms which prevents connections to
    Wi-Fi networks that do not utilize one of the algorithms in the
    list. For maximum compatibility leave this property empty.  Each
    list element may be one of "tkip" or "ccmp"."""
    pmf: Optional[int] = field(
        metadata={
            'dbus_name': 'pmf',
            'dbus_type': 'i',
        },
        default=None,
    )
    """Indicates whether Protected Management Frames (802.11w) must be enabled
    for the connection.  One of NM_SETTING_WIRELESS_SECURITY_PMF_DEFAULT
    (0) (use global default value),
    NM_SETTING_WIRELESS_SECURITY_PMF_DISABLE (1) (disable PMF),
    NM_SETTING_WIRELESS_SECURITY_PMF_OPTIONAL (2) (enable PMF if the
    supplicant and the access point support it) or
    NM_SETTING_WIRELESS_SECURITY_PMF_REQUIRED (3) (enable PMF and fail
    if not supported).  When set to
    NM_SETTING_WIRELESS_SECURITY_PMF_DEFAULT (0) and no global default
    is set, PMF will be optionally enabled."""
    proto: Optional[List[str]] = field(
        metadata={
            'dbus_name': 'proto',
            'dbus_type': 'as',
        },
        default=None,
    )
    """List of strings specifying the allowed WPA protocol versions to use.
    Each element may be one "wpa" (allow WPA) or "rsn" (allow WPA2/RSN).
    If not specified, both WPA and RSN connections are allowed."""
    psk: Optional[str] = field(
        metadata={
            'dbus_name': 'psk',
            'dbus_type': 's',
        },
        default=None,
    )
    """Pre-Shared-Key for WPA networks. For WPA-PSK, it's either an ASCII
    passphrase of 8 to 63 characters that is (as specified in the
    802.11i standard) hashed to derive the actual key, or the key in
    form of 64 hexadecimal character. The WPA3-Personal networks use a
    passphrase of any length for SAE authentication."""
    psk_flags: Optional[int] = field(
        metadata={
            'dbus_name': 'psk-flags',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Flags indicating how to handle the "psk" property."""
    wep_key_flags: Optional[int] = field(
        metadata={
            'dbus_name': 'wep-key-flags',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Flags indicating how to handle the "wep-key0", "wep-key1", "wep-key2",
    and "wep-key3" properties."""
    wep_key_type: Optional[int] = field(
        metadata={
            'dbus_name': 'wep-key-type',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Controls the interpretation of WEP keys.  Allowed values are
    NM_WEP_KEY_TYPE_KEY (1), in which case the key is either a 10- or
    26-character hexadecimal string, or a 5- or 13-character ASCII
    password; or NM_WEP_KEY_TYPE_PASSPHRASE (2), in which case the
    passphrase is provided as a string and will be hashed using the de-
    facto MD5 method to derive the actual WEP key."""
    wep_key0: Optional[str] = field(
        metadata={
            'dbus_name': 'wep-key0',
            'dbus_type': 's',
        },
        default=None,
    )
    """Index 0 WEP key.  This is the WEP key used in most networks.  See the
    "wep-key-type" property for a description of how this key is
    interpreted."""
    wep_key1: Optional[str] = field(
        metadata={
            'dbus_name': 'wep-key1',
            'dbus_type': 's',
        },
        default=None,
    )
    """Index 1 WEP key.  This WEP index is not used by most networks.  See the
    "wep-key-type" property for a description of how this key is
    interpreted."""
    wep_key2: Optional[str] = field(
        metadata={
            'dbus_name': 'wep-key2',
            'dbus_type': 's',
        },
        default=None,
    )
    """Index 2 WEP key.  This WEP index is not used by most networks.  See the
    "wep-key-type" property for a description of how this key is
    interpreted."""
    wep_key3: Optional[str] = field(
        metadata={
            'dbus_name': 'wep-key3',
            'dbus_type': 's',
        },
        default=None,
    )
    """Index 3 WEP key.  This WEP index is not used by most networks.  See the
    "wep-key-type" property for a description of how this key is
    interpreted."""
    wep_tx_keyidx: Optional[int] = field(
        metadata={
            'dbus_name': 'wep-tx-keyidx',
            'dbus_type': 'u',
        },
        default=None,
    )
    """When static WEP is used (ie, key-mgmt = "none") and a non-default WEP
    key index is used by the AP, put that WEP key index here.  Valid
    values are 0 (default key) through 3.  Note that some consumer
    access points (like the Linksys WRT54G) number the keys 1 - 4."""
    wps_method: Optional[int] = field(
        metadata={
            'dbus_name': 'wps-method',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Flags indicating which mode of WPS is to be used if any.

    There's little point in changing the default setting as
    NetworkManager will automatically determine whether it's feasible to
    start WPS enrollment from the Access Point capabilities.

    WPS can be disabled by setting this property to a value of 1."""
