# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations
from dataclasses import dataclass, field
from typing import List, Optional
from .base import NetworkManagerSettingsMixin


@dataclass
class WirelessSettings(NetworkManagerSettingsMixin):
    """Wi-Fi Settings"""

    ap_isolation: Optional[int] = field(
        metadata={
            'dbus_name': 'ap-isolation',
            'dbus_type': 'i',
        },
        default=None,
    )
    """Configures AP isolation, which prevents communication between wireless
    devices connected to this AP. This property can be set to a value
    different from NM_TERNARY_DEFAULT (-1) only when the interface is
    configured in AP mode.

    If set to NM_TERNARY_TRUE (1), devices are not able to communicate
    with each other. This increases security because it protects devices
    against attacks from other clients in the network. At the same time,
    it prevents devices to access resources on the same wireless
    networks as file shares, printers, etc.

    If set to NM_TERNARY_FALSE (0), devices can talk to each other.

    When set to NM_TERNARY_DEFAULT (-1), the global default is used; in
    case the global default is unspecified it is assumed to be
    NM_TERNARY_FALSE (0)."""
    assigned_mac_address: Optional[str] = field(
        metadata={
            'dbus_name': 'assigned-mac-address',
            'dbus_type': 's',
        },
        default=None,
    )
    """The new field for the cloned MAC address. It can be either a hardware
    address in ASCII representation, or one of the special values
    "preserve", "permanent", "random" or "stable". This field replaces
    the deprecated "cloned-mac-address" on D-Bus, which can only contain
    explicit hardware addresses. Note that this property only exists in
    D-Bus API. libnm and nmcli continue to call this property "cloned-
    mac-address"."""
    band: Optional[str] = field(
        metadata={
            'dbus_name': 'band',
            'dbus_type': 's',
        },
        default=None,
    )
    """802.11 frequency band of the network.  One of "a" for 5GHz 802.11a or
    "bg" for 2.4GHz 802.11.  This will lock associations to the Wi-Fi
    network to the specific band, i.e. if "a" is specified, the device
    will not associate with the same network in the 2.4GHz band even if
    the network's settings are compatible.  This setting depends on
    specific driver capability and may not work with all drivers."""
    bssid: Optional[bytes] = field(
        metadata={
            'dbus_name': 'bssid',
            'dbus_type': 'ay',
        },
        default=None,
    )
    """If specified, directs the device to only associate with the given access
    point.  This capability is highly driver dependent and not supported
    by all devices.  Note: this property does not control the BSSID used
    when creating an Ad-Hoc network and is unlikely to in the future.

    Locking a client profile to a certain BSSID will prevent roaming and
    also disable background scanning. That can be useful, if there is
    only one access point for the SSID."""
    channel: Optional[int] = field(
        metadata={
            'dbus_name': 'channel',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Wireless channel to use for the Wi-Fi connection.  The device will only
    join (or create for Ad-Hoc networks) a Wi-Fi network on the
    specified channel.  Because channel numbers overlap between bands,
    this property also requires the "band" property to be set."""
    cloned_mac_address: Optional[bytes] = field(
        metadata={
            'dbus_name': 'cloned-mac-address',
            'dbus_type': 'ay',
        },
        default=None,
    )
    """If specified, request that the device use this MAC address instead. This
    is known as MAC cloning or spoofing.

    Beside explicitly specifying a MAC address, the special values
    "preserve", "permanent", "random" and "stable" are supported.
    "preserve" means not to touch the MAC address on activation.
    "permanent" means to use the permanent hardware address of the
    device. "random" creates a random MAC address on each connect.
    "stable" creates a hashed MAC address based on connection.stable-id
    and a machine dependent key.

    If unspecified, the value can be overwritten via global defaults,
    see manual of NetworkManager.conf. If still unspecified, it defaults
    to "preserve" (older versions of NetworkManager may use a different
    default value).

    On D-Bus, this field is expressed as "assigned-mac-address" or the
    deprecated "cloned-mac-address"."""
    generate_mac_address_mask: Optional[str] = field(
        metadata={
            'dbus_name': 'generate-mac-address-mask',
            'dbus_type': 's',
        },
        default=None,
    )
    """With "cloned-mac-address" setting "random" or "stable", by default all
    bits of the MAC address are scrambled and a locally-administered,
    unicast MAC address is created. This property allows to specify that
    certain bits are fixed. Note that the least significant bit of the
    first MAC address will always be unset to create a unicast MAC
    address.

    If the property is NULL, it is eligible to be overwritten by a
    default connection setting. If the value is still NULL or an empty
    string, the default is to create a locally-administered, unicast MAC
    address.

    If the value contains one MAC address, this address is used as mask.
    The set bits of the mask are to be filled with the current MAC
    address of the device, while the unset bits are subject to
    randomization. Setting "FE:FF:FF:00:00:00" means to preserve the OUI
    of the current MAC address and only randomize the lower 3 bytes
    using the "random" or "stable" algorithm.

    If the value contains one additional MAC address after the mask,
    this address is used instead of the current MAC address to fill the
    bits that shall not be randomized. For example, a value of
    "FE:FF:FF:00:00:00 68:F7:28:00:00:00" will set the OUI of the MAC
    address to 68:F7:28, while the lower bits are randomized. A value of
    "02:00:00:00:00:00 00:00:00:00:00:00" will create a fully scrambled
    globally-administered, burned-in MAC address.

    If the value contains more than one additional MAC addresses, one of
    them is chosen randomly. For example, "02:00:00:00:00:00
    00:00:00:00:00:00 02:00:00:00:00:00" will create a fully scrambled
    MAC address, randomly locally or globally administered."""
    hidden: Optional[bool] = field(
        metadata={
            'dbus_name': 'hidden',
            'dbus_type': 'b',
        },
        default=None,
    )
    """If TRUE, indicates that the network is a non-broadcasting network that
    hides its SSID. This works both in infrastructure and AP mode.

    In infrastructure mode, various workarounds are used for a more
    reliable discovery of hidden networks, such as probe-scanning the
    SSID.  However, these workarounds expose inherent insecurities with
    hidden SSID networks, and thus hidden SSID networks should be used
    with caution.

    In AP mode, the created network does not broadcast its SSID.

    Note that marking the network as hidden may be a privacy issue for
    you (in infrastructure mode) or client stations (in AP mode), as the
    explicit probe-scans are distinctly recognizable on the air."""
    mac_address: Optional[bytes] = field(
        metadata={
            'dbus_name': 'mac-address',
            'dbus_type': 'ay',
        },
        default=None,
    )
    """If specified, this connection will only apply to the Wi-Fi device whose
    permanent MAC address matches. This property does not change the MAC
    address of the device (i.e. MAC spoofing)."""
    mac_address_blacklist: Optional[List[str]] = field(
        metadata={
            'dbus_name': 'mac-address-blacklist',
            'dbus_type': 'as',
        },
        default=None,
    )
    """A list of permanent MAC addresses of Wi-Fi devices to which this
    connection should never apply.  Each MAC address should be given in
    the standard hex-digits-and-colons notation (eg
    "00:11:22:33:44:55")."""
    mac_address_randomization: Optional[int] = field(
        metadata={
            'dbus_name': 'mac-address-randomization',
            'dbus_type': 'u',
        },
        default=None,
    )
    """One of NM_SETTING_MAC_RANDOMIZATION_DEFAULT (0) (never randomize unless
    the user has set a global default to randomize and the supplicant
    supports randomization),  NM_SETTING_MAC_RANDOMIZATION_NEVER (1)
    (never randomize the MAC address), or
    NM_SETTING_MAC_RANDOMIZATION_ALWAYS (2) (always randomize the MAC
    address)."""
    mode: Optional[str] = field(
        metadata={
            'dbus_name': 'mode',
            'dbus_type': 's',
        },
        default=None,
    )
    """Wi-Fi network mode; one of "infrastructure", "mesh", "adhoc" or "ap".
    If blank, infrastructure is assumed."""
    mtu: Optional[int] = field(
        metadata={
            'dbus_name': 'mtu',
            'dbus_type': 'u',
        },
        default=None,
    )
    """If non-zero, only transmit packets of the specified size or smaller,
    breaking larger packets up into multiple Ethernet frames."""
    powersave: Optional[int] = field(
        metadata={
            'dbus_name': 'powersave',
            'dbus_type': 'u',
        },
        default=None,
    )
    """One of NM_SETTING_WIRELESS_POWERSAVE_DISABLE (2) (disable Wi-Fi power
    saving), NM_SETTING_WIRELESS_POWERSAVE_ENABLE (3) (enable Wi-Fi
    power saving), NM_SETTING_WIRELESS_POWERSAVE_IGNORE (1) (don't touch
    currently configure setting) or
    NM_SETTING_WIRELESS_POWERSAVE_DEFAULT (0) (use the globally
    configured value). All other values are reserved."""
    rate: Optional[int] = field(
        metadata={
            'dbus_name': 'rate',
            'dbus_type': 'u',
        },
        default=None,
    )
    """If non-zero, directs the device to only use the specified bitrate for
    communication with the access point.  Units are in Kb/s, ie 5500 =
    5.5 Mbit/s.  This property is highly driver dependent and not all
    devices support setting a static bitrate."""
    seen_bssids: Optional[List[str]] = field(
        metadata={
            'dbus_name': 'seen-bssids',
            'dbus_type': 'as',
        },
        default=None,
    )
    """A list of BSSIDs (each BSSID formatted as a MAC address like
    "00:11:22:33:44:55") that have been detected as part of the Wi-Fi
    network.  NetworkManager internally tracks previously seen BSSIDs.
    The property is only meant for reading and reflects the BSSID list
    of NetworkManager. The changes you make to this property will not be
    preserved."""
    ssid: Optional[bytes] = field(
        metadata={
            'dbus_name': 'ssid',
            'dbus_type': 'ay',
        },
        default=None,
    )
    """SSID of the Wi-Fi network. Must be specified."""
    tx_power: Optional[int] = field(
        metadata={
            'dbus_name': 'tx-power',
            'dbus_type': 'u',
        },
        default=None,
    )
    """If non-zero, directs the device to use the specified transmit power.
    Units are dBm.  This property is highly driver dependent and not all
    devices support setting a static transmit power."""
    wake_on_wlan: Optional[int] = field(
        metadata={
            'dbus_name': 'wake-on-wlan',
            'dbus_type': 'u',
        },
        default=None,
    )
    """The NMSettingWirelessWakeOnWLan options to enable. Not all devices
    support all options. May be any combination of
    NM_SETTING_WIRELESS_WAKE_ON_WLAN_ANY (0x2),
    NM_SETTING_WIRELESS_WAKE_ON_WLAN_DISCONNECT (0x4),
    NM_SETTING_WIRELESS_WAKE_ON_WLAN_MAGIC (0x8),
    NM_SETTING_WIRELESS_WAKE_ON_WLAN_GTK_REKEY_FAILURE (0x10),
    NM_SETTING_WIRELESS_WAKE_ON_WLAN_EAP_IDENTITY_REQUEST (0x20),
    NM_SETTING_WIRELESS_WAKE_ON_WLAN_4WAY_HANDSHAKE (0x40),
    NM_SETTING_WIRELESS_WAKE_ON_WLAN_RFKILL_RELEASE (0x80),
    NM_SETTING_WIRELESS_WAKE_ON_WLAN_TCP (0x100) or the special values
    NM_SETTING_WIRELESS_WAKE_ON_WLAN_DEFAULT (0x1) (to use global
    settings) and NM_SETTING_WIRELESS_WAKE_ON_WLAN_IGNORE (0x8000) (to
    disable management of Wake-on-LAN in NetworkManager)."""
