# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations
from dataclasses import dataclass, field
from typing import Optional
from .base import NetworkManagerSettingsMixin


@dataclass
class VxlanSettings(NetworkManagerSettingsMixin):
    """VXLAN Settings"""

    ageing: Optional[int] = field(
        metadata={
            'dbus_name': 'ageing',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Specifies the lifetime in seconds of FDB entries learnt by the kernel."""
    destination_port: Optional[int] = field(
        metadata={
            'dbus_name': 'destination-port',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Specifies the UDP destination port to communicate to the remote VXLAN
    tunnel endpoint."""
    vxlan_id: Optional[int] = field(
        metadata={
            'dbus_name': 'id',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Specifies the VXLAN Network Identifier (or VXLAN Segment Identifier) to
    use."""
    l2_miss: Optional[bool] = field(
        metadata={
            'dbus_name': 'l2-miss',
            'dbus_type': 'b',
        },
        default=None,
    )
    """Specifies whether netlink LL ADDR miss notifications are generated."""
    l3_miss: Optional[bool] = field(
        metadata={
            'dbus_name': 'l3-miss',
            'dbus_type': 'b',
        },
        default=None,
    )
    """Specifies whether netlink IP ADDR miss notifications are generated."""
    learning: Optional[bool] = field(
        metadata={
            'dbus_name': 'learning',
            'dbus_type': 'b',
        },
        default=None,
    )
    """Specifies whether unknown source link layer addresses and IP addresses
    are entered into the VXLAN device forwarding database."""
    limit: Optional[int] = field(
        metadata={
            'dbus_name': 'limit',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Specifies the maximum number of FDB entries. A value of zero means that
    the kernel will store unlimited entries."""
    local: Optional[str] = field(
        metadata={
            'dbus_name': 'local',
            'dbus_type': 's',
        },
        default=None,
    )
    """If given, specifies the source IP address to use in outgoing packets."""
    parent: Optional[str] = field(
        metadata={
            'dbus_name': 'parent',
            'dbus_type': 's',
        },
        default=None,
    )
    """If given, specifies the parent interface name or parent connection UUID."""
    proxy: Optional[bool] = field(
        metadata={
            'dbus_name': 'proxy',
            'dbus_type': 'b',
        },
        default=None,
    )
    """Specifies whether ARP proxy is turned on."""
    remote: Optional[str] = field(
        metadata={
            'dbus_name': 'remote',
            'dbus_type': 's',
        },
        default=None,
    )
    """Specifies the unicast destination IP address to use in outgoing packets
    when the destination link layer address is not known in the VXLAN
    device forwarding database, or the multicast IP address to join."""
    rsc: Optional[bool] = field(
        metadata={
            'dbus_name': 'rsc',
            'dbus_type': 'b',
        },
        default=None,
    )
    """Specifies whether route short circuit is turned on."""
    source_port_max: Optional[int] = field(
        metadata={
            'dbus_name': 'source-port-max',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Specifies the maximum UDP source port to communicate to the remote VXLAN
    tunnel endpoint."""
    source_port_min: Optional[int] = field(
        metadata={
            'dbus_name': 'source-port-min',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Specifies the minimum UDP source port to communicate to the remote VXLAN
    tunnel endpoint."""
    tos: Optional[int] = field(
        metadata={
            'dbus_name': 'tos',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Specifies the TOS value to use in outgoing packets."""
    ttl: Optional[int] = field(
        metadata={
            'dbus_name': 'ttl',
            'dbus_type': 'u',
        },
        default=None,
    )
    """Specifies the time-to-live value to use in outgoing packets."""
