# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations
from dataclasses import dataclass, field
from typing import List, Optional
from .base import NetworkManagerSettingsMixin


@dataclass
class VlanSettings(NetworkManagerSettingsMixin):
    """VLAN Settings"""

    egress_priority_map: Optional[List[str]] = field(
        metadata={
            'dbus_name': 'egress-priority-map',
            'dbus_type': 'as',
        },
        default=None,
    )
    """For outgoing packets, a list of mappings from Linux SKB priorities to
    802.1p priorities.  The mapping is given in the format "from:to"
    where both "from" and "to" are unsigned integers, ie "7:3"."""
    flags: Optional[int] = field(
        metadata={
            'dbus_name': 'flags',
            'dbus_type': 'u',
        },
        default=None,
    )
    """One or more flags which control the behavior and features of the VLAN
    interface.  Flags include NM_VLAN_FLAG_REORDER_HEADERS (0x1)
    (reordering of output packet headers), NM_VLAN_FLAG_GVRP (0x2) (use
    of the GVRP protocol), and NM_VLAN_FLAG_LOOSE_BINDING (0x4) (loose
    binding of the interface to its master device's operating state).
    NM_VLAN_FLAG_MVRP (0x8) (use of the MVRP protocol).

    The default value of this property is NM_VLAN_FLAG_REORDER_HEADERS,
    but it used to be 0. To preserve backward compatibility, the
    default-value in the D-Bus API continues to be 0 and a missing
    property on D-Bus is still considered as 0."""
    vlan_id: Optional[int] = field(
        metadata={
            'dbus_name': 'id',
            'dbus_type': 'u',
        },
        default=None,
    )
    """The VLAN identifier that the interface created by this connection should
    be assigned. The valid range is from 0 to 4094, without the reserved
    id 4095."""
    ingress_priority_map: Optional[List[str]] = field(
        metadata={
            'dbus_name': 'ingress-priority-map',
            'dbus_type': 'as',
        },
        default=None,
    )
    """For incoming packets, a list of mappings from 802.1p priorities to Linux
    SKB priorities.  The mapping is given in the format "from:to" where
    both "from" and "to" are unsigned integers, ie "7:3"."""
    interface_name: Optional[str] = field(
        metadata={
            'dbus_name': 'interface-name',
            'dbus_type': 's',
        },
        default=None,
    )
    """Deprecated in favor of connection.interface-name, but can be used for
    backward-compatibility with older daemons, to set the vlan's
    interface name."""
    parent: Optional[str] = field(
        metadata={
            'dbus_name': 'parent',
            'dbus_type': 's',
        },
        default=None,
    )
    """If given, specifies the parent interface name or parent connection UUID
    from which this VLAN interface should be created.  If this property
    is not specified, the connection must contain an "802-3-ethernet"
    setting with a "mac-address" property."""
