# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations
from dataclasses import dataclass, field
from typing import Any, List, Optional, Tuple
from .base import NetworkManagerSettingsMixin
from .datatypes import LinkWatchers


@dataclass
class TeamPortSettings(NetworkManagerSettingsMixin):
    """Team Port Settings"""

    config: Optional[str] = field(
        metadata={
            'dbus_name': 'config',
            'dbus_type': 's',
        },
        default=None,
    )
    """The JSON configuration for the team port. The property should contain
    raw JSON configuration data suitable for teamd, because the value is
    passed directly to teamd. If not specified, the default
    configuration is used. See man teamd.conf for the format details."""
    lacp_key: Optional[int] = field(
        metadata={
            'dbus_name': 'lacp-key',
            'dbus_type': 'i',
        },
        default=None,
    )
    """Corresponds to the teamd ports.PORTIFNAME.lacp_key."""
    lacp_prio: Optional[int] = field(
        metadata={
            'dbus_name': 'lacp-prio',
            'dbus_type': 'i',
        },
        default=None,
    )
    """Corresponds to the teamd ports.PORTIFNAME.lacp_prio."""
    link_watchers: Optional[List[LinkWatchers]] = field(
        metadata={
            'dbus_name': 'link-watchers',
            'dbus_type': 'aa{sv}',
            'dbus_inner_class': LinkWatchers,
        },
        default=None,
    )
    """Link watchers configuration for the connection: each link watcher is
    defined by a dictionary, whose keys depend upon the selected link
    watcher. Available link watchers are 'ethtool', 'nsna_ping' and
    'arp_ping' and it is specified in the dictionary with the key
    'name'. Available keys are:   ethtool: 'delay-up', 'delay-down',
    'init-wait'; nsna_ping: 'init-wait', 'interval', 'missed-max',
    'target-host'; arp_ping: all the ones in nsna_ping and 'source-
    host', 'validate-active', 'validate-inactive', 'send-always'. See
    teamd.conf man for more details."""
    prio: Optional[int] = field(
        metadata={
            'dbus_name': 'prio',
            'dbus_type': 'i',
        },
        default=None,
    )
    """Corresponds to the teamd ports.PORTIFNAME.prio."""
    queue_id: Optional[int] = field(
        metadata={
            'dbus_name': 'queue-id',
            'dbus_type': 'i',
        },
        default=None,
    )
    """Corresponds to the teamd ports.PORTIFNAME.queue_id. When set to -1 means
    the parameter is skipped from the json config."""
    sticky: Optional[bool] = field(
        metadata={
            'dbus_name': 'sticky',
            'dbus_type': 'b',
        },
        default=None,
    )
    """Corresponds to the teamd ports.PORTIFNAME.sticky."""
