# SPDX-License-Identifier: LGPL-2.1-or-later
# This file was generated by tools/generate-settings-dataclasses-jinja.py,
# if possible, please make changes by also updating the script.
from __future__ import annotations
from dataclasses import dataclass, field
from typing import Any, List, Optional, Tuple
from .base import NetworkManagerSettingsMixin
from .datatypes import Vfs


@dataclass
class SriovSettings(NetworkManagerSettingsMixin):
    """SR-IOV settings"""

    autoprobe_drivers: Optional[int] = field(
        metadata={
            'dbus_name': 'autoprobe-drivers',
            'dbus_type': 'i',
        },
        default=None,
    )
    """Whether to autoprobe virtual functions by a compatible driver.

    If set to NM_TERNARY_TRUE (1), the kernel will try to bind VFs to a
    compatible driver and if this succeeds a new network interface will
    be instantiated for each VF.

    If set to NM_TERNARY_FALSE (0), VFs will not be claimed and no
    network interfaces will be created for them.

    When set to NM_TERNARY_DEFAULT (-1), the global default is used; in
    case the global default is unspecified it is assumed to be
    NM_TERNARY_TRUE (1)."""
    total_vfs: Optional[int] = field(
        metadata={
            'dbus_name': 'total-vfs',
            'dbus_type': 'u',
        },
        default=None,
    )
    """The total number of virtual functions to create.

    Note that when the sriov setting is present NetworkManager enforces
    the number of virtual functions on the interface (also when it is
    zero) during activation and resets it upon deactivation. To prevent
    any changes to SR-IOV parameters don't add a sriov setting to the
    connection."""
    vfs: Optional[List[Vfs]] = field(
        metadata={
            'dbus_name': 'vfs',
            'dbus_type': 'aa{sv}',
            'dbus_inner_class': Vfs,
        },
        default=None,
    )
    """Array of virtual function descriptors.

    Each VF descriptor is a dictionary mapping attribute names to
    GVariant values. The 'index' entry is mandatory for each VF.

    When represented as string a VF is in the form:

    "INDEX [ATTR=VALUE[ ATTR=VALUE]...]".

    for example:

    "2 mac=00:11:22:33:44:55 spoof-check=true".

    Multiple VFs can be specified using a comma as separator. Currently,
    the following attributes are supported: mac, spoof-check, trust,
    min-tx-rate, max-tx-rate, vlans.

    The "vlans" attribute is represented as a semicolon-separated list
    of VLAN descriptors, where each descriptor has the form

    "ID[.PRIORITY[.PROTO]]".

    PROTO can be either 'q' for 802.1Q (the default) or 'ad' for
    802.1ad."""
